/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.enums.AutoAgainst;
import kd.fi.gl.opplugin.AbstractFinalProcessDeleteOp;
import kd.fi.gl.util.FinalProcessUtil;

public class AdjustExchangeRateDeleteOp
extends AbstractFinalProcessDeleteOp {
    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void initializeConfiguration() {
                super.initializeConfiguration();
                this.setEntityKey(AdjustExchangeRateDeleteOp.this.getFinalProcessEntityKey());
            }

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    boolean isAutoAgainst;
                    DynamicObject dynamicObject = dataEntity.getDataEntity();
                    long orgId = dynamicObject.getLong("org.id");
                    long bookTypeId = dynamicObject.getLong("bookstype_id");
                    AccountBookInfo accountBookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
                    long id = (Long)dataEntity.getBillPkId();
                    boolean existVchAfterCurPeriod = FinalProcessUtil.isExistVchAfterCurPeriod((long)id, (long)accountBookInfo.getCurPeriodId());
                    String againstType = dynamicObject.getString("autoagainsttype");
                    boolean bl = isAutoAgainst = AutoAgainst.RED_AGAINST.getValue().equals(againstType) || AutoAgainst.BLUE_AGAINST.getValue().equals(againstType);
                    if (existVchAfterCurPeriod) {
                        if (isAutoAgainst) {
                            this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5728\u5f53\u671f\u6216\u672a\u6765\u671f\u95f4\u751f\u6210\u4e86\u51ed\u8bc1\uff0c\u4e14\u65b9\u6848\u5305\u542b\u4e0b\u671f\u81ea\u52a8\u51b2\u9500\u914d\u7f6e\uff0c\u5982\u5220\u9664\u65b9\u6848\u5c06\u5bfc\u81f4\u5bf9\u5e94\u51b2\u9500\u51ed\u8bc1\u65e0\u6cd5\u751f\u6210\u3002", (String)"AdjustExchangeRateDeleteOp_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u4e86\u51ed\u8bc1", (String)"AdjustExchangeRateDeleteOp_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (!FinalProcessUtil.isExistVoucher((long)id)) continue;
                    this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u4e86\u51ed\u8bc1", (String)"AdjustExchangeRateDeleteOp_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("bookstype");
        fieldKeys.add("autoagainsttype");
    }

    @Override
    protected String getFinalProcessEntityKey() {
        return "gl_adjustexchangerate";
    }
}

