/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.business.service.archive.ArchiveService;
import kd.fi.gl.business.service.ms.Result;
import kd.fi.gl.closeperiod.ClosePeriodUtils;
import kd.fi.gl.closing.ClosingErrorCode;
import kd.fi.gl.constant.AccountBook;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.enums.AccountBooksType;
import kd.fi.gl.enums.GLBillParamEnum;
import kd.fi.gl.helper.service.ms.MServiceHelper;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.SpecialPermItemHelper;

public class AntiClosePeriodOp
extends AbstractOperationServicePlugIn {
    private static final String IS_OPEN_PERIOD = "is_open_period";
    private static final String DELIMITER = "\n";
    private List<DynamicObject> successBooks;
    private List<String> errorMsg;
    private String logMsg;
    private static final Log LOG = LogFactory.getLog(AntiClosePeriodOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        List<Long> selectFakePeriodIds;
        super.beginOperationTransaction(e);
        DynamicObject[] fakeBooks = e.getDataEntities();
        if (fakeBooks.length == 0) {
            return;
        }
        boolean isOpenPeriod = Boolean.TRUE.toString().equalsIgnoreCase(this.getOption().getVariableValue(IS_OPEN_PERIOD, Boolean.FALSE.toString())) || GLBillParamEnum.OPEN_PERIOD.getBooleanValue();
        String selectedPeriodsStrOnOption = this.getOption().getVariableValue("mul_select_period", "");
        if (StringUtils.isNotBlank((CharSequence)selectedPeriodsStrOnOption) && isOpenPeriod) {
            List mulSelectPeriodIds = (List)SerializationUtils.fromJsonString((String)selectedPeriodsStrOnOption, List.class);
            selectFakePeriodIds = mulSelectPeriodIds.stream().map(x -> Long.valueOf(x.toString())).collect(Collectors.toList());
        } else {
            selectFakePeriodIds = Collections.singletonList(fakeBooks[0].getLong("curperiod"));
        }
        this.successBooks = new ArrayList<DynamicObject>(fakeBooks.length);
        this.errorMsg = new ArrayList<String>(fakeBooks.length);
        boolean ignored = this.getOption().containsVariable(ClosingErrorCode.UNINITIALIZE_CURRENT_ACCOUNT_WARN.getCode());
        boolean pass = true;
        if (!ignored) {
            for (DynamicObject fakeBook : fakeBooks) {
                for (Long selectFakePeriodId : selectFakePeriodIds) {
                    long orgId = fakeBook.getLong("org.id");
                    long bookTypeId = fakeBook.getLong("bookstype");
                    long realPeriodId = ClosePeriodUtils.getSelfPeriodIdByPeriodId((long)selectFakePeriodId, (long)bookTypeId, (long)orgId);
                    if (this.uninitializeCurrentAccountCheck(orgId, bookTypeId, realPeriodId)) continue;
                    pass = false;
                }
            }
        }
        if (!pass) {
            return;
        }
        for (DynamicObject singleBook : fakeBooks) {
            Boolean isAnyOperateSuccess = selectFakePeriodIds.stream().map(fakePeriodId -> this.singlePeriodAntiClose(singleBook, (Long)fakePeriodId, isOpenPeriod)).reduce(false, (a, b) -> a != false || b != false);
            if (isAnyOperateSuccess.booleanValue()) {
                this.addSuccessBook(singleBook);
            }
            this.addBatchLog(singleBook, isAnyOperateSuccess, e.getOperationKey());
        }
        if (!this.errorMsg.isEmpty()) {
            this.operationResult.setSuccess(false);
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setMessage(String.join((CharSequence)DELIMITER, this.errorMsg));
            errorInfo.setErrorLevel(ErrorLevel.FatalError.name());
            this.operationResult.addErrorInfo(errorInfo);
        }
        e.setDataEntities(this.successBooks.toArray(new DynamicObject[0]));
    }

    private boolean checkValidityOfReperiodClose(long orgId, long bookId, Long truePeriodId) {
        if (!this.isThereAnyNeedToFilter()) {
            return true;
        }
        Long curUser = UserServiceHelper.getCurrentUserId();
        Long periodUser = this.getUserByAntiClosePeriod(orgId, truePeriodId, bookId);
        return periodUser == null || periodUser == 0L || periodUser.equals(curUser);
    }

    private Long getUserByAntiClosePeriod(long orgID, Long truePeriodId, Long bookID) {
        String state;
        QFilter orgFilter = new QFilter("company", "=", (Object)orgID);
        QFilter bookFilter = new QFilter("accountbooks", "=", (Object)bookID.toString());
        QFilter periodFilter = new QFilter("period", "=", (Object)truePeriodId);
        QFilter bizAppFilter = new QFilter("subsysformnum", "in", (Object)new String[]{"gl_accountbook", "bd_accountbooks"});
        DynamicObject closeStateObject = QueryServiceHelper.queryOne((String)"gl_closestate", (String)"company, period, closestate, closeuser", (QFilter[])new QFilter[]{orgFilter.and(bookFilter).and(periodFilter).and(bizAppFilter)});
        if (null == closeStateObject) {
            return null;
        }
        String successState = "1";
        String failState = "2";
        String defaultState = "0";
        switch (state = closeStateObject.getString("closestate")) {
            case "0": 
            case "2": {
                return null;
            }
            case "1": {
                return closeStateObject.getLong("closeuser");
            }
        }
        return null;
    }

    private boolean isThereAnyNeedToFilter() {
        DynamicObject antiClosePeriod = SpecialPermItemHelper.getInstance().getActivePermController(null, null);
        if (antiClosePeriod == null) {
            return false;
        }
        String id = antiClosePeriod.getString("id");
        Long curUserID = UserServiceHelper.getCurrentUserId();
        return !SpecialPermItemHelper.getInstance().checkUserHasTheSpecialPermItem(curUserID, id);
    }

    private boolean singlePeriodAntiClose(DynamicObject singleBook, Long selectPeriodId, boolean isOpenPeriod) {
        Long orgId = singleBook.getLong("org.id");
        Long bookTypeId = singleBook.getLong("bookstype");
        long realPeriodId = ClosePeriodUtils.getSelfPeriodIdByPeriodId((long)selectPeriodId, (long)bookTypeId, (long)orgId);
        if (realPeriodId <= 0L) {
            this.addErrorMsg(orgId, selectPeriodId, ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u5b58\u5728", (String)"AntiClosePeriodOp_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return false;
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("org", "=", (Object)orgId);
        qfBuilder.add("bookstype", "=", (Object)bookTypeId);
        DynamicObject book = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (QFilter[])qfBuilder.toArray());
        if (null == book) {
            this.addErrorMsg(orgId, selectPeriodId, ResManager.loadKDString((String)"\u8d26\u7c3f\u4e0d\u5b58\u5728", (String)"AntiClosePeriodOp_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return false;
        }
        long startPeriodId = book.getLong(AccountBook.id_((String)"startperiod"));
        long curPeriodId = book.getLong(AccountBook.id_((String)"curperiod"));
        int compareToCurPeriod = ClosePeriodUtils.comparePeriod((Long)realPeriodId, (Long)curPeriodId);
        this.operateOption.setVariableValue("curPeriodId", curPeriodId + "");
        this.operateOption.setVariableValue("realPeriodId", realPeriodId + "");
        this.operateOption.setVariableValue("bookTypeName", book.getDynamicObject("bookstype").getString("name"));
        if (compareToCurPeriod > 0) {
            DynamicObject curPeriodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"name", (QFilter[])new QFilter("id", "=", (Object)curPeriodId).toArray());
            String curPeriodName = curPeriodDyn == null ? "" : curPeriodDyn.getString("name");
            this.addErrorMsg(orgId, realPeriodId, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u4e3a%s\u3002", (String)"AntiClosePeriodOp_2", (String)"fi-gl-opplugin", (Object[])new Object[0]), curPeriodName));
            return false;
        }
        if (compareToCurPeriod == 0) {
            this.addErrorMsg(orgId, realPeriodId, ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u4e3a\u53cd\u7ed3\u671f\u95f4\uff0c\u65e0\u9700\u53cd\u6708\u7ed3\u3002", (String)"AntiClosePeriodOp_3", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (isOpenPeriod && ClosePeriodUtils.comparePeriod((Long)realPeriodId, (Long)startPeriodId) < 0) {
            this.addErrorMsg(orgId, realPeriodId, ResManager.loadKDString((String)"\u6253\u5f00\u7684\u671f\u95f4\u5c0f\u4e8e\u8d26\u7c3f\u542f\u7528\u671f\u95f4", (String)"AntiClosePeriodOp_11", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (ClosePeriodUtils.isHistoryOpenedPeriod((Long)orgId, (Long)bookTypeId, (Long)realPeriodId)) {
            this.addErrorMsg(orgId, realPeriodId, ResManager.loadKDString((String)"\u8be5\u671f\u95f4\u5df2\u53cd\u6708\u7ed3\u3002", (String)"AntiClosePeriodOp_5", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (!this.checkValidityOfReperiodClose(orgId, book.getLong("id"), realPeriodId)) {
            this.addErrorMsg(orgId, realPeriodId, ResManager.loadKDString((String)"\u53cd\u7ed3\u8d26\u4eba\u548c\u7ed3\u8d26\u4eba\u4e0d\u662f\u540c\u4e00\u4e2a\u4eba\u3002", (String)"AntiClosePeriodOp_6", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return false;
        }
        Map<String, Object> map = this.checkReport(book, realPeriodId);
        LOG.info("invoke bcm service, result = {}", map);
        boolean value = (Boolean)map.get("status");
        if (value) {
            this.addErrorMsg(orgId, realPeriodId, (String)map.get("msg"));
            return false;
        }
        if (!this.checkArchivePeriods(orgId, bookTypeId, realPeriodId, curPeriodId)) {
            return false;
        }
        if (isOpenPeriod) {
            return this.updateOpenedPeriodList(orgId, bookTypeId, realPeriodId);
        }
        if (ClosePeriodUtils.comparePeriod((Long)realPeriodId, (Long)startPeriodId) < 0) {
            return this.updateCurperiod(orgId, bookTypeId, startPeriodId);
        }
        return this.updateCurperiod(orgId, bookTypeId, realPeriodId);
    }

    protected boolean checkArchivePeriods(Long orgId, Long bookTypeId, Long realPeriodId, Long curPeriodId) {
        Multimap archiveTypePeriodIdMap = ArchiveService.checkArchivePeriods((Long)orgId, (Long)bookTypeId, (Long)realPeriodId, (Long)curPeriodId, Arrays.asList("gl_rpt_subledger", "gl_rpt_generalledger"));
        if (archiveTypePeriodIdMap.isEmpty()) {
            return true;
        }
        archiveTypePeriodIdMap.forEach((billType, periodId) -> this.addErrorMsg(orgId, (Long)periodId, ResManager.loadKDString((String)"\u5df2\u5f52\u6863\u4e86%s\uff0c\u8bf7\u5148\u53cd\u5f52\u6863\u540e\u91cd\u8bd5", (String)"AntiClosePeriodOp_10", (String)GLApp.instance.oppluginModule(), (Object[])new Object[]{GLUtil.getEntityDisplayName((String)billType)})));
        return false;
    }

    private Map<String, Object> checkReport(DynamicObject book, long realPeriodId) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("status", false);
        if (!AccountBooksType.MAIN_BOOK.getValue().equals(book.getString("bookstype.accounttype"))) {
            return result;
        }
        String orgNum = book.getString("org.number");
        String bookTypeNum = book.getString("bookstype.number");
        DynamicObject periodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)String.join((CharSequence)",", "periodyear", "begindate", "periodnumber"), (QFilter[])new QFilter("id", "=", (Object)realPeriodId).toArray());
        if (Objects.isNull(periodDyn)) {
            return result;
        }
        LOG.info("invoke bcm service, orgNum={}, bookTypeNum={}, periodYear={}, beginDate={}", new Object[]{orgNum, bookTypeNum, periodDyn.getString("periodyear"), periodDyn.getDate("begindate")});
        try {
            HashMap<String, Object> param = new HashMap<String, Object>(5);
            param.put("org", orgNum);
            param.put("book", bookTypeNum);
            param.put("year", periodDyn.getString("periodyear"));
            param.put("period", periodDyn.getString("periodnumber"));
            param.put("date", periodDyn.getDate("begindate"));
            Result invoke = MServiceHelper.invoke((String)"fi", (String)"bcm", (String)"ReportToVoucherMsService", (String)"isAuditted", (Object[])new Object[]{param});
            return (Map)invoke.orElse(result);
        }
        catch (RuntimeException e) {
            LOG.info("invoke_bcm_error:{}", (Object)e.getMessage());
            Result invoke = MServiceHelper.invoke((String)"fi", (String)"bcm", (String)"ReportToVoucherMsService", (String)"isAuditted", (Object[])new Object[]{orgNum, bookTypeNum, periodDyn.getString("periodyear"), periodDyn.getDate("begindate")});
            invoke.ifSuccess(v -> {
                result.put("status", v);
                result.put("msg", ResManager.loadKDString((String)"\u53cd\u7ed3\u8d26\u671f\u95f4\u4e2d\u5b58\u5728\u62a5\u8868\u5df2\u7ecf\u4e0a\u62a5\uff0c\u4e0d\u80fd\u53cd\u7ed3\u8d26\u3002", (String)"AntiClosePeriodOp_7", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            });
            return result;
        }
    }

    private boolean uninitializeCurrentAccountCheck(Long orgId, Long bookTypeId, Long periodId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)bookTypeId);
        QFilter periodFilter = new QFilter("endinitperiod", ">", (Object)periodId);
        DataSet initAccounts = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "#uninitializeCurrentAccountCheck"), (String)"gl_reci_init_state", (String)"endinitperiod, account.number, account.name", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, periodFilter}, null);
        HashMap<Long, List> initPeriodAccountsMap = new HashMap<Long, List>(16);
        for (Row initAccount : initAccounts) {
            List accounts2 = initPeriodAccountsMap.computeIfAbsent(initAccount.getLong("endinitperiod"), k -> new ArrayList());
            accounts2.add(initAccount.getString("account.number") + " " + initAccount.getString("account.name"));
        }
        if (initPeriodAccountsMap.isEmpty()) {
            return true;
        }
        initPeriodAccountsMap.forEach((initPeriodId, accounts) -> this.addWarnMsg(orgId, (Long)initPeriodId, ClosingErrorCode.UNINITIALIZE_CURRENT_ACCOUNT_WARN.getCode(), String.join((CharSequence)",", accounts)));
        return false;
    }

    private void addWarnMsg(Long orgId, Long periodId, String errorCode, String msg) {
        OperateErrorInfo errorInfo = new OperateErrorInfo();
        errorInfo.setLevel(ErrorLevel.Warning);
        errorInfo.setErrorCode(errorCode);
        errorInfo.setMessage(this.formatMsg(orgId, periodId, msg));
        this.getOperationResult().addErrorInfo(errorInfo);
        this.getOperationResult().setSuccess(false);
    }

    protected void addErrorMsg(Long orgId, Long periodId, String errorMsg) {
        this.logMsg = errorMsg;
        this.errorMsg.add(this.formatMsg(orgId, periodId, errorMsg));
    }

    private String formatMsg(Long orgId, Long periodId, String msg) {
        String format = ResManager.loadKDString((String)"%1$s\uff1a%2$s %3$s", (String)"AntiClosePeriodOp_8", (String)"fi-gl-opplugin", (Object[])new Object[0]);
        DynamicObject orgDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"name", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray());
        String orgName = orgDyn == null ? "" : orgDyn.getString("name");
        DynamicObject periodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"name", (QFilter[])new QFilter("id", "=", (Object)periodId).toArray());
        String periodName = periodDyn == null ? "" : periodDyn.getString("name");
        return String.format(format, orgName, periodName, msg);
    }

    private void addSuccessBook(DynamicObject book) {
        this.successBooks.add(book);
    }

    private boolean updateOpenedPeriodList(Long orgId, Long bookTypeId, Long periodId) {
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            DynamicObject openedPeriod = BusinessDataServiceHelper.newDynamicObject((String)"gl_openedperiod");
            openedPeriod.set("org", (Object)orgId);
            openedPeriod.set("booktype", (Object)bookTypeId);
            openedPeriod.set("period", (Object)periodId);
            Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{openedPeriod});
            boolean bl = save.length == 1;
            return bl;
        }
        catch (Exception e) {
            try {
                LOG.error((Throwable)e);
                handle.markRollback();
                this.addErrorMsg(orgId, periodId, e.getMessage());
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private boolean updateCurperiod(Long orgId, Long bookTypeId, Long periodId) {
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            QFilter periodFilter;
            QFilter acctTblFilter;
            QFilter bookTypeFilter;
            QFilter orgFilter;
            boolean exsitFutureAccheckInit;
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("org", "=", (Object)orgId);
            qfBuilder.add("bookstype", "=", (Object)bookTypeId);
            DynamicObject glAccountBook = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (String)"id,accounttable", (QFilter[])qfBuilder.toArray());
            if (glAccountBook == null) {
                this.addErrorMsg(orgId, periodId, ResManager.loadKDString((String)"\u8d26\u7c3f\u4e0d\u5b58\u5728", (String)"AntiClosePeriodOp_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                boolean bl = false;
                return bl;
            }
            boolean existAccTblVersion = BalanceTransferUtils.isAccountTableVersion((Long)orgId, (Long)bookTypeId);
            if (existAccTblVersion && (exsitFutureAccheckInit = QueryServiceHelper.exists((String)"gl_reci_init_state", (QFilter[])new QFilter[]{orgFilter = new QFilter("org", "=", (Object)orgId), bookTypeFilter = new QFilter("booktype", "=", (Object)bookTypeId), acctTblFilter = new QFilter("accounttable", "!=", glAccountBook.get("accounttable_id")), periodFilter = new QFilter("endinitperiod", ">", (Object)periodId)}))) {
                this.addErrorMsg(orgId, periodId, ResManager.loadKDString((String)"\u8d26\u7c3f\u5df2\u8fdb\u884c\u79d1\u76ee\u8868\u7248\u672c\u5316\uff0c\u65e0\u6cd5\u53cd\u521d\u59cb\u5316\u5f80\u6765\u79d1\u76ee\u3002", (String)"AntiClosePeriodOp_9", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                boolean bl = false;
                return bl;
            }
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"gl_accountbook");
            DynamicObject accountBookDO = BusinessDataServiceHelper.loadSingle((Object)glAccountBook.getPkValue(), (DynamicObjectType)type);
            accountBookDO.set("curperiod", (Object)periodId);
            if (accountBookDO.getBoolean("isendinitcashflow") && accountBookDO.getLong(GLField.id_((String)"cashinitperiod")) > periodId) {
                accountBookDO.set("isendinitcashflow", (Object)false);
            }
            Object[] save = BusinessDataWriter.save((IDataEntityType)type, (Object[])new DynamicObject[]{accountBookDO});
            this.antiAccheckAccountEndInit(orgId, bookTypeId, periodId);
            boolean bl = save.length == 1;
            return bl;
        }
        catch (Exception e) {
            try {
                LOG.error((Throwable)e);
                handle.markRollback();
                this.addErrorMsg(orgId, periodId, e.getMessage());
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void antiAccheckAccountEndInit(Long orgId, Long bookTypeId, Long periodId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)bookTypeId);
        QFilter periodFilter = new QFilter("endinitperiod", ">", (Object)periodId);
        DynamicObject[] reciprocalInitStates = BusinessDataServiceHelper.load((String)"gl_reci_init_state", (String)"id, account, isendinit, modifier,modifydate", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, periodFilter});
        Date now = TimeServiceHelper.now();
        Long userId = ContextUtil.getUserId();
        for (DynamicObject reciprocalInitState : reciprocalInitStates) {
            reciprocalInitState.set("isendinit", (Object)false);
            reciprocalInitState.set("modifier", (Object)userId);
            reciprocalInitState.set("modifydate", (Object)now);
        }
        SaveServiceHelper.save((DynamicObject[])reciprocalInitStates);
    }

    private void addBatchLog(DynamicObject singleBook, boolean result, String operationKey) {
        String[] descParams;
        MultiLangEnumBridge opDescBridge;
        String bookTypeName = this.operateOption.getVariableValue("bookTypeName");
        long orgId = singleBook.getLong("org.id");
        DynamicObject curperiodDyn = ClosePeriodUtils.getPeriod((Long)Long.parseLong(this.operateOption.getVariableValue("curPeriodId")), (String)"number");
        DynamicObject previousPeriodDyn = ClosePeriodUtils.getPeriod((Long)Long.parseLong(this.operateOption.getVariableValue("realPeriodId")), (String)"number");
        String curperiodNum = curperiodDyn.getString("number");
        String previousPeriodNum = previousPeriodDyn.getString("number");
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u53cd\u7ed3\u8d26", "AntiClosePeriodOp", "fi-gl-opplugin");
        String opKeyWord = bookTypeName + "," + curperiodNum + "," + previousPeriodNum;
        if (result) {
            opDescBridge = new MultiLangEnumBridge("\u53cd\u7ed3\u8d26\u6210\u529f\uff0c%1$s\uff1a\u64cd\u4f5c\u524d\u671f\u95f4\uff1a%2$s\uff0c\u64cd\u4f5c\u540e\u671f\u95f4\uff1a%3$s", "AntiClosePeriodOpBatchLogSuccess", "fi-gl-opplugin");
            descParams = new String[]{bookTypeName, curperiodNum, previousPeriodNum};
        } else {
            opDescBridge = new MultiLangEnumBridge("\u53cd\u7ed3\u8d26\u5931\u8d25\uff0c%1$s\uff1a%2$s\u3002", "AntiClosePeriodOpBatchLogFail", "fi-gl-opplugin");
            descParams = new String[]{bookTypeName, this.logMsg};
        }
        ClosePeriodUtils.addBatchLog((boolean)result, (String)opKeyWord, (String)operationKey, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (long)orgId, (String[])descParams);
    }
}

