/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class AssgrpDefValValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Long> userids = new HashSet<Long>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection entries;
            Optional<Integer> emptySetupSeq;
            DynamicObject bill = dataEntity.getDataEntity();
            Object pkValue = bill.getPkValue();
            QFilter pkFilter = new QFilter("id", "!=", pkValue);
            long orgid = bill.getLong("org_id");
            long accounttableid = bill.getLong("accounttable_id");
            pkFilter = pkFilter.and(new QFilter("org", "=", (Object)orgid)).and(new QFilter("accounttable", "=", (Object)accounttableid));
            String usertype = bill.getString("usertype");
            DynamicObjectCollection users = bill.getDynamicObjectCollection("muluser");
            if ("1".equalsIgnoreCase(usertype) && users.isEmpty()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u9002\u7528\u4eba\u5458\u3002", (String)"AssgrpDefValValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                return;
            }
            userids.clear();
            for (DynamicObject user : users) {
                userids.add(user.getLong("fbasedataid_id"));
            }
            QFilter userFilter = new QFilter("muluser.fbasedataid", "in", userids).and(new QFilter("usertype", "=", (Object)"1"));
            if ("0".equals(usertype)) {
                userFilter = new QFilter("usertype", "=", (Object)"0");
            }
            if ((emptySetupSeq = (entries = bill.getDynamicObjectCollection("entryentity")).stream().filter(entryRow -> this.isIdNull(entryRow.get("basepk")) && StringUtils.isBlank((CharSequence)entryRow.getString("txtval"))).findAny().map(row -> row.getInt("seq"))).isPresent()) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7b2c%s\u884c\u7684\u6838\u7b97\u7ef4\u5ea6\u503c\u3002", (String)"AssgrpDefValValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0]), emptySetupSeq.get()));
                return;
            }
            HashSet<DefaultValueDim> dimSet = new HashSet<DefaultValueDim>();
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getTypeName(), (String)"gl_assgrpdefval", (String)"entryentity.account, entryentity.assgrptype, entryentity.currency, entryentity.seq", (QFilter[])new QFilter[]{pkFilter, userFilter}, null);){
                while (dataSet.hasNext()) {
                    dimSet.add(new DefaultValueDim(dataSet.next()));
                }
            }
            entries.stream().map(DefaultValueDim::new).filter(dimSet::contains).findAny().ifPresent(dim -> this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u8bbe\u7f6e\u5728\u5f53\u524d\u7ec4\u7ec7\u3001\u79d1\u76ee\u8868\u3001\u5e01\u79cd\u53ca\u4eba\u5458\u914d\u7f6e\u4e0b\u5df2\u7ecf\u5b58\u5728\u3002", (String)"AssgrpDefValValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[0]), dim.seq)));
        }
    }

    private boolean isIdNull(Object pk) {
        String pkStr = pk.toString();
        return StringUtils.isBlank((Object)pk) || "0".equalsIgnoreCase(pkStr);
    }

    private static class DefaultValueDim {
        final long account;
        final long assgrp;
        final long currency;
        public int seq;

        public DefaultValueDim(DynamicObject valueSetupEntryRow) {
            this.account = valueSetupEntryRow.getLong("account_id");
            this.assgrp = valueSetupEntryRow.getLong("assgrptype_id");
            this.currency = valueSetupEntryRow.getLong("currency_id");
            this.seq = valueSetupEntryRow.getInt("seq");
        }

        public DefaultValueDim(Row dataSetRow) {
            this.account = dataSetRow.getLong("entryentity.account");
            this.assgrp = dataSetRow.getLong("entryentity.assgrptype");
            this.currency = dataSetRow.getLong("entryentity.currency");
            this.seq = dataSetRow.getInteger("entryentity.seq");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultValueDim that = (DefaultValueDim)o;
            return this.account == that.account && this.assgrp == that.assgrp && this.currency == that.currency;
        }

        public int hashCode() {
            return Objects.hash(this.account, this.assgrp, this.currency);
        }
    }
}

