/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.gl.opplugin.AutoTransSaveValidator;

public class AutoTransSavePlugin
extends AbstractOperationServicePlugIn {
    private static final String OPTION_KEY_ORG = "option-key-org";
    private static final String CACHE_KEY_DATADELROWIDS = "pagecahce-datadelrow-list";
    private static final String CACHE_KEY_ASSGRPDELROWIDS = "pagecahce-assgrpdelrow-list";
    private static final String CACHE_KEY_PERCENTDELROWIDS = "pagecahce-percentdelrow-list";
    private static final String CACHE_KEY_DATAEXP = "pagecahce-dataexp-map";
    private static final String CACHE_KEY_ASSGRPEXP = "pagecahce-assgrpexp-map";
    private static final String ASSGRPEXP_ROWID_KEY = "assgrprow";
    private static final String DATAEXP_ROWID_KEY = "autorowid";
    private static final String ENTITY_ASSGRP = "gl_finalprocess_assgrp";
    private static final String ENTITY_DATAEXP = "gl_autotransexpression";
    private static final String ENTITY_PERCENTEXP = "gl_autotrans_percent";
    private static final String Key_Entryentity = "autotransentry";
    private static final String Key_Rowid = "autorowid";
    private static final String Key_Datatype = "datasourcetype";
    private static final String Key_PercentType = "percenttype";
    private static final String Key_PercentExp = "percentexp";
    private static final String Key_Account = "accountid";
    private static final String Key_TransType = "transfertype";
    private static final String protransferout = "5";
    private static final String protransferin = "6";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add(Key_Entryentity);
        fieldKeys.add("autorowid");
        fieldKeys.add(Key_Datatype);
        fieldKeys.add(Key_Account);
        fieldKeys.add(Key_TransType);
        e.setFieldKeys(fieldKeys);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AutoTransSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        QFilter orgFilter;
        String rowid;
        DynamicObjectCollection entries;
        ArrayList<DynamicObject> exps;
        ArrayList<String> delRowids;
        ArrayList<Long> orgids;
        String assgrpExpMapStr;
        String dataExpMapStr;
        QFilter rowFilter;
        QFilter orgFilter2;
        String orgVal;
        List rowids;
        String rowidsStr;
        List exps2;
        String expsStr;
        OperateOption option = this.getOption();
        QFilter bills = e.getDataEntities();
        if (option.containsVariable(CACHE_KEY_PERCENTDELROWIDS) && StringUtils.isNotBlank((CharSequence)(expsStr = option.getVariableValue(CACHE_KEY_PERCENTDELROWIDS))) && !(exps2 = (List)SerializationUtils.fromJsonString((String)expsStr, List.class)).isEmpty()) {
            QFilter rowFilter2 = new QFilter("id", "in", (Object)exps2);
            DeleteServiceHelper.delete((String)ENTITY_PERCENTEXP, (QFilter[])new QFilter[]{rowFilter2});
        }
        if (option.containsVariable(CACHE_KEY_DATADELROWIDS) && StringUtils.isNotBlank((CharSequence)(rowidsStr = option.getVariableValue(CACHE_KEY_DATADELROWIDS))) && !(rowids = (List)SerializationUtils.fromJsonString((String)rowidsStr, List.class)).isEmpty()) {
            orgVal = option.getVariableValue(OPTION_KEY_ORG);
            orgFilter2 = new QFilter("org", "=", (Object)Long.valueOf(orgVal));
            rowFilter = new QFilter("autorowid", "in", (Object)rowids);
            DeleteServiceHelper.delete((String)ENTITY_DATAEXP, (QFilter[])new QFilter[]{orgFilter2, rowFilter});
        }
        if (option.containsVariable(CACHE_KEY_ASSGRPDELROWIDS) && StringUtils.isNotBlank((CharSequence)(rowidsStr = option.getVariableValue(CACHE_KEY_ASSGRPDELROWIDS))) && !(rowids = (List)SerializationUtils.fromJsonString((String)rowidsStr, List.class)).isEmpty()) {
            orgVal = option.getVariableValue(OPTION_KEY_ORG);
            orgFilter2 = new QFilter("org", "=", (Object)Long.valueOf(orgVal));
            rowFilter = new QFilter(ASSGRPEXP_ROWID_KEY, "in", (Object)rowids);
            DeleteServiceHelper.delete((String)ENTITY_ASSGRP, (QFilter[])new QFilter[]{orgFilter2, rowFilter});
        }
        Map allDataExpFromCache = null;
        if (option.containsVariable(CACHE_KEY_DATAEXP) && StringUtils.isNotBlank((CharSequence)(dataExpMapStr = option.getVariableValue(CACHE_KEY_DATAEXP)))) {
            allDataExpFromCache = (Map)SerializationUtils.fromJsonString((String)dataExpMapStr, Map.class);
        }
        Map allAssgrpExpFromCache = null;
        if (option.containsVariable(CACHE_KEY_ASSGRPEXP) && StringUtils.isNotBlank((CharSequence)(assgrpExpMapStr = option.getVariableValue(CACHE_KEY_ASSGRPEXP)))) {
            allAssgrpExpFromCache = (Map)SerializationUtils.fromJsonString((String)assgrpExpMapStr, Map.class);
        }
        if (allDataExpFromCache != null && !allDataExpFromCache.isEmpty()) {
            orgids = new ArrayList<Long>(((DynamicObject[])bills).length);
            delRowids = new ArrayList<String>();
            exps = new ArrayList<DynamicObject>();
            MainEntityType dataExpEntityType = EntityMetadataCache.getDataEntityType((String)ENTITY_DATAEXP);
            QFilter qFilter = bills;
            int n = ((DynamicObject[])qFilter).length;
            for (int i = 0; i < n; ++i) {
                DynamicObject bill = qFilter[i];
                orgids.add(bill.getLong("org.id"));
                entries = bill.getDynamicObjectCollection(Key_Entryentity);
                for (DynamicObject row : entries) {
                    rowid = row.getString("autorowid");
                    String type = row.getString(Key_Datatype);
                    if (protransferout.equals(type) || protransferin.equals(type)) {
                        Object dataExpStr = allDataExpFromCache.get(rowid);
                        if (!StringUtils.isNotBlank(dataExpStr)) continue;
                        DynamicObject oldDataExpDyn = AutoTransSavePlugin.fromDynamicString(dataExpStr.toString(), dataExpEntityType);
                        DynamicObject newExpDyn = AutoTransSavePlugin.newDataExpDyn(oldDataExpDyn, dataExpEntityType);
                        exps.add(newExpDyn);
                        delRowids.add(rowid);
                        continue;
                    }
                    delRowids.add(rowid);
                }
            }
            if (!delRowids.isEmpty()) {
                orgFilter = new QFilter("org", "in", orgids);
                QFilter rowFilter3 = new QFilter("autorowid", "in", delRowids);
                DeleteServiceHelper.delete((String)ENTITY_DATAEXP, (QFilter[])new QFilter[]{orgFilter, rowFilter3});
            }
            if (!exps.isEmpty()) {
                SaveServiceHelper.save((IDataEntityType)dataExpEntityType, (Object[])exps.toArray(new DynamicObject[0]));
            }
        }
        if (allAssgrpExpFromCache != null && !allAssgrpExpFromCache.isEmpty()) {
            orgids = new ArrayList(((DynamicObject[])bills).length);
            delRowids = new ArrayList();
            exps = new ArrayList();
            MainEntityType assgrpExpEntityType = EntityMetadataCache.getDataEntityType((String)ENTITY_ASSGRP);
            for (DynamicObject bill : bills) {
                orgids.add(bill.getLong("org.id"));
                entries = bill.getDynamicObjectCollection(Key_Entryentity);
                for (DynamicObject row : entries) {
                    rowid = row.getString("autorowid");
                    Object assgrpExpStr = allAssgrpExpFromCache.get(rowid);
                    if (!StringUtils.isNotBlank(assgrpExpStr)) continue;
                    DynamicObject oldAssgrpExpDyn = AutoTransSavePlugin.fromDynamicString(assgrpExpStr.toString(), assgrpExpEntityType);
                    DynamicObject newExpDyn = this.newAssgrpExpDyn(oldAssgrpExpDyn, assgrpExpEntityType);
                    exps.add(newExpDyn);
                    delRowids.add(rowid);
                }
            }
            if (!delRowids.isEmpty()) {
                orgFilter = new QFilter("org", "in", orgids);
                QFilter rowFilter4 = new QFilter(ASSGRPEXP_ROWID_KEY, "in", delRowids);
                DeleteServiceHelper.delete((String)ENTITY_ASSGRP, (QFilter[])new QFilter[]{orgFilter, rowFilter4});
            }
            if (!exps.isEmpty()) {
                SaveServiceHelper.save((IDataEntityType)assgrpExpEntityType, (Object[])exps.toArray(new DynamicObject[0]));
            }
        }
        ArrayList<Long> percentexps = new ArrayList<Long>();
        for (DynamicObject bill : bills) {
            entries = bill.getDynamicObjectCollection(Key_Entryentity);
            for (DynamicObject row : entries) {
                String ptype = row.getString(Key_PercentType);
                if ("1".equalsIgnoreCase(ptype)) continue;
                percentexps.add(row.getLong(Key_PercentExp));
                row.set(Key_PercentExp, (Object)0L);
            }
        }
        if (!percentexps.isEmpty()) {
            QFilter rowFilter5 = new QFilter("id", "in", percentexps);
            DeleteServiceHelper.delete((String)ENTITY_PERCENTEXP, (QFilter[])new QFilter[]{rowFilter5});
        }
    }

    private static DynamicObject newDataExpDyn(DynamicObject oldAutoDyn, MainEntityType entityType) {
        DynamicObject newExpDyn = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_DATAEXP);
        newExpDyn.set("org", (Object)oldAutoDyn.getLong("org_id"));
        newExpDyn.set("autorowid", (Object)oldAutoDyn.getString("autorowid"));
        newExpDyn.set("account", (Object)oldAutoDyn.getDynamicObject("account"));
        newExpDyn.set("assgrp", (Object)oldAutoDyn.getDynamicObject("assgrp"));
        newExpDyn.set("currency", (Object)oldAutoDyn.getDynamicObject("currency"));
        newExpDyn.set("unit", (Object)oldAutoDyn.getDynamicObject("unit"));
        newExpDyn.set("qty", (Object)oldAutoDyn.getBigDecimal("qty"));
        newExpDyn.set("amounttype", (Object)oldAutoDyn.getString("amounttype"));
        newExpDyn.set("periodrange", (Object)oldAutoDyn.getString("periodrange"));
        ((BillEntityType)oldAutoDyn.getDataEntityType()).getAllFields().keySet().stream().filter(key -> key.startsWith("comassist")).forEach(comAssistKey -> {
            newExpDyn.set(comAssistKey, (Object)oldAutoDyn.getDynamicObjectCollection(comAssistKey));
            newExpDyn.getDynamicObjectCollection(comAssistKey).forEach(comAssistDyo -> {
                long baseDataId = comAssistDyo.getLong("fbasedataid_id");
                comAssistDyo.set("fbasedataid_id", (Object)0);
                comAssistDyo.set("fbasedataid_id", (Object)baseDataId);
            });
        });
        return newExpDyn;
    }

    private DynamicObject newAssgrpExpDyn(DynamicObject oldAssgrpDyn, MainEntityType entityType) {
        DynamicObject newExpDyn = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ASSGRP);
        newExpDyn.set("org", (Object)oldAssgrpDyn.getLong("org_id"));
        newExpDyn.set(ASSGRPEXP_ROWID_KEY, (Object)oldAssgrpDyn.getString(ASSGRPEXP_ROWID_KEY));
        DynamicObjectCollection newColl = newExpDyn.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection coll = oldAssgrpDyn.getDynamicObjectCollection("entryentity");
        newColl.clear();
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject row = (DynamicObject)coll.get(i);
            DynamicObject newRow = new DynamicObject(coll.getDynamicObjectType());
            newRow.set("fieldname", row.get("fieldname_id"));
            String valueType = row.getDynamicObject("fieldname").getString("valuetype");
            if ("3".equals(valueType)) {
                newRow.set("txtval", (Object)row.getString("txtval"));
            } else {
                DynamicObjectCollection mulBaseColl = row.getDynamicObjectCollection("value");
                DynamicObjectCollection newMulBaseColl = newRow.getDynamicObjectCollection("value");
                for (DynamicObject mulRow : mulBaseColl) {
                    long id = mulRow.getLong("fbasedataid_id");
                    DynamicObject mulBaseRow = new DynamicObject(mulBaseColl.getDynamicObjectType());
                    mulBaseRow.set("fbasedataid", (Object)id);
                    newMulBaseColl.add((Object)mulBaseRow);
                }
                newRow.set("value", (Object)newMulBaseColl);
            }
            newColl.add((Object)newRow);
        }
        return newExpDyn;
    }

    private static DynamicObject fromDynamicString(String value, MainEntityType entityType) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)entityType);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        jser.setSerializeComplexProperty(true);
        binder.setOnlyDbProperty(false);
        return (DynamicObject)jser.deserializeFromString(value, null);
    }
}

