/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.adaptor.CodeRuleSignerFactory;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.fi.gl.closeperiod.breakpoint.BreakPointCommonUtil;
import kd.fi.gl.lock.Lock;
import kd.fi.gl.lock.LockKey;
import kd.fi.gl.opplugin.SaveVoucherThread;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLBreakPointUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.voucher.VoucherNumberUtils;

public class CheckBreakPointOp
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(CheckBreakPointOp.class);
    private static final int PAGESIZE = 20000;
    private static final int NUMLEN = 30;
    private final LinkedHashSet<String> list = new LinkedHashSet();

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dyos = e.getDataEntities();
        this.getOperationResult().getSuccessPkIds().clear();
        for (DynamicObject d : dyos) {
            String bookstype;
            String curperiod;
            String org;
            String id = d.getString("id");
            DynamicObject dyo = !"0".equals(id) ? BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_voucher")) : d;
            if (dyo == null) {
                this.operationResult.setSuccess(false);
                this.operationResult.setMessage(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u51ed\u8bc1\u4e0d\u5b58\u5728\u3002", (String)"CheckBreakPointOp_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                return;
            }
            if (dyo.get("org") == null) {
                this.operationResult.setSuccess(false);
                this.operationResult.setMessage(ResManager.loadKDString((String)"\u4f20\u5165\u65f6\u7ec4\u7ec7\u65e0\u6cd5\u83b7\u53d6\u3002", (String)"CheckBreakPointOp_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                return;
            }
            if (dyo.get("period") == null) {
                this.operationResult.setSuccess(false);
                this.operationResult.setMessage(ResManager.loadKDString((String)"\u4f20\u5165\u65f6\u671f\u95f4\u65e0\u6cd5\u83b7\u53d6\u3002", (String)"CheckBreakPointOp_2", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                return;
            }
            if (dyo.get("booktype") == null) {
                this.operationResult.setSuccess(false);
                this.operationResult.setMessage(ResManager.loadKDString((String)"\u4f20\u5165\u65f6\u8d26\u7c3f\u7c7b\u578b\u65e0\u6cd5\u83b7\u53d6\u3002", (String)"CheckBreakPointOp_3", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                return;
            }
            if (dyo.get("org") instanceof DynamicObject) {
                org = ((DynamicObject)dyo.get("org")).getString("id");
                curperiod = ((DynamicObject)dyo.get("period")).getString("id");
                bookstype = ((DynamicObject)dyo.get("booktype")).getString("id");
            } else {
                org = dyo.getString("org");
                curperiod = dyo.getString("period");
                bookstype = dyo.getString("booktype");
            }
            boolean locked = Lock.tryLock((long)Long.parseLong(org), (long)Long.parseLong(bookstype), (LockKey)LockKey.ClosePeriod, () -> this.adjustBreakPoint(org, curperiod, bookstype, dyo));
            if (locked) continue;
            this.operationResult.setSuccess(false);
            this.operationResult.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u7c3f\u6b63\u5728\u8c03\u6574\u65ad\u53f7\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)GLApp.instance.oppluginModule(), (String)"CheckBreakPointOp_100", (Object[])new Object[0]));
        }
    }

    private void adjustBreakPoint(String org, String curperiod, String bookstype, DynamicObject dyo) {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        if (this.list.contains(org + bookstype + curperiod)) {
            return;
        }
        this.list.add(org + bookstype + curperiod);
        map.put("orgId", org);
        map.put("period", curperiod);
        map.put("booktype", bookstype);
        CodeRuleInfo coderule = VoucherNumberUtils.getCodeRuleInfo((Long)Long.parseLong(org), (String)"B");
        if (coderule == null) {
            this.operationResult.setSuccess(false);
            OperateErrorInfo error = new OperateErrorInfo();
            error.setMessage(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6ca1\u6709\u8bbe\u7f6e\u51ed\u8bc1\u63d0\u4ea4\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u8bbe\u7f6e\u7f16\u7801\u89c4\u5219\u3002", (String)"CheckBreakPointOp_4", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            this.operationResult.addErrorInfo(error);
            return;
        }
        map.put("condition", VoucherNumberUtils.isOnlyForSubmit((CodeRuleInfo)coderule));
        DynamicObjectCollection ruleEntry = GLBreakPointUtil.getCodeRuleEntry((CodeRuleInfo)coderule);
        List codeRuleEntryAttributes = GLBreakPointUtil.getAttributeFromCodeRuleEntry((DynamicObjectCollection)ruleEntry);
        List issortitemFields = GLBreakPointUtil.getIssortitemFields((List)codeRuleEntryAttributes, (boolean)false);
        List issortitemTrueFields = GLBreakPointUtil.getIssortitemFields((List)codeRuleEntryAttributes, (boolean)true);
        try {
            long tick = System.currentTimeMillis();
            this.adjustByOrgPeriod(map, issortitemFields, issortitemTrueFields, codeRuleEntryAttributes, coderule, dyo);
            LOGGER.info("checkBreakPoint_adjustByOrgPeriod cost:" + (System.currentTimeMillis() - tick));
        }
        catch (Exception e) {
            LOGGER.error(dyo.get("org") + ": \u6267\u884c\u65ad\u53f7\u8c03\u6574\u5931\u8d25", (Throwable)e);
            this.operationResult.setMessage(GLUtil.printError((Throwable)e));
            this.operationResult.setSuccess(false);
        }
    }

    private DynamicObject buildVoucherBreakPointFromRow(Row voucherRow, MainEntityType voucherBreakPointType, Date curtime, String newvoucherno) {
        DynamicObject voucherBreakPoint = BreakPointCommonUtil.buildVoucherBreakPointFromRow((Row)voucherRow, (MainEntityType)voucherBreakPointType);
        voucherBreakPoint.set("adjuster", (Object)RequestContext.get().getCurrUserId());
        voucherBreakPoint.set("adjustdate", (Object)curtime);
        voucherBreakPoint.set("curvoucherno", (Object)newvoucherno);
        voucherBreakPoint.set("newvoucherno", (Object)newvoucherno);
        return voucherBreakPoint;
    }

    private void adjustByOrgPeriod(Map<String, Object> paramMap, List<Map<String, String>> issortitemFields, List<Map<String, String>> issortitemTrueFields, List<HashMap<String, String>> codeRuleEntryAttributes, CodeRuleInfo coderule, DynamicObject dyo) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        int dateordertype = Integer.parseInt(this.getOption().getVariableValue("bookeddateorder"));
        long sTick = System.currentTimeMillis();
        try (DataSet voucherDataset = GLBreakPointUtil.queryVoucherDataset(paramMap, codeRuleEntryAttributes, null, (int)1, (int)1, (int)dateordertype);){
            if (!voucherDataset.hasNext()) {
                LOGGER.info(String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7\u5728%2$s%3$s\u671f\u95f4\u6ca1\u6709\u9700\u8981\u68c0\u67e5\u7684\u51ed\u8bc1\u3002", (String)"CheckBreakPointOp_5", (String)"fi-gl-opplugin", (Object[])new Object[0]), dyo.get("org") instanceof DynamicObject ? ((DynamicObject)dyo.get("org")).getString("name") : dyo.get("org"), dyo.get("booktype") instanceof DynamicObject ? ((DynamicObject)dyo.get("booktype")).getString("name") : dyo.get("booktype"), dyo.get("period") instanceof DynamicObject ? ((DynamicObject)dyo.get("period")).getString("name") : dyo.get("period")));
                return;
            }
            HashMap<String, Integer> itemSortSerialmap = new HashMap<String, Integer>();
            HashMap<String, Integer> maxSerialmap = new HashMap<String, Integer>();
            LinkedList<Object> paramList = new LinkedList<Object[]>();
            LinkedList<Object> voucherBreakPointList = new LinkedList<DynamicObject>();
            MainEntityType voucherBreakPointType = EntityMetadataCache.getDataEntityType((String)"gl_voucherbreakpoint");
            Date curtime = new Date();
            while (voucherDataset.hasNext()) {
                int lengthOfSerial;
                if (paramList.size() == 20000) {
                    Future future = ThreadService.submit((Callable)new SaveVoucherThread(paramList, voucherBreakPointList), (TaskType)TaskType.GL_CHECK_POINT_SAVE_VOUCHER);
                    resultList.add(future);
                    paramList = new LinkedList();
                    voucherBreakPointList = new LinkedList();
                }
                Object[] params = new Object[2];
                Row row = voucherDataset.next();
                String number = row.getString("billno");
                StringBuilder issortitemValues = new StringBuilder();
                HashMap<String, Object> voucherInfo = new HashMap<String, Object>(issortitemTrueFields.size());
                for (Map<String, String> fieldmap : issortitemTrueFields) {
                    String field = fieldmap.get("valueatribute");
                    voucherInfo.put(field, row.get(field));
                }
                for (Map<String, String> fieldmap : issortitemFields) {
                    if (issortitemValues.length() != 0) {
                        issortitemValues.append("_split_");
                    }
                    issortitemValues.append(GLBreakPointUtil.getOneSortItemString(fieldmap, voucherInfo));
                }
                String issortitemvalue = issortitemValues.toString();
                if (StringUtils.isEmpty((CharSequence)issortitemvalue)) {
                    issortitemvalue = "_split_";
                }
                int curSerial = itemSortSerialmap.get(issortitemvalue) == null ? 1 : (Integer)itemSortSerialmap.get(issortitemvalue);
                Map m = GLBreakPointUtil.resetBreakNumber((String)coderule.getId(), (String)String.valueOf(curSerial), voucherInfo);
                String resetNumber = (String)m.get("resetNumber");
                if (resetNumber.length() > 30) {
                    this.operationResult.setSuccess(false);
                    String message = String.format(ResManager.loadKDString((String)"\u6309\u7f16\u7801\u89c4\u5219\u751f\u6210\u7684\u7f16\u7801\u4e3a%1$s,\u957f\u5ea6\u5927\u4e8e\u51ed\u8bc1\u7f16\u7801\u89c4\u5b9a\u957f\u5ea6%2$d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u7f16\u7801\u89c4\u5219\u3002", (String)"CheckBreakPointOp_7", (String)"fi-gl-opplugin", (Object[])new Object[0]), resetNumber, 30);
                    OperateErrorInfo error = new OperateErrorInfo();
                    error.setLevel(ErrorLevel.Error);
                    error.setMessage(message);
                    this.operationResult.addErrorInfo(error);
                    this.operationResult.setMessage(message);
                    return;
                }
                int indexOfSerial = Integer.parseInt((String)m.get("indexOfSerial"));
                boolean ismatch = GLBreakPointUtil.isMatchCodeRule((String)number, (String)resetNumber, (int)indexOfSerial, (int)(lengthOfSerial = Integer.parseInt((String)m.get("lengthOfSerial"))));
                if (ismatch) {
                    int maxSerial = Integer.parseInt(number.substring(indexOfSerial, indexOfSerial + lengthOfSerial));
                    if (maxSerialmap.get(issortitemvalue) == null) {
                        maxSerialmap.put(issortitemvalue, maxSerial);
                    } else if ((Integer)maxSerialmap.get(issortitemvalue) < maxSerial) {
                        maxSerialmap.put(issortitemvalue, maxSerial);
                    }
                }
                if (!Objects.equals(resetNumber, number)) {
                    long vid = row.getLong("id");
                    params[0] = resetNumber;
                    params[1] = vid;
                    paramList.add(params);
                    DynamicObject voucherBreakPoint = this.buildVoucherBreakPointFromRow(row, voucherBreakPointType, curtime, resetNumber);
                    voucherBreakPointList.add(voucherBreakPoint);
                }
                itemSortSerialmap.put(issortitemvalue, curSerial + 1);
                if (voucherDataset.hasNext()) continue;
                Future future = ThreadService.submit((Callable)new SaveVoucherThread(paramList, voucherBreakPointList), (TaskType)TaskType.GL_CHECK_POINT_SAVE_VOUCHER);
                resultList.add(future);
            }
            for (Future future : resultList) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            LOGGER.info("finished_adjust_period cost:" + (System.currentTimeMillis() - sTick));
            long delTick = System.currentTimeMillis();
            try (TXHandle h = TX.requiresNew();){
                try {
                    for (Map.Entry entry : itemSortSerialmap.entrySet()) {
                        Integer serial = (Integer)entry.getValue();
                        if (serial == null || serial <= 0) continue;
                        CodeRuleServiceHelper.consumeIntermitNumber((CodeRuleInfo)coderule, (String)((String)entry.getKey()), (int)-1);
                        boolean success = CodeRuleServiceHelper.updateNumber((CodeRuleInfo)coderule, (String)((String)entry.getKey()), (int)(serial - 1));
                        if (success) continue;
                        CodeRuleSignerFactory.newInstance((CodeRuleInfo)coderule).reset(coderule.getId(), (String)entry.getKey(), (long)(serial - 1));
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                    h.markRollback();
                    throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u6700\u5927\u53f7\u8868\u53ca\u65ad\u53f7\u8868\u6570\u636e\u5904\u7406\u5f02\u5e38\uff0c\u8bf7\u624b\u5de5\u5904\u7406\u3002", (String)"CheckBreakPointOp_8", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
                }
            }
            LOGGER.info("consume_intermit_number cost:" + (System.currentTimeMillis() - delTick));
            LOGGER.info("recycle_number cost:" + (System.currentTimeMillis() - delTick));
        }
    }
}

