/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.balcal.BalExtendTrigger;
import kd.fi.gl.balcal.log.BalChangeAction;
import kd.fi.gl.balcal.log.DataChangeLog;
import kd.fi.gl.business.dao.balance.BalanceDelLogDao;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.interfaces.service.bal.log.BalChangeLogger;
import kd.fi.gl.lock.Lock;
import kd.fi.gl.lock.LockKey;
import kd.fi.gl.util.GLUtil;
import kd.sdk.fi.gl.extpoint.bal.BalKey;

public abstract class CloseInitOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CloseInitOp.class);
    protected List<CommonAssist> commonAssists = new ArrayList<CommonAssist>(2);
    protected Collection<LocalCurrencyConfigVO> localCurList = new ArrayList<LocalCurrencyConfigVO>(3);
    private final BalChangeLogger balLogger = BalChangeLogger.create();

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(this.getCloseInitValidator());
    }

    protected abstract AbstractValidator getCloseInitValidator();

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject book : e.getDataEntities()) {
            this.endInit(book);
        }
    }

    private void endInit(DynamicObject book) {
        long orgId = book.getLong(GLField.id_((String)"org"));
        long bookTypeId = book.getLong(GLField.id_((String)"bookstype"));
        this.initComassist(book);
        this.initMulCur(book);
        Date updateTime = new Date();
        if (!Lock.tryLock((long)orgId, (long)bookTypeId, (LockKey)this.getLockKey(), () -> this.updateBalance(book))) {
            OperateErrorInfo error = new OperateErrorInfo();
            error.setLevel(ErrorLevel.Error);
            error.setMessage(ResManager.loadKDString((String)"\u6709\u51ed\u8bc1\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CloseInitOp_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            this.getOperationResult().addErrorInfo(error);
            return;
        }
        BalExtendTrigger.updateBal((long)orgId, (long)bookTypeId, (Date)updateTime, (boolean)"gl_balance".equals(this.getFormId()));
        this.saveInitFlag(book);
    }

    protected void initMulCur(DynamicObject book) {
        this.localCurList = LocalCurrencyConfigService.queryEnableCurrencies();
    }

    protected void initComassist(DynamicObject book) {
        ComAssistTable table = ComAssistTable.get((Long)book.getLong(GLField.id_((String)"accounttable")));
        this.commonAssists = table.getCommonAssists();
    }

    protected void doUpdate(DynamicObject book) {
    }

    protected String getComfield() {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= this.commonAssists.size(); ++i) {
            sb.append(",comassist").append(i);
        }
        return sb.toString();
    }

    protected void updateBalance(DynamicObject book) {
        if ("gl_balance".equals(this.getFormId())) {
            this.doUpdate(book);
            return;
        }
        MainEntityType balType = EntityMetadataCache.getDataEntityType((String)this.getFormId());
        ArrayList<DynamicObject> objList = new ArrayList<DynamicObject>();
        ArrayList<Object> rmvList = new ArrayList<Object>();
        ArrayList<Object> rmvInitList = new ArrayList<Object>(10);
        ArrayList<BalKey> delDemension = new ArrayList<BalKey>(10);
        HashMap<String, DataChangeLog> id2Log = new HashMap<String, DataChangeLog>(256);
        try (DataSet balance = this.getInitData(book);){
            while (balance.hasNext()) {
                DynamicObject obj;
                Row initBal = balance.next();
                if ("gl_cashflow".equals(this.getFormId()) && initBal.getBoolean("tabdelete").booleanValue()) {
                    rmvInitList.add(initBal.get("id"));
                }
                if (!(this.setBalanceUpdParam(book, initBal, balType, objList, rmvList, delDemension, id2Log) || "gl_cashflow".equals(this.getFormId()) && initBal.getBoolean("tabdelete").booleanValue() || (obj = this.newBalance(initBal, book, GLUtil.MAX_PERIOD)) == null)) {
                    objList.add(obj);
                }
                if (rmvList.size() <= 500 && objList.size() <= 500 && rmvInitList.size() <= 500) continue;
                if (!rmvList.isEmpty()) {
                    Object[] pks = rmvList.toArray();
                    this.balLogger.recordRemoveData("T_GL_CASHFLOW", pks, id2Log, BalChangeAction.END_INIT);
                    BusinessDataWriter.delete((IDataEntityType)balType, (Object[])pks);
                    if (DebugTrace.enable()) {
                        logger.info("A Delete Cashflow Balance\uff1a" + rmvList);
                    }
                    rmvList.clear();
                }
                if (!objList.isEmpty()) {
                    this.doDataUpdate(balType, objList);
                    objList.clear();
                }
                if (rmvInitList.isEmpty()) continue;
                this.deleteInitCashFlow(rmvInitList);
                rmvInitList.clear();
            }
            if (!rmvList.isEmpty()) {
                Object[] pks = rmvList.toArray();
                this.balLogger.recordRemoveData("T_GL_CASHFLOW", pks, id2Log, BalChangeAction.END_INIT);
                BusinessDataWriter.delete((IDataEntityType)balType, (Object[])pks);
                if (DebugTrace.enable()) {
                    logger.info("A Delete Cashflow Balance\uff1a" + rmvList);
                }
                rmvList.clear();
            }
            if (!objList.isEmpty()) {
                BusinessDataWriter.save((IDataEntityType)balType, (Object[])objList.toArray());
                List collect = objList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
                if (DebugTrace.enable()) {
                    logger.info("B Update Cashflow Balance\uff1a" + collect);
                }
                objList.clear();
            }
            if (!rmvInitList.isEmpty()) {
                this.deleteInitCashFlow(rmvInitList);
            }
            if (!delDemension.isEmpty()) {
                BalExtendTrigger.delBal((long)book.getLong("org_id"), (long)book.getLong("bookstype_id"), delDemension, (boolean)false);
                BalanceDelLogDao.saveCfitemLog((long)book.getLong("org_id"), (long)book.getLong("bookstype_id"), delDemension);
                delDemension.clear();
            }
        }
    }

    void doDataUpdate(MainEntityType balType, List<DynamicObject> objList) {
        ArrayList<DynamicObject> inserts = new ArrayList<DynamicObject>(objList.size() / 2);
        ArrayList<DynamicObject> updates = new ArrayList<DynamicObject>(objList.size() / 2);
        for (DynamicObject bal : objList) {
            if (Objects.isNull(bal.getPkValue()) || bal.getPkValue().equals(0L)) {
                inserts.add(bal);
                continue;
            }
            updates.add(bal);
        }
        long[] ids = ORM.create().genLongIds((IDataEntityType)balType, inserts.size());
        ISimpleProperty primaryKey = balType.getPrimaryKey();
        for (int i = 0; i < inserts.size(); ++i) {
            primaryKey.setValueFast(inserts.get(i), (Object)ids[i]);
        }
        this.balLogger.recordInsertDyo("T_GL_CASHFLOW", inserts, BalChangeAction.END_INIT, this.commonAssists.size());
        this.balLogger.recordInitUpdateCF(updates, this.commonAssists.size());
        BusinessDataWriter.save((IDataEntityType)balType, (Object[])objList.toArray());
        List collect = objList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        if (DebugTrace.enable()) {
            logger.info("B Update Cashflow Balance\uff1a" + collect);
        }
    }

    private void deleteInitCashFlow(List<Object> rmvInitList) {
        if ("gl_cashflow".equals(this.getFormId())) {
            MainEntityType initCashFlowType = EntityMetadataCache.getDataEntityType((String)"gl_initcashflow");
            BusinessDataWriter.delete((IDataEntityType)initCashFlowType, (Object[])rmvInitList.toArray());
            if (DebugTrace.enable()) {
                logger.info("C\u5220\u9664\u7684\u521d\u59cb\u5316\u6570\u636e\uff1a" + rmvInitList);
            }
            rmvInitList.clear();
        }
    }

    protected abstract DataSet getInitData(DynamicObject var1);

    protected abstract boolean setBalanceUpdParam(DynamicObject var1, Row var2, MainEntityType var3, List<DynamicObject> var4, List<Object> var5, List<BalKey> var6, Map<String, DataChangeLog> var7);

    protected abstract void saveInitFlag(DynamicObject var1);

    protected abstract DynamicObject newBalance(Row var1, DynamicObject var2, long var3);

    protected abstract String getFormId();

    protected abstract LockKey getLockKey();
}

