/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;

public class GLAccountBookDeleteValidator
extends AbstractValidator {
    private static final String GL_CASHBALANCE = "gl_cashflow";
    private static final String GL_INITACCCURRENT = "gl_initacccurrent";
    private static final String GL_RECI_INIT_STATE = "gl_reci_init_state";
    private static final EntityOrgAcctTypeTriple[] EntityToCheckRef = new EntityOrgAcctTypeTriple[]{new EntityOrgAcctTypeTriple("gl_transplprogram", "book"), new EntityOrgAcctTypeTriple("gl_autotrans", "bookstype"), new EntityOrgAcctTypeTriple("gl_adjustexchangerate", "bookstype"), new EntityOrgAcctTypeTriple("gl_voucheramortacheme", "accountbooks"), new EntityOrgAcctTypeTriple("ai_vchtemplate", "createorg", "booktype")};

    public void validate() {
        DistributeCache cache = new DistributeCache(CacheModule.book);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject book = dataEntity.getDataEntity();
            if (!book.getBoolean("isbizunit")) continue;
            long orgid = book.getDynamicObject("org").getLong("id");
            long booktype = Optional.ofNullable(book.getDynamicObject("bookstype")).map(r -> r.getLong("id")).orElse(0L);
            this.validatorBalance(dataEntity, orgid, booktype, book.getBoolean("isendinit"));
            this.validatorCashBalance(dataEntity, orgid, booktype, book.getBoolean("isendinitcashflow"));
            this.validatorACBalance(dataEntity, orgid, booktype);
            String validateRes = this.validateRef(orgid, booktype);
            if (StringUtils.isEmpty((CharSequence)validateRes)) continue;
            this.addErrorMessage(dataEntity, validateRes);
        }
    }

    private String validateRef(long orgid, long booktype) {
        StringBuilder result = new StringBuilder();
        for (EntityOrgAcctTypeTriple triple : EntityToCheckRef) {
            QFilter orgFlt = new QFilter(triple.orgProp, "=", (Object)orgid);
            QFilter bookTypeFlt = new QFilter(triple.bookTypeProp, "=", (Object)booktype);
            boolean isExist = QueryServiceHelper.exists((String)triple.entityProp, (QFilter[])new QFilter[]{orgFlt, bookTypeFlt});
            if (!isExist) continue;
            result.append(this.getMsgOnSchemeExist(triple.entityProp, orgid, booktype)).append("\n");
        }
        return result.toString();
    }

    private String getMsgOnSchemeExist(String entityProp, long orgid, long bookTypeID) {
        String localName = MetadataServiceHelper.getDataEntityType((String)entityProp).getDisplayName().getLocaleValue();
        String orgNumber = BusinessDataServiceHelper.loadSingleFromCache((Object)orgid, (String)"bos_org").getString("number");
        String bookTypeNumber = BusinessDataServiceHelper.loadSingleFromCache((Object)bookTypeID, (String)"bd_accountbookstype").getString("number");
        return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a %1$s \u7684\u7ec4\u7ec7\u5728\u7f16\u7801\u4e3a %2$s \u7684\u8d26\u7c3f\u7c7b\u578b\u4e0b\u5b58\u5728%3$s\uff0c\u8bf7\u5220\u9664\u5df2\u5b58\u5728\u7684\u65b9\u6848\u540e\u5220\u9664\u8d26\u7c3f\u3002", (String)"GLAccountBookDeleteValidator_5", (String)"fi-gl-opplugin", (Object[])new Object[0]), orgNumber, bookTypeNumber, localName);
    }

    private void validatorBalance(ExtendedDataEntity dataEntity, long orgid, long booktype, boolean isEndInit) {
        QFilter booktypeQF;
        QFilter orgQF = new QFilter("org", "=", (Object)orgid);
        if (QueryServiceHelper.exists((String)"gl_initbalance", (QFilter[])new QFilter[]{orgQF, booktypeQF = new QFilter("booktype", "=", (Object)booktype)}) || isEndInit) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u79d1\u76ee\u4f59\u989d\u521d\u59cb\u5316\u6570\u636e \u6216 \u7ed3\u675f\u4e86\u79d1\u76ee\u4f59\u989d\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u5220\u9664\u8d26\u7c3f\u3002", (String)"GLAccountBookDeleteValidator_3", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    private void validatorCashBalance(ExtendedDataEntity dataEntity, long orgid, long booktype, boolean isInitCash) {
        QFilter booktypeQF;
        QFilter orgQF = new QFilter("org", "=", (Object)orgid);
        if (QueryServiceHelper.exists((String)GL_CASHBALANCE, (QFilter[])new QFilter[]{orgQF, booktypeQF = new QFilter("booktype", "=", (Object)booktype)}) || isInitCash) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u6570\u636e \u6216 \u7ed3\u675f\u4e86\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u5220\u9664\u8d26\u7c3f\u3002", (String)"GLAccountBookDeleteValidator_4", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    private void validatorACBalance(ExtendedDataEntity dataEntity, long orgid, long booktype) {
        QFilter orgQF = new QFilter("org", "=", (Object)orgid);
        QFilter booktypeQF = new QFilter("booktype", "=", (Object)booktype);
        boolean initExist = QueryServiceHelper.exists((String)GL_INITACCCURRENT, (QFilter[])new QFilter[]{orgQF, booktypeQF});
        boolean stateExist = QueryServiceHelper.exists((String)GL_RECI_INIT_STATE, (QFilter[])new QFilter[]{orgQF, booktypeQF});
        if (initExist || stateExist) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u5f80\u6765\u521d\u59cb\u5316\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664\u8d26\u7c3f\u3002", (String)"GLAccountBookDeleteValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    protected static class EntityOrgAcctTypeTriple {
        private final String entityProp;
        private final String orgProp;
        private final String bookTypeProp;

        public EntityOrgAcctTypeTriple(String entityProp, String orgProp, String bookTypeProp) {
            this.entityProp = entityProp;
            this.orgProp = orgProp;
            this.bookTypeProp = bookTypeProp;
        }

        public EntityOrgAcctTypeTriple(String entityProp, String bookTypeProp) {
            this.entityProp = entityProp;
            this.orgProp = "org";
            this.bookTypeProp = bookTypeProp;
        }
    }
}

