/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.business.vo.MetaField;
import kd.fi.bd.consts.MCT;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.opplugin.InitBalanceSaveValidator;
import kd.fi.gl.util.GLApp;

public class InitBalSaveUtil {
    public static List<String> getMulLocalAmtSelector(Collection<LocalCurrencyConfigVO> configs, MCT ... mct) {
        LinkedList<String> selectFields = new LinkedList<String>();
        configs.stream().map(config -> config.getInitBalanceFields(mct)).forEach(fields -> fields.stream().map(MetaField::getMetaId).forEach(selectFields::add));
        return selectFields;
    }

    public static void checkMLBeginEnd(ExtendedDataEntity dynExt, AccountBookInfo book, InitBalanceSaveValidator validator) {
        DynamicObject dyn = dynExt.getDataEntity();
        LocalCurrencyConfigService.queryEnableCurrencies((long)book.getOrgId(), (long)book.getBookTypeId()).forEach(config -> {
            boolean allExistValue = config.getInitBalanceFields(new MCT[]{MCT.BEGIN_CREDIT, MCT.BEGIN_DEBIT}).stream().map(MetaField::getMetaId).map(arg_0 -> ((DynamicObject)dyn).getBigDecimal(arg_0)).filter(Objects::nonNull).allMatch(amt -> BigDecimal.ZERO.compareTo((BigDecimal)amt) != 0);
            if (allExistValue) {
                String localCurName = config.getName().getLocaleValue();
                validator.addErrorMessage(dynExt, String.format(ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d\u4e0d\u80fd\u540c\u65f6\u5f55\u5165\u501f\u65b9%1$s\u548c\u8d37\u65b9%2$s\u3002", (String)"InitBalSaveUtil_1", (String)"fi-gl-opplugin", (Object[])new Object[0]), localCurName, localCurName));
            }
        });
    }

    public static boolean checkMLYearProfitAmtNotZero(DynamicObject dyn, AccountBookInfo book) {
        return InitBalSaveUtil.checkMulLocalCurAmtNotZero(dyn, book, MCT.YEAR_PROFIT_DEBIT, MCT.YEAR_PROFIT_CREDIT);
    }

    public static boolean checkMLYearAmtNotZero(DynamicObject dyn, AccountBookInfo book) {
        return InitBalSaveUtil.checkMulLocalCurAmtNotZero(dyn, book, MCT.YEAR_DEBIT, MCT.YEAR_CREDIT);
    }

    public static boolean checkMulLocalCurAmtNotZero(DynamicObject dyn, AccountBookInfo book, MCT ... fields) {
        Collection enabledLocalCurConfig = LocalCurrencyConfigService.queryEnableCurrencies((long)book.getOrgId(), (long)book.getBookTypeId());
        return enabledLocalCurConfig.stream().anyMatch(config -> config.getInitBalanceFields(fields).stream().map(MetaField::getMetaId).map(arg_0 -> ((DynamicObject)dyn).getBigDecimal(arg_0)).filter(Objects::nonNull).anyMatch(amt -> BigDecimal.ZERO.compareTo((BigDecimal)amt) != 0));
    }

    public static void checkMulLocalCurAmtNotZero(ExtendedDataEntity initBalDynExt, long orgId, long bookTypeId, InitBalanceSaveValidator validator) {
        DynamicObject dyn = initBalDynExt.getDataEntity();
        ArrayList noNeedConfig = new ArrayList(LocalCurrencyConfigService.queryEnableCurrencies());
        noNeedConfig.removeAll(LocalCurrencyConfigService.queryEnableCurrencies((long)orgId, (long)bookTypeId));
        noNeedConfig.forEach(config -> {
            boolean notZero = config.getAllInitBalanceFields().stream().map(MetaField::getMetaId).map(arg_0 -> ((DynamicObject)dyn).getBigDecimal(arg_0)).filter(Objects::nonNull).anyMatch(amt -> BigDecimal.ZERO.compareTo((BigDecimal)amt) != 0);
            if (notZero) {
                validator.addErrorMessage(initBalDynExt, String.format(ResManager.loadKDString((String)"\u672a\u542f\u7528%1$s\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u5bf9\u5e94\u91d1\u989d\u3002", (String)"InitBalSaveUtil_3", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), config.getName()));
            }
        });
    }

    public static void checkLocalCurAmtIsSame(ExtendedDataEntity initBalDynExt, AccountBookInfo book, InitBalanceSaveValidator validator) {
        DynamicObject initBalDyn = initBalDynExt.getDataEntity();
        Collection enabledLocalCurConfig = LocalCurrencyConfigService.queryEnableCurrencies((long)book.getOrgId(), (long)book.getBookTypeId());
        for (LocalCurrencyConfigVO localCurConfig : enabledLocalCurConfig) {
            boolean allMatch;
            long localCurId = localCurConfig.getCurrencyId(book.getOrgId(), book.getBookTypeId());
            if (initBalDyn.getLong(GLField.id_((String)"currency")) != localCurId || (allMatch = localCurConfig.getAllInitBalanceFields().stream().allMatch(localCurAmtField -> {
                String forAmtFieldKey;
                String fieldKey = localCurAmtField.getMetaId();
                if (fieldKey.length() > 3 && initBalDyn.containsProperty(forAmtFieldKey = fieldKey.substring(3).replace("local", "for"))) {
                    return initBalDyn.getBigDecimal(forAmtFieldKey).compareTo(initBalDyn.getBigDecimal(fieldKey)) == 0;
                }
                return true;
            }))) continue;
            String localCurName = localCurConfig.getName().getLocaleValue();
            validator.addErrorMessage(initBalDynExt, String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u5e01\u522b\u548c%1$s\u4e00\u81f4\u65f6\uff0c\u539f\u5e01\u91d1\u989d\u5e94\u4e0e%2$s\u91d1\u989d\u4fdd\u6301\u4e00\u81f4\u3002", (String)"InitBalSaveUtil_2", (String)"fi-gl-opplugin", (Object[])new Object[0]), localCurName, localCurName));
        }
    }

    public static void checkMLYearAmtNotZeroWithProfit(ExtendedDataEntity dataEntity, AccountBookInfo book, InitBalanceSaveValidator validator) {
        DynamicObject dyn = dataEntity.getDataEntity();
        for (LocalCurrencyConfigVO config : LocalCurrencyConfigService.queryEnableCurrencies((long)book.getOrgId(), (long)book.getBookTypeId())) {
            boolean existValue = config.getInitBalanceFields(new MCT[]{MCT.YEAR_PROFIT_CREDIT, MCT.YEAR_PROFIT_DEBIT}).stream().map(MetaField::getMetaId).map(arg_0 -> ((DynamicObject)dyn).getBigDecimal(arg_0)).filter(Objects::nonNull).anyMatch(amt -> BigDecimal.ZERO.compareTo((BigDecimal)amt) != 0);
            if (!existValue) continue;
            boolean allZero = config.getInitBalanceFields(new MCT[]{MCT.YEAR_CREDIT, MCT.YEAR_DEBIT}).stream().map(MetaField::getMetaId).map(arg_0 -> ((DynamicObject)dyn).getBigDecimal(arg_0)).filter(Objects::nonNull).allMatch(amt -> BigDecimal.ZERO.compareTo((BigDecimal)amt) == 0);
            if (!allZero) continue;
            validator.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u4e3a\u635f\u76ca\u7c7b\u79d1\u76ee\uff0c\u635f\u76ca\u7c7b\u79d1\u76ee\u6709\u5b9e\u9645\u53d1\u751f\u989d\u5219\u672c\u5e74\u7d2f\u8ba1\u5fc5\u5f55\u3002", (String)"InitBalanceSaveValidator_19", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            break;
        }
    }
}

