/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.constant.InitBalance;
import kd.fi.gl.opplugin.InitBalanceSaveOp;

public class InitBalanceDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("booktype");
        fieldKeys.add("account");
        fieldKeys.add("accounttable");
        fieldKeys.add("assgrp");
        fieldKeys.add("measureunit");
        fieldKeys.add("currency");
        fieldKeys.add("curlocal");
        fieldKeys.addAll(ComAssistTable.getMaxCommonAssistKeys());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                boolean isEndInit = false;
                if (this.dataEntities.length > 0) {
                    ExtendedDataEntity dataEntity = this.dataEntities[0];
                    DynamicObject obj = dataEntity.getDataEntity();
                    long org = obj.getLong(InitBalance.id_((String)"org"));
                    long booktype = obj.getLong(InitBalance.id_((String)"booktype"));
                    DynamicObject book = AccSysUtil.loadSingleBook((Object)org, (Object)booktype, (String)"isendinit");
                    boolean bl = isEndInit = book != null && book.getBoolean("isendinit");
                }
                if (isEndInit) {
                    Stream.of(this.dataEntities).forEach(entity -> this.addErrorMessage((ExtendedDataEntity)entity, ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"InitBalanceDeleteOp_0", (String)"fi-gl-opplugin", (Object[])new Object[0])));
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> saveDeleteds = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject newDynObj = InitBalanceSaveOp.createDeletedInitBalance(dataEntity);
            saveDeleteds.add(newDynObj);
        }
        SaveServiceHelper.save((DynamicObject[])saveDeleteds.toArray(new DynamicObject[0]));
    }
}

