/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.balcal.InitCashFlowKey;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.constant.InitCashFlow;
import kd.fi.gl.opplugin.InitCashflowSaveOp;
import kd.fi.gl.util.GLApp;

public class InitCashFlowSaveValidator
extends AbstractValidator {
    private Map<String, DynamicObject> flexfieldMap = new HashMap<String, DynamicObject>(16);
    private final Map<Long, Boolean> beginPeriodMap = new HashMap<Long, Boolean>();
    private final InitCashflowSaveOp superSaveOp;
    private Map<Object, DynamicObject> cashFlowItemCache;

    public InitCashFlowSaveValidator(InitCashflowSaveOp superSaveOp) {
        this.superSaveOp = superSaveOp;
    }

    public void validate() {
        this.checkBookAndFillBaseCurrency();
        Map<InitCashFlowKey, Long> filteredEntity = this.initCache(this.dataEntities);
        this.checkData(filteredEntity);
    }

    private void checkData(Map<InitCashFlowKey, Long> filteredEntity) {
        Collection<Long> cfIds = filteredEntity.values();
        this.getAsstactTypes();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject initCashFlow = dataEntity.getDataEntity();
            long cfId = initCashFlow.getLong("id");
            if (!cfIds.contains(cfId)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e2d\u5b58\u5728\u91cd\u590d\u6570\u636e\u3002", (String)"InitCashFlowSaveValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            AccountBookInfo book = AccSysUtil.getBookFromAccSys((long)initCashFlow.getLong(GLField.id_((String)"org")), (long)initCashFlow.getLong(GLField.id_((String)"booktype")));
            if (book.getCashinitPeriodId() == 0L) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d26\u7c3f\u672a\u542f\u7528\u73b0\u91d1\u6d41\u91cf\uff0c\u8bf7\u5148\u5728\u4f1a\u8ba1\u8d26\u7c3f\u4e0a\u5f55\u5165\u73b0\u91d1\u6d41\u91cf\u542f\u7528\u671f\u95f4\uff0c\u518d\u8fdb\u884c\u521d\u59cb\u5316\u6570\u636e\u5f55\u5165\u3002", (String)"InitCashFlowSaveValidator_12", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject cfItem = this.cashFlowItemCache.get(initCashFlow.get(InitCashFlow.id_((String)"cfitem")));
            if (!cfItem.getBoolean("isleaf")) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bfc\u5165\u660e\u7ec6\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u3002", (String)"InitCashFlowSaveValidator_8", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (cfItem.getBoolean("isprefit")) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bfc\u5165\u51c0\u5229\u6da6\u9879\u76ee\u7684\u521d\u59cb\u5316\u6570\u636e\u3002", (String)"InitCashFlowSaveValidator_15", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            long accountTableId = book.getAccountTableId();
            List commonAssists = ComAssistTable.get((Long)accountTableId).getCommonAssists();
            Object[] commonAssistCheckSize = commonAssists.stream().filter(commonAssist -> commonAssist.isRequired).filter(comAssist -> initCashFlow.getDynamicObject(comAssist.key) == null).map(commonAssist -> commonAssist.getLocaleName().getLocaleValue()).peek(comAssistName -> this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u201c%s\u201d\u4e3a\u5fc5\u5f55\u9879\u3002", (String)"InitCashFlowSaveValidator_10", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), comAssistName))).toArray();
            if (commonAssistCheckSize.length > 0 || (commonAssistCheckSize = commonAssists.stream().filter(comAssist -> initCashFlow.getDynamicObject(comAssist.key) != null && initCashFlow.getDynamicObject(comAssist.key).containsProperty("isleaf")).filter(comAssist -> !initCashFlow.getDynamicObject(comAssist.key).getBoolean("isleaf")).map(commonAssist -> commonAssist.getLocaleName().getLocaleValue()).peek(comAssistName -> this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u201c%s\u201d\u4e3a\u975e\u660e\u7ec6\u9879\u3002", (String)"InitCashFlowSaveValidator_11", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), comAssistName))).toArray()).length > 0) continue;
            if (!"3".equals(cfItem.getString("type")) && "b".equals(cfItem.getString("direction"))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u5411\u4e3a\u6d41\u5165\u6d41\u51fa\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u652f\u6301\u5f55\u5165\u521d\u59cb\u5316\u6570\u636e\u3002", (String)"InitCashFlowItemFormRpt_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                continue;
            }
            this.validate(dataEntity, cfItem);
        }
    }

    private void checkBookAndFillBaseCurrency() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            long bookTypeId;
            DynamicObject cashFlow = dataEntity.getDataEntity();
            if (cashFlow.get("org") == null) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u5f97\u5bf9\u5e94\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"InitCashFlowSaveValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (cashFlow.get("booktype") == null) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5bf9\u5e94\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"InitCashFlowSaveValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (cashFlow.get("cfitem") == null) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5bf9\u5e94\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u3002", (String)"InitCashFlowSaveValidator_3", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            long orgId = cashFlow.getLong(InitCashFlow.id_((String)"org"));
            AccountBookInfo book = AccSysUtil.getBookFromAccSys((long)orgId, (long)(bookTypeId = cashFlow.getLong(InitCashFlow.id_((String)"booktype"))));
            if (book == null) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5bf9\u5e94\u8d26\u7c3f\u5c1a\u672a\u5efa\u7acb\u3002", (String)"InitCashFlowSaveValidator_4", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (!book.isIsbizunit()) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u6cd5\u5bfc\u5165\u865a\u4f53\u8d26\u7c3f\u3002", (String)"InitCashFlowSaveValidator_5", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            long cashInitPeriod = book.getCashinitPeriodId();
            if (this.isBeginPeriod(cashInitPeriod)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u4e3a1\u671f\uff0c\u65e0\u6cd5\u5bfc\u5165\u521d\u59cb\u5316\u4f59\u989d\u3002", (String)"InitCashFlowSaveValidator_6", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (book.isIsendinitcashflow()) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u65b0\u589e\u521d\u59cb\u4f59\u989d\u3002", (String)"InitCashFlowSaveValidator_7", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            cashFlow.set(InitCashFlow.id_((String)"currency"), (Object)book.getBaseCurrencyId());
        }
    }

    private boolean validate(ExtendedDataEntity dataEntity, DynamicObject cfItem) {
        DynamicObjectCollection assistentry = cfItem.getDynamicObjectCollection("assistentry");
        long maincfId = cfItem.getLong("id");
        Map<String, Tuple2<Boolean, Boolean>> mustInputAssgrpMap = this.getMustInput_Maincf(maincfId);
        if (!CollectionUtils.isEmpty(mustInputAssgrpMap)) {
            for (DynamicObject assgrpObj : assistentry) {
                String assgrpValueJson;
                String flexfield = ((DynamicObject)assgrpObj.get("asstypeid")).getString("flexfield");
                Tuple2<Boolean, Boolean> mustInputAssgrp = mustInputAssgrpMap.get(flexfield);
                DynamicObject assgrpValueDyn = dataEntity.getDataEntity().getDynamicObject("assgrp");
                String string = assgrpValueJson = Objects.nonNull(assgrpValueDyn) ? assgrpValueDyn.getString("value") : "";
                if (((Boolean)mustInputAssgrp.t1).booleanValue() && (Objects.isNull(assgrpValueDyn) || !assgrpValueJson.contains(flexfield))) {
                    String name = ((DynamicObject)assgrpObj.get("asstypeid")).getString("name");
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\uff1a%s\u4e3a\u5fc5\u5f55\u9879\u3002", (String)"InitCashFlowSaveValidator_9", (String)"fi-gl-opplugin", (Object[])new Object[0]), name), ErrorLevel.Error);
                    continue;
                }
                if (!((Boolean)mustInputAssgrp.t2).booleanValue() || Objects.isNull(assgrpValueDyn) || !assgrpValueJson.contains(flexfield)) continue;
                JSONObject valueJson = JSONObject.parseObject((String)assgrpValueJson);
                Object assgrpValue = valueJson.get((Object)flexfield);
                DynamicObject asstactType = this.flexfieldMap.get(flexfield);
                if (asstactType == null) continue;
                String formId = "";
                if ("1".equals(asstactType.getString("valuetype"))) {
                    formId = asstactType.getString("valuesource.id");
                } else if ("2".equals(asstactType.getString("valuetype"))) {
                    formId = "bos_assistantdata_detail";
                }
                if (!StringUtils.isNotEmpty((CharSequence)formId)) continue;
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)formId);
                DynamicObject dynamicObject = null;
                if (formId.equals("bos_org") || formId.equals("bos_adminorg")) {
                    dynamicObject = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"isleaf", (QFilter[])new QFilter[]{new QFilter("org", "=", assgrpValue)});
                } else if (!formId.equals("bd_admindivision") && mainType.getFields().containsKey("parent") && mainType.getFields().containsKey("isleaf") && StringUtils.isNotEmpty((CharSequence)((IDataEntityProperty)mainType.getFields().get("isleaf")).getAlias())) {
                    dynamicObject = QueryServiceHelper.queryOne((String)formId, (String)"isleaf", (QFilter[])new QFilter[]{new QFilter("id", "=", assgrpValue)});
                }
                if (dynamicObject == null || dynamicObject.getBoolean("isleaf")) continue;
                String name = ((DynamicObject)assgrpObj.get("asstypeid")).getString("name");
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\uff1a%s\u975e\u660e\u7ec6\u9879\u3002", (String)"InitCashFlowSaveValidator_13", (String)"fi-gl-opplugin", (Object[])new Object[0]), name), ErrorLevel.Error);
            }
        }
        return false;
    }

    private Map<String, Tuple2<Boolean, Boolean>> getMustInput_Maincf(long maincfId) {
        DynamicObject maincf = this.cashFlowItemCache.get(maincfId);
        DynamicObjectCollection assistenty = maincf.getDynamicObjectCollection("assistentry");
        HashMap<String, Tuple2<Boolean, Boolean>> assMap = new HashMap<String, Tuple2<Boolean, Boolean>>();
        for (DynamicObject obj : assistenty) {
            String flexField = obj.getString("asstypeid.flexfield");
            assMap.put(flexField, (Tuple2<Boolean, Boolean>)new Tuple2((Object)obj.getBoolean("isrequire"), (Object)obj.getBoolean("isdetail")));
        }
        return assMap;
    }

    private boolean isBeginPeriod(long curPeriodId) {
        return this.beginPeriodMap.computeIfAbsent(curPeriodId, k -> {
            try (DataSet rows = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".period"), (String)"bd_period", (String)"periodnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", k)}, null);){
                if (rows.hasNext()) {
                    Row next = rows.next();
                    Boolean bl = next.getInteger("periodnumber") == 1;
                    return bl;
                }
                Boolean bl = false;
                return bl;
            }
        });
    }

    private Map<InitCashFlowKey, Long> initCache(ExtendedDataEntity[] dataEntities) {
        this.superSaveOp.assgrps = new HashSet<Long>(dataEntities.length);
        HashSet cfItemIDs = new HashSet(dataEntities.length);
        Map<InitCashFlowKey, Long> existedKeyMap = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).peek(initCashDyo -> {
            Long orgId = initCashDyo.getLong(InitCashFlow.id_((String)"org"));
            Long bookTypeId = initCashDyo.getLong(InitCashFlow.id_((String)"booktype"));
            this.superSaveOp.orgs.add(orgId);
            this.superSaveOp.booktypes.add(bookTypeId);
            this.superSaveOp.cfItemMids.add(initCashDyo.getLong("cfitem.masterid"));
            if (this.superSaveOp.assgrps != null && this.superSaveOp.assgrps.size() < 1000) {
                this.superSaveOp.assgrps.add(initCashDyo.getLong(InitCashFlow.id_((String)"assgrp")));
            } else {
                this.superSaveOp.assgrps = null;
            }
            this.superSaveOp.currencys.add(initCashDyo.getLong(InitCashFlow.id_((String)"currency")));
            cfItemIDs.add(initCashDyo.getLong(InitCashFlow.id_((String)"cfitem")));
            ComAssistTable.get((Long)orgId, (Long)bookTypeId).ifPresent(commonAssistTable -> commonAssistTable.getCommonAssists().forEach(commonAssist -> {
                Set<Long> values = this.superSaveOp.comAssistMap.get(commonAssist.key);
                if (values == null) {
                    values = new HashSet<Long>(2);
                }
                values.add(initCashDyo.getLong(InitCashFlow.id_((String)commonAssist.key)));
                this.superSaveOp.comAssistMap.put(commonAssist.key, values);
            }));
        }).collect(Collectors.toMap(initCashDyo -> new InitCashFlowKey(initCashDyo.getLong(InitCashFlow.id_((String)"org")), initCashDyo.getLong(InitCashFlow.id_((String)"booktype")), initCashDyo.getLong("cfitem.masterid"), initCashDyo.getLong(InitCashFlow.id_((String)"assgrp")), initCashDyo.getLong(InitCashFlow.id_((String)"currency")), this.getComassist(initCashDyo.getLong(InitCashFlow.id_((String)"org")), initCashDyo.getLong(InitCashFlow.id_((String)"booktype")), (DynamicObject)initCashDyo)), initCashDyo -> initCashDyo.getLong("id"), (value1, value2) -> value2));
        this.superSaveOp.existedKeyMap = existedKeyMap;
        this.cashFlowItemCache = Arrays.stream(BusinessDataServiceHelper.load((String)"gl_cashflowitem", (String)"assistentry.asstypeid.flexfield, assistentry.isrequire,assistentry.isdetail, isleaf, assistentry.asstypeid.name, assistentry.asstypeid,direction,type,isprefit", (QFilter[])new QFilter("id", "in", cfItemIDs).toArray())).collect(Collectors.toMap(DataEntityBase::getPkValue, dyo -> dyo));
        return existedKeyMap;
    }

    private List<Long> getComassist(long org, long booktype, DynamicObject dyn) {
        ArrayList<Long> comassists = new ArrayList<Long>(2);
        ComAssistTable.get((Long)org, (Long)booktype).ifPresent(commonAssistTable -> commonAssistTable.getCommonAssists().forEach(commonAssist -> comassists.add(dyn.getLong(InitCashFlow.id_((String)commonAssist.key)))));
        return comassists;
    }

    private void getAsstactTypes() {
        QFilter qFilter = new QFilter("valuetype", "in", (Object)new String[]{"1", "2"});
        QFilter qFilter1 = new QFilter("flexid.number", "=", (Object)"002");
        DynamicObjectCollection asstactTypes = QueryServiceHelper.query((String)"bd_asstacttype", (String)"flexfield,valuetype,valuesource.id", (QFilter[])new QFilter[]{qFilter, qFilter1});
        for (DynamicObject dyn : asstactTypes) {
            this.flexfieldMap.put(dyn.getString("flexfield"), dyn);
        }
    }
}

