/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.ai.PresetCashItemUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.common.AccountType;

public class PresetAccountSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PresetAccountSaveOp.class);
    private static final String ACCT = "entryentity.account";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            private Map<String, Map<String, Set<String>>> prepareDatas(String dc, String type) {
                Object key;
                HashMap<String, Map<String, Set<String>>> presetItemMap = new HashMap<String, Map<String, Set<String>>>(16);
                int length = this.getDataEntities().length;
                HashMap<String, Tuple> accounttableMap = new HashMap<String, Tuple>(length);
                HashSet<Long> orgIds = new HashSet<Long>(length);
                HashSet<Long> accounttableIds = new HashSet<Long>(length);
                QFilter dcFilter = new QFilter("entryentity.dc", "=", (Object)dc);
                for (ExtendedDataEntity entity : this.getDataEntities()) {
                    DynamicObject dyo = entity.getDataEntity();
                    if (DebugTrace.enable()) {
                        logger.info("\u79d1\u76ee\u73b0\u91d1\u6d41\u91cf\u6620\u5c04\u5173\u7cfb\uff1a" + dyo.toString());
                    }
                    long orgId = dyo.getLong("createorg_id");
                    long accounttableId = dyo.getLong("accounttable_id");
                    key = orgId + "-" + accounttableId;
                    orgIds.add(orgId);
                    accounttableIds.add(accounttableId);
                    accounttableMap.put((String)key, new Tuple((Object)orgId, (Object)accounttableId));
                }
                for (Map.Entry entry : accounttableMap.entrySet()) {
                    Tuple value = (Tuple)entry.getValue();
                    String key2 = (String)entry.getKey();
                    long orgId = (Long)value.item1;
                    List presetItemIds = PresetCashItemUtil.getUsedPresetIds((Long)orgId, (Long)((Long)value.item2));
                    String select = String.format("createorg,group.number,%s acctid,entryentity.assgrp assgrp", PresetAccountSaveOp.ACCT);
                    DataSet presetItemData = QueryServiceHelper.queryDataSet((String)"fi.gl.PresetAccountSaveOp", (String)"gl_presetcashflowitem", (String)select, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)presetItemIds), new QFilter("group.type", "=", (Object)type), dcFilter}, null);
                    key = null;
                    try {
                        while (presetItemData.hasNext()) {
                            Row row = presetItemData.next();
                            String groupNum = row.getString("group.number");
                            long acctid = row.getLong("acctid");
                            long assgrp = row.getLong("assgrp");
                            String acctAssgrp = acctid + "-" + assgrp;
                            Map presetItemMapOfOrg = presetItemMap.computeIfAbsent(key2, k -> new HashMap(16));
                            Set acctAssgrps = presetItemMapOfOrg.computeIfAbsent(groupNum, k -> new HashSet(16));
                            acctAssgrps.add(acctAssgrp);
                        }
                    }
                    catch (Throwable row) {
                        key = row;
                        throw row;
                    }
                    finally {
                        if (presetItemData == null) continue;
                        if (key != null) {
                            try {
                                presetItemData.close();
                            }
                            catch (Throwable row) {
                                ((Throwable)key).addSuppressed(row);
                            }
                            continue;
                        }
                        presetItemData.close();
                    }
                }
                String select = String.format("createorg,accounttable,group.number,%s acctid,entryentity.assgrp assgrp", PresetAccountSaveOp.ACCT);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"fi.gl.PresetAccountSaveOp", (String)"gl_presetcashflowitem", (String)select, (QFilter[])new QFilter[]{new QFilter("createorg", "in", orgIds), new QFilter("group.type", "=", (Object)type), new QFilter("accounttable", "in", accounttableIds), dcFilter}, null);){
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        long orgId = row.getLong("createorg");
                        long accounttableId = row.getLong("accounttable");
                        String key3 = orgId + "-" + accounttableId;
                        String groupNum = row.getString("group.number");
                        long acctid = row.getLong("acctid");
                        long assgrp = row.getLong("assgrp");
                        String acctAssgrp = acctid + "-" + assgrp;
                        Map presetItemMapOfOrg = presetItemMap.computeIfAbsent(key3, k -> new HashMap(16));
                        Set acctAssgrps = presetItemMapOfOrg.computeIfAbsent(groupNum, k -> new HashSet());
                        acctAssgrps.add(acctAssgrp);
                    }
                }
                return presetItemMap;
            }

            public void validate() {
                Map<String, Map<String, Set<String>>> presetItemDebMapMain = this.prepareDatas("1", "1");
                Map<String, Map<String, Set<String>>> presetItemCreMapMain = this.prepareDatas("-1", "1");
                Map<String, Map<String, Set<String>>> presetItemDebMapSup = this.prepareDatas("1", "3");
                Map<String, Map<String, Set<String>>> presetItemCreMapSup = this.prepareDatas("-1", "3");
                HashMap<String, Map<String, Set<String>>> presetInsertItemDebMapMain = new HashMap<String, Map<String, Set<String>>>(16);
                HashMap<String, Map<String, Set<String>>> presetInsertItemCreMapMain = new HashMap<String, Map<String, Set<String>>>(16);
                HashMap<String, Map<String, Set<String>>> presetInsertItemDebMapSup = new HashMap<String, Map<String, Set<String>>>(16);
                HashMap<String, Map<String, Set<String>>> presetInsertItemCreMapSup = new HashMap<String, Map<String, Set<String>>>(16);
                for (ExtendedDataEntity entity : this.getDataEntities()) {
                    String result;
                    DynamicObject dyo = entity.getDataEntity();
                    long orgId = dyo.getLong("createorg_id");
                    long accounttableId = dyo.getLong("accounttable_id");
                    String key = orgId + "-" + accounttableId;
                    DynamicObject group = dyo.getDynamicObject("group");
                    if (group == null) {
                        this.addMessage(entity, ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PresetAccountSaveOp_6", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    boolean isLeaf = group.getBoolean("isleaf");
                    if (!isLeaf) {
                        this.addMessage(entity, ResManager.loadKDString((String)"\u975e\u660e\u7ec6\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4e0d\u80fd\u8bbe\u7f6e\u79d1\u76ee\u6620\u5c04\u5173\u7cfb\u3002", (String)"PresetAccountSaveOp_0", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    boolean isprefit = group.getBoolean("isprefit");
                    if (isprefit) {
                        this.addMessage(entity, ResManager.loadKDString((String)"\u51c0\u5229\u6da6\u9879\u76ee\u4e0d\u80fd\u8bbe\u7f6e\u79d1\u76ee\u6620\u5c04\u5173\u7cfb\u3002", (String)"PresetAccountSaveOp_1", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    if ("1".equals(group.getString("type")) && "b".equals(group.getString("direction"))) {
                        this.addMessage(entity, ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u65b9\u5411\u4e3a\u201c\u6d41\u5165\u6d41\u51fa\u201d\uff0c\u8bf7\u9009\u62e9\u5355\u65b9\u5411\u9879\u76ee\u3002", (String)"PresetAccountList_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObjectCollection entry = dyo.getDynamicObjectCollection("entryentity");
                    if (entry.isEmpty()) {
                        this.addMessage(entity, ResManager.loadKDString((String)"\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PresetAccountSaveOp_2", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    ArrayList<String> nullAcctSeq = new ArrayList<String>();
                    ArrayList<DynamicObject> acctList = new ArrayList<DynamicObject>();
                    for (DynamicObject row : entry) {
                        long acctId = 0L;
                        long assgrpId = 0L;
                        DynamicObject acct = row.getDynamicObject("account");
                        if (acct == null) {
                            nullAcctSeq.add(String.valueOf(row.getInt("seq")));
                        } else {
                            acctId = acct.getLong("id");
                        }
                        acctList.add(acct);
                        DynamicObject assgrp = row.getDynamicObject("assgrp");
                        if (assgrp != null) {
                            assgrpId = assgrp.getLong("id");
                        }
                        String acctAssgrp = acctId + "-" + assgrpId;
                        Map presetItemMapOfOrg = null;
                        presetItemMapOfOrg = "3".equals(group.getString("type")) ? ("1".equals(row.getString("dc")) ? presetInsertItemDebMapSup.computeIfAbsent(key, k -> new HashMap(16)) : presetInsertItemCreMapSup.computeIfAbsent(key, k -> new HashMap(16))) : ("1".equals(row.getString("dc")) ? presetInsertItemDebMapMain.computeIfAbsent(key, k -> new HashMap(16)) : presetInsertItemCreMapMain.computeIfAbsent(key, k -> new HashMap(16)));
                        Set acctAssgrps = presetItemMapOfOrg.computeIfAbsent(group.getString("number"), k -> new HashSet());
                        acctAssgrps.add(acctAssgrp);
                    }
                    if (!nullAcctSeq.isEmpty()) {
                        this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u5206\u5f55\u9884\u8bbe\u7684\u79d1\u76ee\u4e0d\u5b58\u5728\u3002", (String)"PresetAccountSaveOp_3", (String)"fi-gl-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", nullAcctSeq)), ErrorLevel.Error);
                        continue;
                    }
                    boolean flag = false;
                    boolean budgetFlag = false;
                    for (DynamicObject acct : acctList) {
                        if (acct.getBoolean("iscash") || acct.getBoolean("isbank") || acct.getBoolean("iscashequivalent")) {
                            flag = true;
                            break;
                        }
                        if (!AccountType.isBudgetType((long)acct.getLong("accounttype_id"))) continue;
                        budgetFlag = true;
                        break;
                    }
                    if (flag) {
                        this.addMessage(entity, ResManager.loadKDString((String)"\u73b0\u91d1\u7c7b\u79d1\u76ee\u4e0d\u80fd\u8bbe\u7f6e\u79d1\u76ee\u6620\u5c04\u5173\u7cfb\u3002", (String)"PresetAccountSaveOp_4", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    if (budgetFlag) {
                        this.addMessage(entity, ResManager.loadKDString((String)"\u9884\u7b97\u79d1\u76ee\u4e0d\u80fd\u8bbe\u7f6e\u79d1\u76ee\u6620\u5c04\u5173\u7cfb\u3002", (String)"PresetAccountSaveOp_7", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    String type = group.getString("type");
                    if ("3".equals(type)) {
                        result = this.isAcctAlreadyUsed(presetItemDebMapSup, key, dyo, "1");
                        if (!result.isEmpty()) {
                            this.addMessage(entity, result, ErrorLevel.Error);
                            continue;
                        }
                        result = this.isAcctAlreadyUsed(presetItemCreMapSup, key, dyo, "-1");
                        if (!result.isEmpty()) {
                            this.addMessage(entity, result, ErrorLevel.Error);
                            continue;
                        }
                        result = this.isAcctAlreadyUsed(presetInsertItemDebMapSup, key, dyo, "1");
                        if (!result.isEmpty()) {
                            this.addMessage(entity, result, ErrorLevel.Error);
                            continue;
                        }
                        result = this.isAcctAlreadyUsed(presetInsertItemCreMapSup, key, dyo, "-1");
                        if (result.isEmpty()) continue;
                        this.addMessage(entity, result, ErrorLevel.Error);
                        continue;
                    }
                    result = this.isAcctAlreadyUsed(presetItemDebMapMain, key, dyo, "1");
                    if (!result.isEmpty()) {
                        this.addMessage(entity, result, ErrorLevel.Error);
                        continue;
                    }
                    result = this.isAcctAlreadyUsed(presetItemCreMapMain, key, dyo, "-1");
                    if (!result.isEmpty()) {
                        this.addMessage(entity, result, ErrorLevel.Error);
                    }
                    if (!(result = this.isAcctAlreadyUsed(presetInsertItemDebMapMain, key, dyo, "1")).isEmpty()) {
                        this.addMessage(entity, result, ErrorLevel.Error);
                        continue;
                    }
                    result = this.isAcctAlreadyUsed(presetInsertItemCreMapMain, key, dyo, "-1");
                    if (result.isEmpty()) continue;
                    this.addMessage(entity, result, ErrorLevel.Error);
                }
            }

            private String isAcctAlreadyUsed(Map<String, Map<String, Set<String>>> presetItemDebMap, String key, DynamicObject dyo, String dc) {
                ArrayList<String> errorMsgs = new ArrayList<String>(10);
                DynamicObject cfItem = dyo.getDynamicObject("group");
                String cfItemNum = cfItem.getString("number");
                DynamicObjectCollection entries = dyo.getDynamicObjectCollection("entryentity");
                Map<String, Set<String>> presetItemMapOfOrg = presetItemDebMap.get(key);
                HashSet<String> newCurrentAccountAndAssgrp = new HashSet<String>(entries.size());
                if (presetItemMapOfOrg == null) {
                    presetItemMapOfOrg = new HashMap<String, Set<String>>(entries.size());
                    for (DynamicObject entry : entries) {
                        if (!dc.equals(entry.getString("dc"))) continue;
                        long acctId = entry.getLong("account_id");
                        long assgrp = entry.getLong("assgrp_id");
                        String acctAssgrp = acctId + "-" + assgrp;
                        if (newCurrentAccountAndAssgrp.add(acctAssgrp)) continue;
                        errorMsgs.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u79d1\u76ee\u88ab\u73b0\u91d1\u6d41\u91cf\u9879\u76ee%2$s\u91cd\u590d\u9884\u8bbe\u3002", (String)"PresetAccountSaveOp_5", (String)"fi-gl-opplugin", (Object[])new Object[0]), entry.getInt("seq"), cfItemNum));
                    }
                    presetItemMapOfOrg.put(cfItemNum, newCurrentAccountAndAssgrp);
                } else {
                    for (Map.Entry<String, Set<String>> presetItemMapOfOrgEntry : presetItemMapOfOrg.entrySet()) {
                        String itemNum = presetItemMapOfOrgEntry.getKey();
                        if (cfItemNum.equals(itemNum)) {
                            for (DynamicObject entry : entries) {
                                if (!dc.equals(entry.getString("dc"))) continue;
                                long acctId = entry.getLong("account_id");
                                long assgrp = entry.getLong("assgrp_id");
                                String acctAssgrp = acctId + "-" + assgrp;
                                if (newCurrentAccountAndAssgrp.add(acctAssgrp)) continue;
                                errorMsgs.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u79d1\u76ee\u88ab\u73b0\u91d1\u6d41\u91cf\u9879\u76ee%2$s\u91cd\u590d\u9884\u8bbe\u3002", (String)"PresetAccountSaveOp_5", (String)"fi-gl-opplugin", (Object[])new Object[0]), entry.getInt("seq"), cfItemNum));
                            }
                            presetItemMapOfOrgEntry.setValue(newCurrentAccountAndAssgrp);
                            continue;
                        }
                        for (DynamicObject entry : entries) {
                            Set<String> usedAccountAssgrps = presetItemMapOfOrgEntry.getValue();
                            if (!dc.equals(entry.getString("dc"))) continue;
                            long acctId = entry.getLong("account_id");
                            long assgrp = entry.getLong("assgrp_id");
                            String acctAssgrp = acctId + "-" + assgrp;
                            if (!usedAccountAssgrps.contains(acctAssgrp)) continue;
                            errorMsgs.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u79d1\u76ee\u88ab\u73b0\u91d1\u6d41\u91cf\u9879\u76ee%2$s\u91cd\u590d\u9884\u8bbe\u3002", (String)"PresetAccountSaveOp_5", (String)"fi-gl-opplugin", (Object[])new Object[0]), entry.getInt("seq"), itemNum));
                        }
                    }
                }
                return String.join((CharSequence)"\n", errorMsgs.toArray(new String[0]));
            }
        });
    }
}

