/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.DebugTraceHelper;
import kd.fi.gl.vo.ReportFieldSettingVo;

public class ReportFieldSettingSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(ReportFieldSettingSaveOp.class);
    private static final String FIELD_SETING_TABLE = "t_gl_report_field_seting";
    private List<ReportFieldSettingVo> dataList;

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity entry : this.dataEntities) {
                    DynamicObjectCollection displayEntryEntity = (DynamicObjectCollection)entry.getDataEntity().get("displayentryentity");
                    DynamicObjectCollection filterEntryEntity = (DynamicObjectCollection)entry.getDataEntity().get("filterentryentity");
                    HashMap<String, String> displayMap = new HashMap<String, String>();
                    for (DynamicObject displayEntry : displayEntryEntity) {
                        String displayComboField;
                        String string = displayComboField = displayEntry.get("displaycombofield") == null ? "" : displayEntry.get("displaycombofield").toString();
                        if (StringUtils.isEmpty((String)displayComboField)) {
                            this.addErrorMessage(entry, String.format(ResManager.loadKDString((String)"\u663e\u793a\u5b57\u6bb5\uff1a\u7b2c%s\u884c\u5b57\u6bb5\u672a\u586b\u5199\u3002", (String)"ReportFieldSettingSaveOp_2", (String)"fi-gl-opplugin", (Object[])new Object[0]), displayEntry.get("seq")));
                            continue;
                        }
                        if (!displayMap.containsKey(displayComboField)) {
                            displayMap.put(displayComboField, displayComboField);
                            continue;
                        }
                        this.addErrorMessage(entry, String.format(ResManager.loadKDString((String)"\u663e\u793a\u5b57\u6bb5\uff1a%s\u5b57\u6bb5\u91cd\u590d\u3002", (String)"ReportFieldSettingSaveOp_0", (String)"fi-gl-opplugin", (Object[])new Object[0]), ReportFieldSettingSaveOp.this.getFieldName(displayComboField)));
                    }
                    HashMap<String, String> filterMap = new HashMap<String, String>();
                    for (DynamicObject filterEntry : filterEntryEntity) {
                        String filterComboField;
                        String string = filterComboField = filterEntry.get("filtercombofield") == null ? "" : filterEntry.get("filtercombofield").toString();
                        if (StringUtils.isEmpty((String)filterComboField)) {
                            this.addErrorMessage(entry, String.format(ResManager.loadKDString((String)"\u8fc7\u6ee4\u5b57\u6bb5\uff1a\u7b2c%s\u884c\u5b57\u6bb5\u672a\u586b\u5199\u3002", (String)"ReportFieldSettingSaveOp_3", (String)"fi-gl-opplugin", (Object[])new Object[0]), filterEntry.get("seq")));
                            continue;
                        }
                        if (!filterMap.containsKey(filterComboField)) {
                            filterMap.put(filterComboField, filterComboField);
                            continue;
                        }
                        this.addErrorMessage(entry, String.format(ResManager.loadKDString((String)"\u8fc7\u6ee4\u5b57\u6bb5\uff1a%s\u5b57\u6bb5\u91cd\u590d\u3002", (String)"ReportFieldSettingSaveOp_1", (String)"fi-gl-opplugin", (Object[])new Object[0]), ReportFieldSettingSaveOp.this.getFieldName(filterComboField)));
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        ReportFieldSettingVo fieldSettingVo;
        DynamicObjectCollection displayEntryEntity = (DynamicObjectCollection)e.getDataEntities()[0].get("displayentryentity");
        DynamicObjectCollection filterEntryEntity = (DynamicObjectCollection)e.getDataEntities()[0].get("filterentryentity");
        String formId = e.getDataEntities()[0].get("formid").toString();
        this.dataList = new ArrayList<ReportFieldSettingVo>();
        for (DynamicObject displayEntry : displayEntryEntity) {
            fieldSettingVo = new ReportFieldSettingVo();
            fieldSettingVo.setId(Long.valueOf(DB.genLongId((String)FIELD_SETING_TABLE)));
            fieldSettingVo.setFormId(formId);
            fieldSettingVo.setType("1");
            fieldSettingVo.setField(displayEntry.get("displaycombofield").toString());
            fieldSettingVo.setFieldMark(displayEntry.get("displaytextfield").toString());
            fieldSettingVo.setIsSys(displayEntry.get("displayissys").toString());
            this.dataList.add(fieldSettingVo);
        }
        for (DynamicObject filterEntry : filterEntryEntity) {
            fieldSettingVo = new ReportFieldSettingVo();
            fieldSettingVo.setId(Long.valueOf(DB.genLongId((String)FIELD_SETING_TABLE)));
            fieldSettingVo.setFormId(formId);
            fieldSettingVo.setType("2");
            fieldSettingVo.setField(filterEntry.get("filtercombofield").toString());
            fieldSettingVo.setFieldMark(filterEntry.get("filtertextfield").toString());
            fieldSettingVo.setIsSys(filterEntry.get("filterissys").toString());
            this.dataList.add(fieldSettingVo);
        }
        if (DebugTrace.enable()) {
            log.info("dataList:", (Object)DebugTraceHelper.toString(this.dataList));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        if (this.dataList != null) {
            ArrayList<Object[]> delParams = new ArrayList<Object[]>(1);
            delParams.add(new Object[]{this.dataList.get(0).getFormId()});
            try (TXHandle handler = TX.requiresNew();){
                try {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"delete from t_gl_report_field_seting where fformid = ?", delParams);
                    String insertSql = "insert into t_gl_report_field_seting(fid,fformid,ftype,ffield,ffieldmark,fissys) values(?,?,?,?,?,?)";
                    ArrayList<Object[]> insertParams = new ArrayList<Object[]>(this.dataList.size());
                    for (ReportFieldSettingVo param : this.dataList) {
                        insertParams.add(new Object[]{param.getId(), param.getFormId(), param.getType(), param.getField(), param.getFieldMark(), param.getIsSys()});
                    }
                    DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)insertSql, insertParams);
                }
                catch (Exception e) {
                    handler.markRollback();
                    log.error(e.getMessage(), (Throwable)e);
                    throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
                }
            }
        }
    }

    private String getFieldName(String property) {
        MainEntityType voucherEntity = EntityMetadataCache.getDataEntityType((String)"gl_voucher");
        String[] fieldName = new String[]{""};
        voucherEntity.getAllFields().entrySet().forEach(stringEntityTypeEntry -> {
            if (property.equals(((IDataEntityProperty)stringEntityTypeEntry.getValue()).getName())) {
                fieldName[0] = ((IDataEntityProperty)stringEntityTypeEntry.getValue()).getDisplayName().getLocaleValue();
            }
        });
        return fieldName[0];
    }
}

