/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.fi.gl.util.FinalProcessUtil;

public class TransPLProgramValidator
extends AbstractValidator {
    private static final String ENTITY_NAME = "gl_transplprogram";
    private static final String IS_DES_ACCT = "isdesacct";

    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.setEntityKey(ENTITY_NAME);
    }

    protected void addMessage(ExtendedDataEntity dataEntity, String title, String content, ErrorLevel errorLevel) {
        ValidationErrorInfo operateInfo = new ValidationErrorInfo("", dataEntity, "Error001", title, content, errorLevel);
        this.getValidateResult().addErrorInfo((OperateErrorInfo)operateInfo);
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            boolean exists;
            String billno = (String)dataEntity.getValue("billno");
            DynamicObjectCollection transacct = (DynamicObjectCollection)dataEntity.getValue("transacct");
            boolean isdesacct = (Boolean)dataEntity.getValue(IS_DES_ACCT);
            if (isdesacct && (transacct == null || transacct.size() == 0)) {
                StringBuffer buf = this.getFormatErrorString(billno);
                this.addMessage(dataEntity, buf.toString(), ErrorLevel.Error);
            }
            if (!(exists = FinalProcessUtil.isComAssistExistsNoLeaf((ExtendedDataEntity)dataEntity))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u503c\u5fc5\u987b\u4e3a\u660e\u7ec6\u503c\u3002", (String)"TransPLProgramValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        }
    }

    private StringBuffer getFormatErrorString(String billno) {
        StringBuffer buf = new StringBuffer();
        if (billno == null || billno.trim().equals("")) {
            buf.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ed3\u8f6c\u79d1\u76ee\u3002", (String)"TransPLProgramValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        } else {
            buf.append(ResManager.loadKDString((String)"%s\uff1a\u8bf7\u586b\u5199\u7ed3\u8f6c\u79d1\u76ee", (String)"TransPLProgramValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[]{billno}));
        }
        return buf;
    }
}

