/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin.closeinit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.MCT;
import kd.fi.gl.balcal.BalExtendTrigger;
import kd.fi.gl.balcal.log.BalChangeAction;
import kd.fi.gl.balcal.log.BalChangeLog;
import kd.fi.gl.balcal.log.DataChangeLog;
import kd.fi.gl.business.dao.balance.BalanceDelLogDao;
import kd.fi.gl.closeinit.BalCloseChangeKey;
import kd.fi.gl.closeinit.BalInfo;
import kd.fi.gl.closeinit.BatchInitInfo;
import kd.fi.gl.closeinit.InitBalInfo;
import kd.fi.gl.closeinit.InitBalKey;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.interfaces.service.bal.log.BalChangeLogger;
import kd.fi.gl.opplugin.CloseInitBalanceOp;
import kd.fi.gl.util.GLUtil;
import kd.sdk.fi.gl.extpoint.bal.AccountKey;
import kd.sdk.fi.gl.extpoint.bal.BalKey;
import org.apache.commons.collections4.list.UnmodifiableList;

public abstract class BalanceUpdate {
    private static final Log logger = LogFactory.getLog(CloseInitBalanceOp.class);
    protected int comassistSize = 0;
    protected UnmodifiableList<LocalCurrencyConfigVO> localCur = new UnmodifiableList(new ArrayList());
    private static final DBRoute FI = DBRoute.of((String)"gl");
    private List<BalKey> delDemension = new ArrayList<BalKey>();
    private BalChangeLogger balLogger = BalChangeLogger.create();

    protected void update(BatchInitInfo batchInitInfo, DynamicObject book) {
        this.comassistSize = batchInitInfo.getComassist().size();
        this.localCur = LocalCurrencyConfigService.queryEnableCurrencies();
        Tuple<Map<InitBalKey, InitBalInfo>, Map<String, DataChangeLog>> tuple = this.updateBal(batchInitInfo, book);
        Map infos = (Map)tuple.item1;
        this.process(infos);
        this.store(infos, (Map)tuple.item2);
        if (!this.delDemension.isEmpty()) {
            BalanceDelLogDao.saveAcctLog((long)book.getLong("org_id"), (long)book.getLong("bookstype_id"), this.delDemension);
            BalExtendTrigger.delBal((long)book.getLong("org_id"), (long)book.getLong("bookstype_id"), this.delDemension, (boolean)true);
            this.delDemension.clear();
        }
    }

    protected String getUpdateSql() {
        StringBuilder sb = new StringBuilder("update ");
        sb.append(this.getTableName());
        sb.append(" set fbeginqty=?,fbeginfor=?,fbeginlocal=?,fendqty=?,fendfor=?,fendlocal=?,");
        sb.append(" fyeardebitqty=?,fyeardebitfor=?,fyeardebitlocal=?,fyearcreditqty=?,fyearcreditfor=?,fyearcreditlocal=?");
        for (LocalCurrencyConfigVO cur : this.localCur) {
            sb.append(",").append(cur.getBalanceField(MCT.BEGIN).getDbId()).append("=?,").append(cur.getBalanceField(MCT.END).getDbId()).append("=?,").append(cur.getBalanceField(MCT.YEAR_DEBIT).getDbId()).append("=?,").append(cur.getBalanceField(MCT.YEAR_CREDIT).getDbId()).append("=?");
        }
        sb.append(",fmodifytime=? where fid=?");
        return sb.toString();
    }

    protected void store(Map<InitBalKey, InitBalInfo> infos, Map<String, DataChangeLog> id2ChangeLog) {
        if (infos.isEmpty()) {
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getEntityName());
        ArrayList<Object> deletes = new ArrayList<Object>(2000);
        ArrayList<DynamicObject> inserts = new ArrayList<DynamicObject>(2000);
        ArrayList<Object[]> updates = new ArrayList<Object[]>(2000);
        String updateSql = this.getUpdateSql();
        for (Map.Entry<InitBalKey, InitBalInfo> infosEntry : infos.entrySet()) {
            Object[] pks;
            InitBalInfo initBalInfo = infosEntry.getValue();
            deletes.addAll(initBalInfo.getRmvList());
            inserts.addAll(initBalInfo.getInserts());
            for (BalInfo updateInfo : initBalInfo.getUpdateList()) {
                ArrayList<Comparable<BigDecimal>> params = new ArrayList<Comparable<BigDecimal>>(updateInfo.getNocurValues().length + this.localCur.size() * 4 + 1);
                for (BigDecimal val : updateInfo.getNocurValues()) {
                    params.add(val);
                }
                for (LocalCurrencyConfigVO cur : this.localCur) {
                    params.add(updateInfo.getMulCurBal().get(cur.getBalanceField(MCT.BEGIN).getMetaId()));
                    params.add(updateInfo.getMulCurBal().get(cur.getBalanceField(MCT.END).getMetaId()));
                    params.add(updateInfo.getMulCurBal().get(cur.getBalanceField(MCT.YEAR_DEBIT).getMetaId()));
                    params.add(updateInfo.getMulCurBal().get(cur.getBalanceField(MCT.YEAR_CREDIT).getMetaId()));
                }
                params.add(new Date());
                params.add(Long.valueOf(updateInfo.getId()));
                updates.add(params.toArray());
            }
            if (deletes.size() >= 2000) {
                pks = deletes.toArray();
                this.balLogger.recordRemoveData(this.getTableName2(), pks, id2ChangeLog, BalChangeAction.END_INIT);
                BusinessDataWriter.delete((IDataEntityType)entityType, (Object[])pks);
                deletes.clear();
            }
            if (inserts.size() >= 2000) {
                this.balLogger.recordInsertDyo(this.getTableName2(), inserts, BalChangeAction.END_INIT, this.comassistSize);
                BusinessDataWriter.save((IDataEntityType)entityType, (Object[])inserts.toArray());
                inserts.clear();
            }
            if (updates.size() < 2000) continue;
            if (!deletes.isEmpty()) {
                pks = deletes.toArray();
                this.balLogger.recordRemoveData(this.getTableName2(), pks, id2ChangeLog, BalChangeAction.END_INIT);
                BusinessDataWriter.delete((IDataEntityType)entityType, (Object[])pks);
                deletes.clear();
            }
            this.balLogger.recordInitUpdateBal(this.getTableName2(), updates, id2ChangeLog);
            this.executeBatchCur(FI, updateSql, updates);
            updates.clear();
        }
        if (!deletes.isEmpty()) {
            Object[] pks = deletes.toArray();
            this.balLogger.recordRemoveData(this.getTableName2(), pks, id2ChangeLog, BalChangeAction.END_INIT);
            BusinessDataWriter.delete((IDataEntityType)entityType, (Object[])pks);
            deletes.clear();
        }
        if (!inserts.isEmpty()) {
            this.balLogger.recordInsertDyo(this.getTableName2(), inserts, BalChangeAction.END_INIT, this.comassistSize);
            BusinessDataWriter.save((IDataEntityType)entityType, (Object[])inserts.toArray());
            inserts.clear();
        }
        if (!updates.isEmpty()) {
            this.balLogger.recordInitUpdateBal(this.getTableName2(), updates, id2ChangeLog);
            DB.executeBatch((DBRoute)FI, (String)updateSql, updates);
            updates.clear();
        }
    }

    protected void process(Map<InitBalKey, InitBalInfo> infos) {
        for (Map.Entry<InitBalKey, InitBalInfo> infosEntry : infos.entrySet()) {
            InitBalInfo initBalInfo = infosEntry.getValue();
            List<BalInfo> infoTemps = initBalInfo.getInfoTemp();
            long lastPeriod = GLUtil.MAX_PERIOD;
            for (int i = infoTemps.size() - 1; i >= 0; --i) {
                BalInfo balInfo = infoTemps.get(i);
                balInfo.setEndperiod(lastPeriod);
                boolean isAllZero = true;
                for (BigDecimal val : balInfo.getAllValues()) {
                    if (balInfo.getCount() == 0 && val.compareTo(BigDecimal.ZERO) == 0) continue;
                    lastPeriod = balInfo.getPeriod();
                    initBalInfo.getUpdateList().add(balInfo);
                    isAllZero = false;
                    break;
                }
                if (!isAllZero || balInfo.getCount() != 0) continue;
                AccountKey accountKey = new AccountKey(initBalInfo.getAccount(), initBalInfo.getAssgrp(), initBalInfo.getCurrency(), initBalInfo.getMeasureunit(), balInfo.getPeriod(), balInfo.getEndperiod(), balInfo.getId(), initBalInfo.getComassist());
                this.delDemension.add((BalKey)accountKey);
                initBalInfo.getRmvList().add(balInfo.getId());
            }
        }
    }

    protected Tuple<Map<InitBalKey, InitBalInfo>, Map<String, DataChangeLog>> updateBal(BatchInitInfo batchInitInfo, DynamicObject book) {
        HashMap<InitBalKey, InitBalInfo> infos = new HashMap<InitBalKey, InitBalInfo>(1000);
        HashMap<String, BalChangeLog> id2Log = new HashMap<String, BalChangeLog>(1000);
        long org = book.getLong(GLField.id_((String)"org"));
        long bookType = book.getLong(GLField.id_((String)"bookstype"));
        long startPeriodId = book.getLong(GLField.id_((String)"startperiod"));
        Map<InitBalKey, InitBalInfo> initBals = this.copyAndInitBal(batchInitInfo.getInitBal());
        DataSet balSet = this.getBalData(batchInitInfo, book);
        InitBalKey lastKey = null;
        InitBalInfo initBalInfo = null;
        boolean isContinue = false;
        for (Row row : balSet) {
            InitBalKey key = this.getKey(row, org, bookType);
            BalCloseChangeKey balCloseChangeKey = new BalCloseChangeKey(key, row);
            id2Log.put(balCloseChangeKey.getId() + "", balCloseChangeKey.createBalChangeLog(this.getTableName2()));
            if (key.equals(lastKey) && isContinue) {
                lastKey = key;
                continue;
            }
            if (!key.equals(lastKey)) {
                initBals.remove(lastKey);
            }
            if (initBals.containsKey(key)) {
                long periodId = row.getLong("period");
                if (!key.equals(lastKey)) {
                    isContinue = false;
                    initBalInfo = initBals.get(key);
                    initBalInfo.setExist(true);
                    if (periodId != startPeriodId) {
                        DynamicObject newBal = this.newBalance(initBalInfo, startPeriodId, periodId);
                        if (newBal == null) {
                            logger.info("initbalance is null,key=" + key);
                            isContinue = true;
                            lastKey = key;
                            continue;
                        }
                        initBalInfo.getInserts().add(newBal);
                    } else if (!this.isBalChange(initBalInfo, row)) {
                        isContinue = true;
                        lastKey = key;
                        continue;
                    }
                    infos.put(key, initBalInfo);
                }
                if (initBalInfo == null) continue;
                BalInfo balInfo = this.getBalInfo(initBalInfo, row, periodId);
                initBalInfo.getInfoTemp().add(balInfo);
                initBalInfo.setLastPeriodId(periodId);
            }
            lastKey = key;
        }
        initBals.remove(lastKey);
        if (!initBals.isEmpty()) {
            for (Map.Entry<InitBalKey, InitBalInfo> entry : initBals.entrySet()) {
                InitBalInfo itBalInfo = entry.getValue();
                DynamicObject newBal = this.newBalance(itBalInfo, startPeriodId, GLUtil.MAX_PERIOD);
                if (newBal == null) continue;
                itBalInfo.getInserts().add(newBal);
                infos.put(entry.getKey(), itBalInfo);
            }
        }
        return new Tuple(infos, id2Log);
    }

    protected abstract Map<InitBalKey, InitBalInfo> copyAndInitBal(Map<InitBalKey, InitBalInfo> var1);

    private BalInfo getBalInfo(InitBalInfo initBalInfo, Row row, long periodId) {
        boolean isCurrYear;
        BalInfo balInfo = new BalInfo(row, this.localCur);
        balInfo.setBeginfor(initBalInfo.getEndfor());
        balInfo.setBeginqty(initBalInfo.getEndqty());
        balInfo.setBeginlocal(initBalInfo.getEndlocal());
        boolean bl = isCurrYear = periodId / GLUtil.YEAR_PERIOD_L == initBalInfo.getLastPeriodId() / GLUtil.YEAR_PERIOD_L;
        if (isCurrYear) {
            initBalInfo.setYeardebitfor(initBalInfo.getYeardebitfor().add(balInfo.getDebitfor()));
            initBalInfo.setYeardebitqty(initBalInfo.getYeardebitqty().add(balInfo.getDebitqty()));
            initBalInfo.setYeardebitlocal(initBalInfo.getYeardebitlocal().add(balInfo.getDebitlocal()));
            initBalInfo.setYearcreditfor(initBalInfo.getYearcreditfor().add(balInfo.getCreditfor()));
            initBalInfo.setYearcreditqty(initBalInfo.getYearcreditqty().add(balInfo.getCreditqty()));
            initBalInfo.setYearcreditlocal(initBalInfo.getYearcreditlocal().add(balInfo.getCreditlocal()));
        } else {
            initBalInfo.setYeardebitfor(balInfo.getDebitfor());
            initBalInfo.setYeardebitqty(balInfo.getDebitqty());
            initBalInfo.setYeardebitlocal(balInfo.getDebitlocal());
            initBalInfo.setYearcreditfor(balInfo.getCreditfor());
            initBalInfo.setYearcreditqty(balInfo.getCreditqty());
            initBalInfo.setYearcreditlocal(balInfo.getCreditlocal());
        }
        balInfo.setYeardebitqty(initBalInfo.getYeardebitqty());
        balInfo.setYeardebitfor(initBalInfo.getYeardebitfor());
        balInfo.setYeardebitlocal(initBalInfo.getYeardebitlocal());
        balInfo.setYearcreditqty(initBalInfo.getYearcreditqty());
        balInfo.setYearcreditfor(initBalInfo.getYearcreditfor());
        balInfo.setYearcreditlocal(initBalInfo.getYearcreditlocal());
        initBalInfo.setEndqty(initBalInfo.getEndqty().add(balInfo.getDebitqty()).subtract(balInfo.getCreditqty()));
        initBalInfo.setEndfor(initBalInfo.getEndfor().add(balInfo.getDebitfor()).subtract(balInfo.getCreditfor()));
        initBalInfo.setEndlocal(initBalInfo.getEndlocal().add(balInfo.getDebitlocal()).subtract(balInfo.getCreditlocal()));
        balInfo.setEndqty(initBalInfo.getEndqty());
        balInfo.setEndfor(initBalInfo.getEndfor());
        balInfo.setEndlocal(initBalInfo.getEndlocal());
        for (LocalCurrencyConfigVO cur : this.localCur) {
            balInfo.getMulCurBal().put(cur.getBalanceField(MCT.BEGIN).getMetaId(), this.adapterNonBigDecimal(initBalInfo.getMulCurBal(), cur, MCT.BEGIN));
            if (isCurrYear) {
                initBalInfo.getMulCurBal().put(cur.getBalanceField(MCT.YEAR_DEBIT).getMetaId(), this.adapterNonBigDecimal(initBalInfo.getMulCurBal(), cur, MCT.YEAR_DEBIT).add(this.adapterNonBigDecimal(balInfo.getMulCurBal(), cur, MCT.DEBIT)));
                initBalInfo.getMulCurBal().put(cur.getBalanceField(MCT.YEAR_CREDIT).getMetaId(), this.adapterNonBigDecimal(initBalInfo.getMulCurBal(), cur, MCT.YEAR_CREDIT).add(this.adapterNonBigDecimal(balInfo.getMulCurBal(), cur, MCT.CREDIT)));
            } else {
                initBalInfo.getMulCurBal().put(cur.getBalanceField(MCT.YEAR_DEBIT).getMetaId(), this.adapterNonBigDecimal(balInfo.getMulCurBal(), cur, MCT.DEBIT));
                initBalInfo.getMulCurBal().put(cur.getBalanceField(MCT.YEAR_CREDIT).getMetaId(), this.adapterNonBigDecimal(balInfo.getMulCurBal(), cur, MCT.CREDIT));
            }
            balInfo.getMulCurBal().put(cur.getBalanceField(MCT.YEAR_DEBIT).getMetaId(), this.adapterNonBigDecimal(initBalInfo.getMulCurBal(), cur, MCT.YEAR_DEBIT));
            balInfo.getMulCurBal().put(cur.getBalanceField(MCT.YEAR_CREDIT).getMetaId(), this.adapterNonBigDecimal(initBalInfo.getMulCurBal(), cur, MCT.YEAR_CREDIT));
            initBalInfo.getMulCurBal().put(cur.getBalanceField(MCT.END).getMetaId(), this.adapterNonBigDecimal(initBalInfo.getMulCurBal(), cur, MCT.END).add(this.adapterNonBigDecimal(balInfo.getMulCurBal(), cur, MCT.DEBIT)).subtract(this.adapterNonBigDecimal(balInfo.getMulCurBal(), cur, MCT.CREDIT)));
            balInfo.getMulCurBal().put(cur.getBalanceField(MCT.END).getMetaId(), this.adapterNonBigDecimal(initBalInfo.getMulCurBal(), cur, MCT.END));
        }
        return balInfo;
    }

    private BigDecimal adapterNonBigDecimal(Map<String, BigDecimal> mulCurBal, LocalCurrencyConfigVO cur, MCT mct) {
        return mulCurBal.get(cur.getBalanceField(mct).getMetaId()) == null ? BigDecimal.ZERO : mulCurBal.get(cur.getBalanceField(mct).getMetaId());
    }

    private BigDecimal adapterNonBigDecimal(Row row, LocalCurrencyConfigVO cur, MCT mct) {
        return row.getBigDecimal(cur.getBalanceField(mct).getMetaId()) == null ? BigDecimal.ZERO : row.getBigDecimal(cur.getBalanceField(mct).getMetaId());
    }

    protected boolean isZero(BigDecimal decimal) {
        return decimal.compareTo(BigDecimal.ZERO) == 0;
    }

    protected abstract DataSet getBalData(BatchInitInfo var1, DynamicObject var2);

    protected boolean isBalChange(InitBalInfo initBal, Row bal) {
        if (initBal.getBeginqty().compareTo(bal.getBigDecimal("beginqty")) != 0 || initBal.getBeginfor().compareTo(bal.getBigDecimal("beginfor")) != 0 || initBal.getBeginlocal().compareTo(bal.getBigDecimal("beginlocal")) != 0) {
            return true;
        }
        BigDecimal ydq = initBal.getYeardebitqty();
        BigDecimal ydf = initBal.getYeardebitfor();
        BigDecimal ydl = initBal.getYeardebitlocal();
        BigDecimal ycq = initBal.getYearcreditqty();
        BigDecimal ycf = initBal.getYearcreditfor();
        BigDecimal ycl = initBal.getYearcreditlocal();
        BigDecimal debitqty = bal.getBigDecimal("yeardebitqty").subtract(bal.getBigDecimal("debitqty"));
        BigDecimal debitfor = bal.getBigDecimal("yeardebitfor").subtract(bal.getBigDecimal("debitfor"));
        BigDecimal debitlocal = bal.getBigDecimal("yeardebitlocal").subtract(bal.getBigDecimal("debitlocal"));
        BigDecimal creditqty = bal.getBigDecimal("yearcreditqty").subtract(bal.getBigDecimal("creditqty"));
        BigDecimal creditfor = bal.getBigDecimal("yearcreditfor").subtract(bal.getBigDecimal("creditfor"));
        BigDecimal creditlocal = bal.getBigDecimal("yearcreditlocal").subtract(bal.getBigDecimal("creditlocal"));
        if (debitqty.compareTo(ydq) != 0 || debitfor.compareTo(ydf) != 0 || debitlocal.compareTo(ydl) != 0 || creditqty.compareTo(ycq) != 0 || creditfor.compareTo(ycf) != 0 || creditlocal.compareTo(ycl) != 0) {
            return true;
        }
        for (LocalCurrencyConfigVO cur : this.localCur) {
            BigDecimal mulBeginLocal = this.adapterNonBigDecimal(bal, cur, MCT.BEGIN);
            BigDecimal mulYearDebitLocal = this.adapterNonBigDecimal(bal, cur, MCT.YEAR_DEBIT);
            BigDecimal mulDebitLocal = this.adapterNonBigDecimal(bal, cur, MCT.DEBIT);
            BigDecimal mulYearCreditLocal = this.adapterNonBigDecimal(bal, cur, MCT.YEAR_CREDIT);
            BigDecimal mulCreditLocal = this.adapterNonBigDecimal(bal, cur, MCT.CREDIT);
            if (initBal.getMulCurBal().get(cur.getBalanceField(MCT.BEGIN).getMetaId()).compareTo(mulBeginLocal) == 0 && initBal.getMulCurBal().get(cur.getBalanceField(MCT.YEAR_DEBIT).getMetaId()).compareTo(mulYearDebitLocal.subtract(mulDebitLocal)) == 0 && initBal.getMulCurBal().get(cur.getBalanceField(MCT.YEAR_CREDIT).getMetaId()).compareTo(mulYearCreditLocal.subtract(mulCreditLocal)) == 0) continue;
            return true;
        }
        return false;
    }

    private void executeBatchCur(DBRoute gl, String sql, List<Object[]> updates) {
        DB.executeBatch((DBRoute)gl, (String)sql, updates);
    }

    protected abstract DynamicObject newBalance(InitBalInfo var1, Long var2, Long var3);

    abstract InitBalKey getKey(Row var1, long var2, long var4);

    protected abstract String getTableName();

    String getTableName2() {
        return this.getTableName().toUpperCase(Locale.ROOT);
    }

    protected abstract String getEntityName();
}

