/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin.finalprocess;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.fi.accountref.AccountBookInfo;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.gl.constant.GLField;

public class AdjustMulCurSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            long bookTypeId;
            DynamicObject adjustDyn = dataEntity.getDataEntity();
            long orgId = adjustDyn.getLong("org_id");
            Collection localCurConfigs = LocalCurrencyConfigService.queryEnableCurrencies((long)orgId, (long)(bookTypeId = adjustDyn.getLong("bookstype_id")));
            if (localCurConfigs.isEmpty()) continue;
            this.fieldValueValidate(dataEntity, localCurConfigs);
            this.designatedCurValidate(dataEntity, localCurConfigs);
            this.clearTarCur(dataEntity);
        }
    }

    private void fieldValueValidate(ExtendedDataEntity dataEntity, Collection<LocalCurrencyConfigVO> localCurConfigs) {
        DynamicObject adjustDyn = dataEntity.getDataEntity();
        Set mulCurNumSet = localCurConfigs.stream().map(LocalCurrencyConfigVO::getNumber).collect(Collectors.toSet());
        String mulCurChoose = adjustDyn.getString("mulcuradjust");
        if (StringUtils.isNotBlank((CharSequence)mulCurChoose)) {
            HashSet<String> splitSet = new HashSet<String>();
            Collections.addAll(splitSet, mulCurChoose.split(","));
            splitSet.removeIf(StringUtils::isBlank);
            for (String s : splitSet) {
                if (mulCurNumSet.contains(s)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u591a\u672c\u4f4d\u5e01\u53c2\u4e0e\u8c03\u6c47\u9009\u9879\u5b58\u5728\u672a\u542f\u7528\u7684\u672c\u4f4d\u5e01\u7c7b\u578b\uff0c\u65b9\u6848\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"AdjustMulCurSaveValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private void designatedCurValidate(ExtendedDataEntity dataEntity, Collection<LocalCurrencyConfigVO> localCurConfigs) {
        DynamicObject adjustDyn = dataEntity.getDataEntity();
        String mulCurChoose = adjustDyn.getString("mulcuradjust");
        HashSet<String> mulCurItems = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)mulCurChoose)) {
            Collections.addAll(mulCurItems, mulCurChoose.split(","));
            mulCurItems.removeIf(StringUtils::isBlank);
        }
        long orgId = adjustDyn.getLong("org_id");
        long booksType = adjustDyn.getLong("bookstype_id");
        HashSet<Long> mulCurIds = new HashSet<Long>();
        for (LocalCurrencyConfigVO config : localCurConfigs) {
            if (!mulCurItems.contains(config.getNumber())) continue;
            mulCurIds.add(config.getCurrencyId(orgId, booksType));
        }
        AccountBookInfo bookInfo = new AccountBookInfo(orgId, booksType);
        if ("2".equals(adjustDyn.getString("setcuruencygroup"))) {
            HashMap<Long, Set> oriCurIds = new HashMap<Long, Set>();
            DynamicObjectCollection setCurEntry = adjustDyn.getDynamicObjectCollection("locentry");
            if ("2".equals(adjustDyn.getString("adjuststyle"))) {
                if (CollectionUtils.isNotEmpty(mulCurIds)) {
                    mulCurIds.add(bookInfo.getBaseCurrencyId());
                    Optional<DynamicObject> first = setCurEntry.stream().filter(curDyn -> !mulCurIds.contains(curDyn.getLong(GLField.id_((String)"tarcur")))).findFirst();
                    if (first.isPresent() && CollectionUtils.isNotEmpty(mulCurIds)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u76ee\u6807\u5e01\u4e0d\u5728\u671f\u672b\u8c03\u6c47\u65b9\u6848\u5bf9\u5e94\u4f1a\u8ba1\u8d26\u7c3f\u4e0e\u6838\u7b97\u4f53\u7cfb\u7684\u672c\u4f4d\u5e01\u8303\u56f4\u5185\u3002", (String)"AdjustMulCurSaveValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                for (DynamicObject curDyn2 : setCurEntry) {
                    Long locCurId = curDyn2.getLong(GLField.id_((String)"loccurrency"));
                    Set mulCur = oriCurIds.getOrDefault(locCurId, new HashSet());
                    long tarCurId = curDyn2.getLong(GLField.id_((String)"tarcur"));
                    mulCur.add(curDyn2.getLong(GLField.id_((String)"tarcur")));
                    oriCurIds.put(locCurId, mulCur);
                    if (locCurId != tarCurId) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u539f\u5e01\u5e01\u522b\u4e0e\u76ee\u6807\u5e01\u5e01\u522b\u76f8\u540c\u7684\u7ec4\u5408\uff0c\u65b9\u6848\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"AdjustMulCurSaveValidator_6", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                    return;
                }
                mulCurIds.add(bookInfo.getBaseCurrencyId());
                HashSet intersection = new HashSet(oriCurIds.keySet());
                intersection.retainAll(mulCurIds);
                if (oriCurIds.size() * mulCurIds.size() - intersection.size() != setCurEntry.size()) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6309\u6307\u5b9a\u6c47\u7387\u8c03\u6c47\u65f6\uff0c\u9700\u8981\u6839\u636e\u8c03\u6c47\u672c\u4f4d\u5e01\u6307\u5b9a\u539f\u5e01\u5230\u76ee\u6807\u5e01\u7684\u6c47\u7387\u3002", (String)"AdjustMulCurSaveValidator_3", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                    return;
                }
                for (Map.Entry entry : oriCurIds.entrySet()) {
                    if (((Set)entry.getValue()).size() == (mulCurIds.contains(entry.getKey()) ? mulCurIds.size() - 1 : mulCurIds.size())) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6309\u6307\u5b9a\u6c47\u7387\u8c03\u6c47\u65f6\uff0c\u9700\u8981\u6839\u636e\u8c03\u6c47\u672c\u4f4d\u5e01\u6307\u5b9a\u539f\u5e01\u5230\u76ee\u6807\u5e01\u7684\u6c47\u7387\u3002", (String)"AdjustMulCurSaveValidator_3", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                Set collect = setCurEntry.stream().map(dynamicObject -> dynamicObject.getLong(GLField.id_((String)"loccurrency"))).collect(Collectors.toSet());
                if (collect.size() != setCurEntry.size()) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u539f\u5e01\u5e01\u522b\uff0c\u65b9\u6848\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"AdjustMulCurSaveValidator_4", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                }
                if (collect.contains(bookInfo.getBaseCurrencyId()) && mulCurIds.isEmpty()) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u6307\u5b9a\u8d26\u7c3f\u672c\u4f4d\u5e01\u4f5c\u4e3a\u539f\u5e01\uff0c\u65b9\u6848\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"AdjustMulCurSaveValidator_5", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void clearTarCur(ExtendedDataEntity dataEntity) {
        DynamicObject adjustDyn = dataEntity.getDataEntity();
        String mulCurChoose = adjustDyn.getString("mulcuradjust");
        if (StringUtils.isBlank((CharSequence)mulCurChoose) || !"2".equals(adjustDyn.getString("adjuststyle"))) {
            adjustDyn.getDynamicObjectCollection("locentry").forEach(dynamicObject -> dynamicObject.set("tarcur", null));
        }
    }
}

