/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin.reci;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.business.service.reciprocal.UnAcccurrentUpdateUtil;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.lock.Lock;
import kd.fi.gl.lock.LockKey;
import kd.fi.gl.opplugin.reci.ReciprocalEndInitValidator;
import kd.fi.gl.reciprocal.ReciprocalInitUtils;
import kd.fi.gl.reciprocal.ReciprocalUtils;

public class ReciprocalEndInitOp
extends AbstractOperationServicePlugIn {
    private DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.reciEndInit);
    private static final Log logger = LogFactory.getLog(ReciprocalEndInitOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ReciprocalEndInitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        long orgId = Long.parseLong(this.getOption().getVariableValue("org"));
        long bookTypeId = Long.parseLong(this.getOption().getVariableValue("bookstype"));
        AccountBookInfo accountBookInfo = new AccountBookInfo(orgId, bookTypeId);
        if (!Lock.tryLock((long)orgId, (long)bookTypeId, (LockKey)LockKey.CurrentAcctEndInit, () -> this.handleEndInit(accountBookInfo, dataEntities))) {
            logger.info("ReciprocalEndInitOp_tryLock_failure_orgId:{},bookYypeId:{}", (Object)orgId, (Object)bookTypeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEndInit(AccountBookInfo accountBookInfo, DynamicObject[] dataEntities) {
        Long orgId = accountBookInfo.getOrgId();
        Long bookType = accountBookInfo.getBookTypeId();
        Long acctTable = accountBookInfo.getAccountTableId();
        Long localCurrency = accountBookInfo.getBaseCurrencyId();
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)bookType);
        String logPrefix = "handleEndInit";
        ArrayList<DynamicObject> failDyns = new ArrayList<DynamicObject>(8);
        String orgBookTypeKey = ReciprocalUtils.getAccountBookKey((Object)orgId, (Object)bookType);
        for (DynamicObject entity : dataEntities) {
            try {
                DynamicObject account = entity.getDynamicObject("account");
                Long accountId = account.getLong("id");
                Long acctMstId = account.getLong("masterid");
                Long endInitPeriodId = entity.getLong(GLField.id((String)"period"));
                String acctMstIdStr = String.valueOf(acctMstId);
                String cacheValue = this.cache.get(orgBookTypeKey);
                Map acctMstIdMap = Objects.isNull(cacheValue) ? new HashMap(10) : (Map)SerializationUtils.fromJsonString((String)cacheValue, Map.class);
                acctMstIdMap.put(acctMstIdStr, endInitPeriodId);
                this.cache.put(orgBookTypeKey, SerializationUtils.toJsonString(acctMstIdMap));
                QFilter accountFilter = new QFilter("account.masterid", "=", (Object)acctMstId);
                DynamicObject reciprocalInitState = BusinessDataServiceHelper.loadSingle((String)"gl_reci_init_state", (String)"id,endinitperiod, isendinit, modifier, modifydate", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, accountFilter});
                if (reciprocalInitState == null) {
                    ReciprocalUtils.delAcccBeforePeroid((Long)orgId, (Long)bookType, (Long)account.getLong("masterid"), (Long)endInitPeriodId);
                }
                DynamicObject period = PeriodUtil.getPeriod((Long)endInitPeriodId, (String)"id,begindate");
                long tick = System.currentTimeMillis();
                this.handleRecordAddNewByInit(accountBookInfo, orgFilter, bookTypeFilter, account, acctTable, period);
                logger.info("{} handleRecordAddNewByInit cost:{}ms", (Object)logPrefix, (Object)(System.currentTimeMillis() - tick));
                tick = System.currentTimeMillis();
                this.handleRecordUpdateByInit(orgFilter, bookTypeFilter, account, reciprocalInitState, period);
                logger.info("{} handleRecordUpdateByInit cost:{}ms", (Object)logPrefix, (Object)(System.currentTimeMillis() - tick));
                tick = System.currentTimeMillis();
                Boolean isSuccess = this.batchSaveReciprocalRecordsEndInitNew(orgId, bookType, endInitPeriodId, account.getLong("masterid"), localCurrency, acctTable, reciprocalInitState);
                logger.info("{} batchSaveReciprocalRecordsEndInitNew cost:{}ms", (Object)logPrefix, (Object)(System.currentTimeMillis() - tick));
                tick = System.currentTimeMillis();
                UnAcccurrentUpdateUtil.asyncReCalUnAcccurrent((long)orgId, (long)bookType, (long)acctTable, (Long)acctMstId);
                logger.info("endreciprocalinit ReciprocalUtils.reCalUnAcccurrent cost:{}ms", (Object)(System.currentTimeMillis() - tick));
                if (reciprocalInitState == null) {
                    reciprocalInitState = BusinessDataServiceHelper.newDynamicObject((String)"gl_reci_init_state");
                    reciprocalInitState.set("org", (Object)orgId);
                    reciprocalInitState.set("booktype", (Object)bookType);
                    reciprocalInitState.set("accounttable", (Object)acctTable);
                    reciprocalInitState.set("account", (Object)accountId);
                }
                reciprocalInitState.set("endinitperiod", (Object)endInitPeriodId);
                reciprocalInitState.set("isendinit", (Object)true);
                reciprocalInitState.set("modifier_id", (Object)RequestContext.get().getCurrUserId());
                reciprocalInitState.set("modifydate", (Object)TimeServiceHelper.now());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reciprocalInitState});
                String chValue = this.cache.get(orgBookTypeKey);
                if (Objects.nonNull(chValue)) {
                    acctMstIdMap = (Map)SerializationUtils.fromJsonString((String)chValue, Map.class);
                    acctMstIdMap.remove(acctMstIdStr);
                }
                this.cache.put(orgBookTypeKey, SerializationUtils.toJsonString(acctMstIdMap));
            }
            catch (Exception e) {
                logger.error(logPrefix + " producer: ABORT on error:" + e.getMessage(), (Throwable)e);
                failDyns.add(entity);
            }
            finally {
                if (this.operateOption.containsVariable("finishedCountKey")) {
                    String finishedCountKey = this.cache.get(this.operateOption.getVariableValue("finishedCountKey"));
                    finishedCountKey = Objects.isNull(finishedCountKey) ? "1" : String.valueOf(Long.parseLong(finishedCountKey) + 1L);
                    this.cache.put(this.operateOption.getVariableValue("finishedCountKey"), finishedCountKey);
                }
            }
        }
        for (DynamicObject failDyn : failDyns) {
            OperateErrorInfo errorInfo = new OperateErrorInfo("", ErrorLevel.FatalError, failDyn.getPkValue());
            errorInfo.setMessage(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u79d1\u76ee\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"ReciprocalEndInitOp_0", (String)"fi-gl-opplugin", (Object[])new Object[0]), failDyn.getString("account.number")));
            errorInfo.setLevel(ErrorLevel.Error);
            Map name = (Map)this.operateMeta.get("name");
            errorInfo.setTitle((String)name.get(Lang.get().name()));
            this.getOperationResult().setSuccess(Boolean.FALSE.booleanValue());
            this.getOperationResult().addErrorInfo(errorInfo);
        }
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        List errorInfos = e.getOperationResult().getAllErrorInfo();
        if (!errorInfos.isEmpty()) {
            for (OperateErrorInfo operateErrorInfo : errorInfos) {
                e.getOperationResult().getSuccessPkIds().remove(operateErrorInfo.getPkValue());
            }
        }
    }

    public Boolean batchSaveReciprocalRecordsEndInitNew(Long org, Long bookType, Long period, Long accountid, Long localCurrency, Long acctTable, DynamicObject reciprocalInitState) {
        List lstFilters = ReciprocalUtils.buildFilter((DynamicObject)reciprocalInitState, (long)org, (long)bookType, (long)period, (long)accountid);
        QFilter[] enhanceFilters = VoucherQueryUtils.enhanceFilters((QFilter[])lstFilters.toArray(new QFilter[0]), (boolean)false);
        ArrayList<Future> futures = new ArrayList<Future>(16);
        try (DataSet dataSet = ORM.create().queryDataSet(ReciprocalUtils.class.getName() + ".batchSaveReciprocalRecordsEndInitNew", "gl_voucher", "id", enhanceFilters, null, -1, (Distinctable)WithDistinctable.get());){
            DataSet distinctDs = dataSet.distinct();
            int splitSize = 999;
            ArrayList<Long> voucherIds = new ArrayList<Long>(splitSize);
            while (distinctDs.hasNext()) {
                Row row = distinctDs.next();
                voucherIds.add(row.getLong("id"));
                if (voucherIds.size() < splitSize && distinctDs.hasNext()) continue;
                ArrayList copyVchIds = new ArrayList(voucherIds);
                Future future = ThreadService.submit(() -> ReciprocalUtils.saveReciprocalRecordEndInitOnce((Long)localCurrency, (Long)acctTable, (Collection)lstFilters, (List)copyVchIds), (TaskType)TaskType.GL_ACCOUNT_CURRENT_END_INIT_DETAIL);
                futures.add(future);
                voucherIds.clear();
            }
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return Boolean.TRUE;
    }

    private void handleRecordAddNewByInit(AccountBookInfo accountBookInfo, QFilter orgFilter, QFilter bookTypeFilter, DynamicObject account, Long acctTblId, DynamicObject period) {
        while (true) {
            TXHandle tx = TX.requiresNew();
            Throwable throwable = null;
            try {
                List reciprocalRecordList = ReciprocalInitUtils.buildReciprocalRecordFromInit((DynamicObject)account, (AccountBookInfo)accountBookInfo, (QFilter)orgFilter, (QFilter)bookTypeFilter, (Long)acctTblId, (DynamicObject)period);
                if (reciprocalRecordList.size() == 0) break;
                try {
                    SaveServiceHelper.save((DynamicObject[])reciprocalRecordList.toArray(new DynamicObject[0]));
                    reciprocalRecordList.clear();
                    continue;
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("\u5f80\u6765\u521d\u59cb\u5316\u589e\u91cf\u65b0\u589e\u5f80\u6765\u8d26\u51fa\u9519\uff1a", (Throwable)e);
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f80\u6765\u521d\u59cb\u5316\u589e\u91cf\u65b0\u589e\u5f80\u6765\u8d26\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u6392\u67e5\u3002", (String)"ReciprocalInitEndInitPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
                continue;
            }
            break;
        }
    }

    private void handleRecordUpdateByInit(QFilter orgFilter, QFilter bookTypeFilter, DynamicObject account, DynamicObject reciprocalInitState, DynamicObject period) {
        QFilter acctFilter = new QFilter("account.masterid", "=", (Object)account.getLong("masterid"));
        QFilter recordIsNullFilter = new QFilter("reciprocalrecord", "!=", (Object)0L);
        QFilter recordStatusFilter = new QFilter("reciprocalrecord.status", "=", (Object)"0");
        if (Objects.isNull(reciprocalInitState)) {
            return;
        }
        QFilter modifyDateFilter = new QFilter("modifydate", ">=", (Object)reciprocalInitState.getDate("modifydate"));
        QFilter[] filters = new QFilter[]{acctFilter, orgFilter, bookTypeFilter, recordIsNullFilter, recordStatusFilter, modifyDateFilter};
        ArrayList<Long> initPkIds = new ArrayList<Long>(10);
        ArrayList<Future> futures = new ArrayList<Future>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "handleRecordUpdateByInit"), (String)"gl_initacccurrent", (String)"id", (QFilter[])filters, null);){
            if (ds != null) {
                for (Row row : ds) {
                    initPkIds.add(row.getLong("id"));
                    if (initPkIds.size() < 999 && ds.hasNext()) continue;
                    HashSet updatingIdsCopy = new HashSet(initPkIds);
                    Future future = ThreadService.submit(() -> this.updateReciprocalRecordOnce(updatingIdsCopy, period), (TaskType)TaskType.GL_ACCOUNT_CURRENT_END_INIT_DETAIL);
                    futures.add(future);
                    initPkIds.clear();
                }
            }
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private Boolean updateReciprocalRecordOnce(Set<Long> updatingIds, DynamicObject period) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

