/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin.reci;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.reciprocal.TransBalToReciUtil;

public class ReciprocalEndInitValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(ReciprocalEndInitValidator.class);

    public void validate() {
        long orgId = Long.parseLong(this.getOption().getVariableValue("org"));
        long bookTypeId = Long.parseLong(this.getOption().getVariableValue("bookstype"));
        AccountBookInfo accountBookInfo = new AccountBookInfo(orgId, bookTypeId);
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        ArrayList<Long> accountIds = new ArrayList<Long>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject account2 = (DynamicObject)dataEntity.getValue("account");
            accountIds.add(account2.getLong("id"));
        }
        long tick = System.currentTimeMillis();
        DynamicObject[] accounts = BusinessDataServiceHelper.load((Object[])accountIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
        HashMap accountIdDynMap = new HashMap(32);
        Arrays.stream(accounts).forEach(account -> accountIdDynMap.put(account.getLong("id"), account));
        logger.info("endreciprocalinit query accounts cost:{}ms", (Object)(System.currentTimeMillis() - tick));
        if (!accountBookInfo.isIsendinit()) {
            return;
        }
        for (ExtendedDataEntity rowEntity : dataEntities) {
            DynamicObject pageAccount = (DynamicObject)rowEntity.getValue("account");
            DynamicObject account3 = (DynamicObject)accountIdDynMap.get(pageAccount.getLong("id"));
            DynamicObject pagePeriod = (DynamicObject)rowEntity.getValue("period");
            Long periodId = pagePeriod.getLong("id");
            String number = account3.getString("number");
            String fullName = account3.getString("fullname");
            String accountShow = number + fullName;
            if (periodId == 0L) {
                this.addErrorMessage(rowEntity, String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u201c%s\u201d\u6ca1\u6709\u8bbe\u7f6e\u521d\u59cb\u5316\u671f\u95f4\uff0c\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"ReciprocalInitValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[0]), accountShow));
                continue;
            }
            if (periodId.longValue() != accountBookInfo.getCurPeriodId()) {
                this.addErrorMessage(rowEntity, String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u201c%s\u201d\u521d\u59cb\u5316\u671f\u95f4\u4e0d\u662f\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"ReciprocalInitValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0]), accountShow));
                continue;
            }
            TransBalToReciUtil transBalToReciUtil = new TransBalToReciUtil();
            String compareMsg = transBalToReciUtil.compareBalanceWithReciprocal(account3, periodId, accountBookInfo);
            if (compareMsg.isEmpty()) continue;
            this.addErrorMessage(rowEntity, compareMsg);
        }
    }
}

