/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.validate;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;

public class ReciprocalSchemeSaveValidator
extends AbstractValidator {
    private static final String ENTITY_NAME = "gl_reciprocal_scheme";

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dyn = dataEntity.getDataEntity();
            if (dyn == null) continue;
            if (StringUtils.isEmpty((String)dyn.getString("number"))) {
                return;
            }
            if (StringUtils.isEmpty((String)dyn.getString("name"))) {
                return;
            }
            if (StringUtils.isEmpty((String)dyn.getString("verifiorder"))) {
                return;
            }
            if (StringUtils.isEmpty((String)dyn.getString("writeoffway"))) {
                return;
            }
            int size = this.checkNumberUnique(dyn);
            String number = dyn.getString("number");
            String orgName = dyn.getDynamicObject("useorg").getString("name");
            if (size > 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%1$s\u7684\u6838\u9500\u65b9\u6848\u5df2\u5728%2$s\u7ec4\u7ec7\u4e2d\u5b58\u5728\u3002", (String)"ReciprocalSchemeSaveValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0]), number, orgName));
                return;
            }
            dyn.set("status", (Object)"C");
            Long id = dyn.getLong("id");
            Long orgid = dyn.getDynamicObject("useorg").getLong("id");
            Long accounttableid = dyn.getDynamicObject("accounttable").getLong("id");
            DynamicObjectCollection accountDyns = dyn.getDynamicObjectCollection("account");
            HashSet<String> accountSet = new HashSet<String>();
            for (DynamicObject account : accountDyns) {
                accountSet.add(account.getString("fbasedataid_id"));
            }
            DynamicObjectCollection currencyDyns = dyn.getDynamicObjectCollection("currency");
            HashSet<String> currencySet = new HashSet<String>();
            for (DynamicObject currency : currencyDyns) {
                currencySet.add(currency.getString("fbasedataid_id"));
            }
            String writeoffWay = dyn.getString("writeoffway");
            DynamicObject scheme = this.getScheme(accountSet, currencySet, id, orgid, accounttableid, writeoffWay);
            if (scheme == null) continue;
            String schemeName = scheme.getString("name");
            String accountid = scheme.getString("accountid");
            DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(accountid))});
            if (account != null) {
                String accountname = account.getString("name");
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u79d1\u76ee\u5df2\u7ecf\u5b58\u5728%2$s\u65b9\u6848\u4e2d\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"ReciprocalSchemeSaveValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[0]), accountname, schemeName));
                return;
            }
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728%s\u65b9\u6848\u4e2d\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"ReciprocalSchemeSaveValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0]), schemeName));
            return;
        }
    }

    private int checkNumberUnique(DynamicObject dyn) {
        int size = 0;
        Long id = dyn.getLong("id");
        String number = dyn.getString("number");
        DynamicObject org = dyn.getDynamicObject("useorg");
        DynamicObject accounttable = dyn.getDynamicObject("accounttable");
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)ENTITY_NAME, (Long)org.getLong("id"));
        QFilter idFilter = new QFilter("id", "!=", (Object)id);
        QFilter idTableFilter = new QFilter("accounttable.id", "=", (Object)accounttable.getLong("id"));
        DynamicObjectCollection schemes = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id", (QFilter[])new QFilter[]{numberFilter, orgFilter, idFilter, idTableFilter});
        if (schemes != null) {
            size = schemes.size();
        }
        return size;
    }

    private DynamicObject getScheme(Set<String> accountSet, Set<String> currencySet, Long id, Long orgId, Long accounttableid, String writeoffWay) {
        List accountIds = accountSet.stream().mapToLong(x -> Long.parseLong(x)).boxed().collect(Collectors.toList());
        List currencyIds = currencySet.stream().mapToLong(x -> Long.parseLong(x)).boxed().collect(Collectors.toList());
        QFilter accountFilter = null;
        QFilter currencyFilter = null;
        QFilter idFilter = null;
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)ENTITY_NAME, (Long)orgId);
        QFilter accountTableFilter = new QFilter("accounttable", "=", (Object)accounttableid);
        if (id != 0L) {
            idFilter = new QFilter("id", "!=", (Object)id);
        }
        if (accountIds.isEmpty() && currencyIds.isEmpty()) {
            accountFilter = new QFilter("account.fbasedataid", "is null", null);
            currencyFilter = new QFilter("currency.fbasedataid", "is null", null);
        } else if (accountIds.isEmpty() && !currencyIds.isEmpty()) {
            accountFilter = new QFilter("account.fbasedataid", "is null", null);
            currencyFilter = new QFilter("currency.fbasedataid", "in", currencyIds);
        } else if (!accountIds.isEmpty() && currencyIds.isEmpty()) {
            accountFilter = new QFilter("account.fbasedataid", "in", accountIds);
            currencyFilter = new QFilter("currency.fbasedataid", "is null", null);
        } else {
            accountFilter = new QFilter("account.fbasedataid", "in", accountIds);
            currencyFilter = new QFilter("currency.fbasedataid", "in", currencyIds);
        }
        ArrayList<String> writeoffWayList = new ArrayList<String>(3);
        writeoffWayList.add("0");
        if (writeoffWay.equals("1")) {
            writeoffWayList.add("1");
        } else if (writeoffWay.equals("2")) {
            writeoffWayList.add("2");
        } else if (writeoffWay.equals("0")) {
            writeoffWayList.add("1");
            writeoffWayList.add("2");
        }
        QFilter writeoffWayFilter = new QFilter("writeoffway", "in", writeoffWayList);
        DynamicObject scheme = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"name,account.fbasedataid accountid", (QFilter[])new QFilter[]{accountFilter, idFilter, currencyFilter, orgFilter, accountTableFilter, writeoffWayFilter});
        return scheme;
    }
}

