/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.validate.bigdata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.validate.bigdata.Context;
import kd.fi.gl.validate.bigdata.ExtDataEntityWrapper;
import kd.fi.gl.validate.bigdata.RowWrapper;
import kd.fi.gl.validate.bigdata.ValidateArg;
import kd.fi.gl.validate.bigdata.ValidateScope;
import kd.fi.gl.wrap.EntryWrapper;

public abstract class AbstractBigEntryValidator
extends AbstractValidator {
    private Context context;

    protected Context getContext() {
        return this.context;
    }

    public void validate() {
        try {
            this.context = this.initContext(this.dataEntities);
            ValidateArg validateArg = new ValidateArg(ValidateScope.ALL);
            this.loopAllDataEntities(validateArg);
            if (validateArg.isCancel()) {
                return;
            }
            this.doValidate(validateArg);
        }
        finally {
            if (this.context != null) {
                this.context.close();
            }
        }
    }

    private void loopAllDataEntities(ValidateArg validateArg) {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            ExtDataEntityWrapper extDataEntityWrapper = this.wrapDataEntity(dataEntity);
            this.onLoopDataEntities(validateArg, extDataEntityWrapper);
        }
    }

    private void doValidate(ValidateArg validateArg) {
        this.beforeValidateAllDataEntities(validateArg);
        if (validateArg.isCancel()) {
            return;
        }
        ValidateArg dbValidateArg = new ValidateArg(ValidateScope.DATAENTITIES, validateArg);
        this.doValidateDbDataEntities(dbValidateArg);
        if (validateArg.isCancel()) {
            return;
        }
        ValidateArg dataEntitesValidateArg = new ValidateArg(ValidateScope.DATAENTITIES, validateArg);
        this.doValidateDataEntities(dataEntitesValidateArg);
        if (validateArg.isCancel()) {
            return;
        }
        this.afterValidateAllDataEntities(validateArg);
    }

    private void doValidateDbDataEntities(ValidateArg dbValidateArg) {
        Map<Long, ExtDataEntityWrapper> idDataEntityMap = this.context.getIdDataEntityMap();
        if (idDataEntityMap.isEmpty()) {
            return;
        }
        this.beforeValidateDataEntitiesFormDb(dbValidateArg, idDataEntityMap);
        if (dbValidateArg.isCancel()) {
            return;
        }
        this.validateDataEntitiesFromDb(dbValidateArg, idDataEntityMap);
        if (dbValidateArg.isCancel()) {
            return;
        }
        this.afterValidateDataEntitiesFormDb(dbValidateArg, idDataEntityMap);
    }

    private void doValidateDataEntities(ValidateArg dataEntitesValidateArg) {
        List<ExtDataEntityWrapper> newDataEntities = this.context.getNewDataEntities();
        if (newDataEntities.isEmpty()) {
            return;
        }
        this.beforeValidateDataEntities(dataEntitesValidateArg, newDataEntities);
        if (dataEntitesValidateArg.isCancel()) {
            return;
        }
        this.validateDataEntities(dataEntitesValidateArg, newDataEntities);
        if (dataEntitesValidateArg.isCancel()) {
            return;
        }
        this.afterValidateDataEntities(dataEntitesValidateArg, newDataEntities);
    }

    protected Context initContext(ExtendedDataEntity[] dataEntities) {
        Context context = this.buildContext();
        context.setOperateOption(this.getOption());
        context.setAllDataEntityWrapper(new ArrayList<ExtDataEntityWrapper>(dataEntities.length));
        context.setIdDataEntityMap(new LinkedHashMap<Long, ExtDataEntityWrapper>(dataEntities.length));
        context.setNewDataEntities(new ArrayList<ExtDataEntityWrapper>(dataEntities.length));
        return context;
    }

    protected void onLoopDataEntities(ValidateArg validateArg, ExtDataEntityWrapper extDataEntityWrapper) {
        this.context.getAllDataEntityWrapper().add(extDataEntityWrapper);
        if (extDataEntityWrapper.isFromDb()) {
            this.context.getIdDataEntityMap().put(extDataEntityWrapper.getId(), extDataEntityWrapper);
        } else {
            this.context.getNewDataEntities().add(extDataEntityWrapper);
        }
        DynamicObjectCollection entries = extDataEntityWrapper.getEntries();
        if (entries != null && !entries.isEmpty()) {
            extDataEntityWrapper.setEntryWrappers(new ArrayList<EntryWrapper>(entries.size()));
            extDataEntityWrapper.setEntryWrapperMap(new LinkedHashMap<Long, EntryWrapper>(entries.size()));
            extDataEntityWrapper.setNewEntryWrappers(new ArrayList<EntryWrapper>(entries.size()));
            for (DynamicObject entryDyn : entries) {
                EntryWrapper entryWrapper = this.wrapEntryDyn(entryDyn);
                this.onLoopEntries(extDataEntityWrapper, entryWrapper);
            }
        } else {
            extDataEntityWrapper.setEntryWrappers(Collections.emptyList());
            extDataEntityWrapper.setEntryWrapperMap(Collections.emptyMap());
            extDataEntityWrapper.setNewEntryWrappers(Collections.emptyList());
        }
    }

    protected void onLoopEntries(ExtDataEntityWrapper extDataEntityWrapper, EntryWrapper entryWrapper) {
        extDataEntityWrapper.getEntryWrappers().add(entryWrapper);
        long entryId = entryWrapper.getEntryId();
        if (entryId > 0L) {
            extDataEntityWrapper.getEntryWrapperMap().put(entryId, entryWrapper);
        } else {
            extDataEntityWrapper.getNewEntryWrappers().add(entryWrapper);
        }
    }

    protected void beforeValidateAllDataEntities(ValidateArg validateAllArg) {
    }

    protected void beforeValidateDataEntities(ValidateArg dataEntitesValidateArg, List<ExtDataEntityWrapper> dataEntities) {
    }

    protected void validateDataEntities(ValidateArg dataEntitesValidateArg, List<ExtDataEntityWrapper> dataEntities) {
        for (ExtDataEntityWrapper dataEntityWrapper : dataEntities) {
            ValidateArg dataValidateArg = new ValidateArg(ValidateScope.DATAENTITY, dataEntitesValidateArg);
            this.validateDataEntity(dataValidateArg, dataEntityWrapper);
        }
    }

    protected void beforeValidateDataEntity(ValidateArg dataValidateArg, ExtDataEntityWrapper dataEntityWrapper) {
    }

    protected void validateDataEntity(ValidateArg dataValidateArg, ExtDataEntityWrapper dataEntityWrapper) {
        this.beforeValidateDataEntity(dataValidateArg, dataEntityWrapper);
        if (dataValidateArg.isCancel()) {
            return;
        }
        List<EntryWrapper> entryWrappers = dataEntityWrapper.getEntryWrappers();
        if (entryWrappers != null && !entryWrappers.isEmpty()) {
            for (EntryWrapper entryWrapper : entryWrappers) {
                this.validateEntry(dataValidateArg, dataEntityWrapper, entryWrapper);
            }
        }
        this.afterValidateDataEntity(dataValidateArg, dataEntityWrapper);
    }

    protected void afterValidateDataEntity(ValidateArg dataValidateArg, ExtDataEntityWrapper dataEntityWrapper) {
    }

    protected void validateEntry(ValidateArg dataValidateArg, ExtDataEntityWrapper dataEntityWrapper, EntryWrapper entryWrapper) {
    }

    protected void afterValidateDataEntities(ValidateArg dataEntitesValidateArg, List<ExtDataEntityWrapper> dataEntities) {
    }

    protected void beforeValidateDataEntitiesFormDb(ValidateArg dbValidateArg, Map<Long, ExtDataEntityWrapper> idDataEntityMap) {
    }

    protected void validateDataEntitiesFromDb(ValidateArg dbValidateArg, Map<Long, ExtDataEntityWrapper> idDataEntityMap) {
        HashMap<Long, ExtDataEntityWrapper> tempIdDataEntityMap = new HashMap<Long, ExtDataEntityWrapper>(idDataEntityMap);
        this.context.setTempIdDataEntityMap(tempIdDataEntityMap);
        if (tempIdDataEntityMap.isEmpty()) {
            return;
        }
        Set<Long> idSet = tempIdDataEntityMap.keySet();
        try (DataSet dataSet = this.queryDataSetByIdSet(idSet);){
            long validateId = -1L;
            ExtDataEntityWrapper validateDataEntityWrapper = null;
            ValidateArg dataValidateArg = null;
            for (Row row : dataSet) {
                RowWrapper rowWrapper = this.wrapRow(row);
                long id = rowWrapper.getId();
                if (id != validateId) {
                    if (validateId >= 0L && validateDataEntityWrapper != null && dataValidateArg != null && !dataValidateArg.isCancel()) {
                        this.afterOneBillDataSetRowValidated(dataValidateArg, validateDataEntityWrapper);
                    }
                    validateId = id;
                    validateDataEntityWrapper = (ExtDataEntityWrapper)tempIdDataEntityMap.remove(validateId);
                    dataValidateArg = new ValidateArg(ValidateScope.DATAENTITY, dbValidateArg);
                    this.beforeValidateOneBillDataSetRow(dataValidateArg, validateDataEntityWrapper);
                }
                if (dataValidateArg == null || dataValidateArg.isCancel()) continue;
                this.validateDataSetRow(dataValidateArg, validateDataEntityWrapper, validateId, rowWrapper);
            }
            if (dataValidateArg != null && !dataValidateArg.isCancel()) {
                this.afterOneBillDataSetRowValidated(dbValidateArg, validateDataEntityWrapper);
            }
        }
    }

    protected DataSet queryDataSetByIdSet(Set<Long> idSet) {
        QFilter idFilter = new QFilter("id", "in", idSet);
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.getEntityKey(), (String)this.getDataSetSelect(), (QFilter[])idFilter.toArray(), (String)"id");
    }

    protected void beforeValidateOneBillDataSetRow(ValidateArg dbValidateArg, ExtDataEntityWrapper extDataEntityWrapper) {
    }

    protected void validateDataSetRow(ValidateArg dbValidateArg, ExtDataEntityWrapper extDataEntityWrapper, long validateId, RowWrapper rowWrapper) {
    }

    protected void afterOneBillDataSetRowValidated(ValidateArg dbValidateArg, ExtDataEntityWrapper extDataEntityWrapper) {
        List<EntryWrapper> newEntryWrappers = extDataEntityWrapper.getNewEntryWrappers();
        if (newEntryWrappers != null && !newEntryWrappers.isEmpty()) {
            for (EntryWrapper entryWrapper : newEntryWrappers) {
                this.validateEntry(dbValidateArg, extDataEntityWrapper, entryWrapper);
                if (!dbValidateArg.isCancel()) continue;
                return;
            }
        }
    }

    protected void afterValidateDataEntitiesFormDb(ValidateArg dbValidateArg, Map<Long, ExtDataEntityWrapper> idDataEntityMap) {
        if (!this.context.getTempIdDataEntityMap().isEmpty()) {
            this.context.getNewDataEntities().addAll(this.context.getTempIdDataEntityMap().values());
        }
    }

    protected void afterValidateAllDataEntities(ValidateArg validateArg) {
    }

    protected abstract Context buildContext();

    protected abstract String getDataSetSelect();

    protected abstract RowWrapper wrapRow(Row var1);

    protected abstract ExtDataEntityWrapper wrapDataEntity(ExtendedDataEntity var1);

    protected abstract EntryWrapper wrapEntryDyn(DynamicObject var1);
}

