/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.validate.bigdata;

import kd.bos.dataentity.OperateOption;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class OptionWrapper {
    private static final Log LOG = LogFactory.getLog(OptionWrapper.class);
    private final OperateOption option;

    public OptionWrapper(OperateOption option) {
        this.option = option;
    }

    protected boolean containsVariable(String name) {
        if (this.option.containsVariable(name)) {
            LOG.warn("detect custom variable, name:{}", (Object)name);
            return true;
        }
        return false;
    }

    protected String getVariableValue(String name, String defaultVal) {
        String result = this.option.getVariableValue(name, defaultVal);
        if (!defaultVal.equals(result)) {
            LOG.warn("detect custom variable, name:{}, value:{}", (Object)name, (Object)result);
        }
        return result;
    }

    protected void setVariableValue(String name, String value) {
        this.option.setVariableValue(name, value);
    }
}

