/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.validate.bigdata;

import java.util.Arrays;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.validate.ErrorLevel;
import kd.fi.gl.voucher.validate.VoucherValidateMsgFormatter;

public class ValidateResult {
    public String msg;
    public ErrorLevel errorLevel;
    public boolean success;

    public static ValidateResult create() {
        ValidateResult vchValidateResult = new ValidateResult();
        vchValidateResult.setSuccess(Boolean.TRUE);
        vchValidateResult.setMsg("");
        vchValidateResult.setErrorLevel(ErrorLevel.Info);
        return vchValidateResult;
    }

    private ValidateResult() {
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setErrorLevel(ErrorLevel errorLevel) {
        this.errorLevel = errorLevel;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMsg() {
        return this.msg;
    }

    public ErrorLevel getErrorLevel() {
        return this.errorLevel;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public ValidateResult setErrorMsg(String msg) {
        this.setMsg(msg);
        this.setErrorLevel(ErrorLevel.Error);
        this.setSuccess(false);
        return this;
    }

    public ValidateResult merge(ValidateResult result) {
        if (!result.isSuccess()) {
            this.setSuccess(false);
        }
        String originalMsg = this.getMsg();
        String toMerge = result.getMsg();
        if (StringUtils.isNotBlank((CharSequence)toMerge)) {
            if (StringUtils.isBlank((CharSequence)originalMsg)) {
                this.setMsg(toMerge);
            } else {
                this.setMsg(VoucherValidateMsgFormatter.get().join(Arrays.asList(originalMsg, toMerge)));
            }
        }
        return this;
    }
}

