/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.validate.flex;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.flex.FlexProperty;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.validate.flex.AbstractFlexValueValidator;
import kd.fi.gl.validate.flex.FlexValueDataGetter;

public class BaseDataFlexValueValidator
extends AbstractFlexValueValidator {
    private static final String ISLEAF = "isleaf";
    private static final String ENABLE = "enable";
    private final Map<String, Tuple<Boolean, Boolean>> entityPropCache = new HashMap<String, Tuple<Boolean, Boolean>>(8);

    @Override
    public Set<Long> getParentDataSet(FlexValueDataGetter flexValueDataGetter, FlexProperty flexProperty) {
        return this.getDataSet(flexValueDataGetter, flexProperty, ISLEAF);
    }

    @Override
    public Set<Long> getDisableDataSet(FlexValueDataGetter flexValueDataGetter, FlexProperty flexProperty) {
        return this.getDataSet(flexValueDataGetter, flexProperty, ENABLE);
    }

    Set<Long> getDataSet(FlexValueDataGetter flexValueDataGetter, FlexProperty flexProperty, String type) {
        String entityName = this.getEntity(flexProperty);
        if (StringUtils.isBlank((CharSequence)entityName)) {
            return Collections.emptySet();
        }
        QFBuilder qfBuilder = new QFBuilder(type, "=", (Object)Boolean.FALSE);
        switch (type) {
            case "isleaf": {
                if (this.hasLeafProp(entityName).booleanValue()) {
                    return flexValueDataGetter.getParentDataSet(entityName, qfBuilder, entityName, "id");
                }
                return Collections.emptySet();
            }
            case "enable": {
                if (!this.hasEnableProp(entityName).booleanValue()) break;
                return flexValueDataGetter.getDisableDataSet(entityName, qfBuilder, entityName, "id");
            }
        }
        return Collections.emptySet();
    }

    private Boolean hasLeafProp(String entityName) {
        return (Boolean)this.entityPropCache.computeIfAbsent((String)entityName, (Function<String, Tuple>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, loadProp(java.lang.String ), (Ljava/lang/String;)Lkd/bos/dataentity/Tuple;)((BaseDataFlexValueValidator)this)).item1;
    }

    private Boolean hasEnableProp(String entityName) {
        return (Boolean)this.entityPropCache.computeIfAbsent((String)entityName, (Function<String, Tuple>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, loadProp(java.lang.String ), (Ljava/lang/String;)Lkd/bos/dataentity/Tuple;)((BaseDataFlexValueValidator)this)).item2;
    }

    private Tuple<Boolean, Boolean> loadProp(String entityName) {
        DataEntityPropertyCollection props = EntityMetadataCache.getDataEntityType((String)entityName).getProperties();
        return Tuple.create((Object)props.containsKey((Object)ISLEAF), (Object)props.containsKey((Object)ENABLE));
    }

    private String getEntity(FlexProperty flexProperty) {
        if ("1".equals(flexProperty.getValueType())) {
            return flexProperty.getValueSource();
        }
        return null;
    }
}

