/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.PkSnapshot;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.ext.fi.ai.dap.cache.CacheKeyPrefix;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheHelper;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheKey;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;

public class VoucherEntryRedundantService {
    private static final Log LOG = LogFactory.getLog(VoucherEntryRedundantService.class);
    private static final String ENTRY_ORG = "eorg";
    private static final String ENTRY_PERIOD = "eperiod";
    public static volatile Predicate<DynamicObject> isChangedPeriod = x -> {
        Iterable changedProperties = x.getDataEntityState().getBizChangedProperties();
        for (IDataEntityProperty ep : changedProperties) {
            if (!ep.getName().equals("period_id")) continue;
            return true;
        }
        return false;
    };

    private static boolean isMetaSupport() {
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.ACCOUNT_BOOK_VERSION, (Object[])new Object[]{VoucherEntryRedundantService.class.getName(), "isMetaSupport"});
        Boolean result = (Boolean)LocalCacheHelper.get((LocalCacheKey)cacheKey, Boolean.class);
        if (result == null) {
            DataEntityPropertyCollection voucherEntryProps = ((EntityType)EntityMetadataCache.getDataEntityType((String)"gl_voucher").getAllEntities().get("entries")).getProperties();
            result = voucherEntryProps.containsKey((Object)ENTRY_ORG) && voucherEntryProps.containsKey((Object)ENTRY_PERIOD);
            LocalCacheHelper.put((LocalCacheKey)cacheKey, (Object)result);
        }
        return result;
    }

    public static void updateVoucherRedundantInfoOnDynamicObj(DynamicObject[] dataEntities) {
        if (!VoucherEntryRedundantService.isMetaSupport()) {
            return;
        }
        if (null == dataEntities || dataEntities.length == 0) {
            return;
        }
        long tick = System.currentTimeMillis();
        for (DynamicObject entity : dataEntities) {
            if (!entity.getDynamicObjectType().getProperties().containsKey((Object)"entries")) continue;
            long orgId = entity.getLong("org.id");
            long periodId = entity.getLong("period.id");
            DynamicObjectCollection entries = entity.getDynamicObjectCollection("entries");
            if (entries.isEmpty()) continue;
            entries.stream().filter(x -> x.getDynamicObjectType().getProperties().containsKey((Object)ENTRY_ORG)).forEach(x -> x.set(ENTRY_ORG, (Object)orgId));
            entries.stream().filter(x -> x.getDynamicObjectType().getProperties().containsKey((Object)ENTRY_PERIOD)).forEach(x -> x.set(ENTRY_PERIOD, (Object)periodId));
        }
        LOG.info("updateVoucherRedundantInfo before cost:" + (System.currentTimeMillis() - tick));
    }

    public static Set<DynamicObject> filterPartlyLoadVouchers(List<DynamicObject> dataEntities) {
        if (CollectionUtils.isEmpty(dataEntities)) {
            return Collections.EMPTY_SET;
        }
        SqlBuilder sql = new SqlBuilder();
        List voucherIdList = dataEntities.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        sql.appendIn("select fid, count(1) as cnt from t_gl_voucherentry where fid ", voucherIdList);
        sql.append(" group by fid ", new Object[0]);
        try (ShardingHintContext ignored = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, voucherIdList)});){
            Set<DynamicObject> partLoadAndPeriodChangedVids;
            Map entrySizeMap = (Map)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql, rs -> {
                HashMap<Long, Integer> result = new HashMap<Long, Integer>(10);
                while (rs.next()) {
                    result.put(rs.getLong("fid"), rs.getInt("cnt"));
                }
                return result;
            });
            Set<DynamicObject> set = partLoadAndPeriodChangedVids = dataEntities.stream().filter(x -> {
                if (null == x.getDynamicObjectType().getPkSnapshot(x)) {
                    LOG.info("voucher_partly_load_with_period_change snapshot is null, skip.");
                    return false;
                }
                long vid = x.getLong("id");
                int dbEntrySize = (Integer)entrySizeMap.get(vid);
                int loadedEntrySize = VoucherEntryRedundantService.countLoadEntrySize(x, x.getDynamicObjectType());
                return loadedEntrySize < dbEntrySize;
            }).collect(Collectors.toSet());
            return set;
        }
    }

    private static int countLoadEntrySize(DynamicObject v, DynamicObjectType type) {
        List pkSnapshots = type.getPkSnapshot((Object)v).Snapshots;
        HashSet<Object> oids = new HashSet<Object>(1);
        for (PkSnapshot snapshot : pkSnapshots) {
            if (!snapshot.TableName.equalsIgnoreCase("t_gl_voucherentry") || snapshot.Oids == null) continue;
            oids.addAll(Arrays.asList(snapshot.Oids));
        }
        return oids.size();
    }

    public static void checkAndUpdateVoucherRedundantInfo(DynamicObject[] dataEntities) {
        if (!VoucherEntryRedundantService.isMetaSupport()) {
            return;
        }
        if (null == dataEntities || dataEntities.length == 0) {
            return;
        }
        long tick = System.currentTimeMillis();
        VoucherEntryRedundantService.batchUpdateEntry(Arrays.stream(dataEntities).map(x -> new VoucherUpdateParam(x.getLong("id"), x.getLong("org.id"), x.getLong("period.id"))).collect(Collectors.toList()));
        LOG.info("updateVoucherRedundantInfo afterTransaction size: " + dataEntities.length + ", cost:" + (System.currentTimeMillis() - tick));
    }

    private static void batchUpdateEntry(List<VoucherUpdateParam> params) {
        if (!CollectionUtils.isEmpty(params)) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"update t_gl_voucherentry set forgid = ? , fperiodid = ? where fid = ? ", params.stream().map(x -> x.build()).collect(Collectors.toList()));
            params.clear();
        }
    }

    private static boolean isCheckEntryConsistent(long voucherId, long orgId, long periodId) {
        return !QueryServiceHelper.exists((String)"gl_voucher", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)voucherId), new QFilter("entries.eorg.id", "!=", (Object)orgId).or(new QFilter("entries.eperiod.id", "!=", (Object)periodId))});
    }

    private static class VoucherUpdateParam {
        private long voucherId;
        private long orgId;
        private long periodId;

        public VoucherUpdateParam(long voucherId, long orgId, long periodId) {
            this.voucherId = voucherId;
            this.orgId = orgId;
            this.periodId = periodId;
        }

        public Object[] build() {
            return new Object[]{this.orgId, this.periodId, this.voucherId};
        }

        public long getVoucherId() {
            return this.voucherId;
        }
    }
}

