/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.dtxservice;

import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.ext.fi.ai.VoucherOperation;
import kd.bos.kdtx.common.exception.NoRetryException;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.EventualConsistencyService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.voucher.dtxservice.VoucherIdsParam;

public class DtxVoucherSubmitService
extends EventualConsistencyService {
    private static final Log LOG = LogFactory.getLog(DtxVoucherSubmitService.class);

    public DtxResponse execute(Object param, Object lastReturn) throws Exception {
        VoucherIdsParam voucherIdsParam = (VoucherIdsParam)param;
        long tick = System.currentTimeMillis();
        try (TXHandle x = TX.requiresNew();){
            try {
                LOG.info("BEGIN DtxVoucherSubmitService");
                DapVoucherUtil.dapWriteBack((VoucherOperation)VoucherOperation.Submit, voucherIdsParam.getVchID2BillNo());
            }
            catch (Throwable cause) {
                LOG.error(cause);
                x.markRollback();
                throw new NoRetryException("invoke DtxVoucherSubmitService fail", cause);
            }
        }
        if (DebugTrace.enable()) {
            LOG.info("DtxVoucherSubmitService cost: {}", (Object)(System.currentTimeMillis() - tick));
        }
        return null;
    }
}

