/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.opplugin;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.gl.notice.NoticeAction;
import kd.fi.gl.notice.NoticeMessenger;
import kd.fi.gl.util.IctRecordUtil;
import kd.fi.gl.voucher.count.VoucherCountHelper;
import kd.fi.gl.voucher.util.BalanceUpdateUtil;
import kd.fi.gl.voucher.validate.CashFlowItemValidator;

public class CashFlowItemSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new CashFlowItemValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        BalanceUpdateUtil.setDeductLog(e.getDataEntities(), "submit");
        VoucherCountHelper.createChangeLog((DynamicObject[])e.getDataEntities(), (String)"cfsave", (boolean)true);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        BalanceUpdateUtil.setAddLog(e.getDataEntities(), "submit");
        BalanceUpdateUtil.storeLog("submit");
        VoucherCountHelper.createChangeLog((DynamicObject[])e.getDataEntities(), (String)"cfsave", (boolean)false);
        ArrayList<String> ictVoucherIds = new ArrayList<String>(e.getDataEntities().length);
        for (DynamicObject vch : e.getDataEntities()) {
            ictVoucherIds.add(String.valueOf(vch.getLong("id")));
        }
        IctRecordUtil.asyncIctRecordCfValue(ictVoucherIds);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        BalanceUpdateUtil.updateBalance();
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> voucherIdSet = new HashSet<Long>(dataEntities.length);
        for (DynamicObject vch : dataEntities) {
            voucherIdSet.add(vch.getLong("id"));
        }
        NoticeMessenger.delivery((Long[])voucherIdSet.toArray(new Long[0]), (NoticeAction)NoticeAction.SEND_CF);
    }
}

