/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.opplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.voucher.VoucherNumberUtils;

public class VchTempNumberService {
    private static final Log LOG = LogFactory.getLog(VchTempNumberService.class);

    public void setTempNumber(List<DynamicObject> vchDyns) {
        Map<Long, List<DynamicObject>> tempVchDynListGroupByOrgId = this.groupByOrgId(vchDyns);
        for (Map.Entry<Long, List<DynamicObject>> entry : tempVchDynListGroupByOrgId.entrySet()) {
            Long orgId = entry.getKey();
            List<DynamicObject> vchDynList = entry.getValue();
            this.setTempNumberWithOrgId(orgId, vchDynList);
        }
    }

    private Map<Long, List<DynamicObject>> groupByOrgId(List<DynamicObject> tempVchDynList) {
        return tempVchDynList.stream().collect(Collectors.groupingBy(x -> x.getLong("org.id")));
    }

    private void setTempNumberWithOrgId(Long orgId, List<DynamicObject> vchDynList) {
        CodeRuleInfo codeRuleInfo = VoucherNumberUtils.getCodeRuleInfo((Long)orgId, (String)"A");
        if (codeRuleInfo != null) {
            Map<JSONObject, List<DynamicObject>> vchDynListGroupByBasis = vchDynList.stream().collect(Collectors.groupingBy(voucherDyn -> {
                Set enhancedSortItems = VoucherNumberUtils.getEnhancedSortItems((CodeRuleInfo)codeRuleInfo);
                return VoucherNumberUtils.getGroupByInfos((DynamicObject)voucherDyn, (Set)enhancedSortItems);
            }));
            for (Map.Entry<JSONObject, List<DynamicObject>> entry : vchDynListGroupByBasis.entrySet()) {
                if (DebugTrace.enable()) {
                    LOG.info("vchsavesetnum_basis_" + entry.getKey());
                }
                this.batchSetNumber(orgId, entry.getKey(), entry.getValue());
            }
        }
    }

    private void batchSetNumber(Long orgId, JSONObject groupByKey, List<DynamicObject> vchDynList) {
        ArrayList<DynamicObject> setNumVchDynList = new ArrayList<DynamicObject>(vchDynList);
        if (setNumVchDynList.isEmpty()) {
            return;
        }
        DynamicObject vchDyn = (DynamicObject)setNumVchDynList.get(0);
        vchDyn.set("billno", (Object)"");
        vchDyn.set("billstatus", (Object)"A");
        Object[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)"gl_voucher", (DynamicObject)vchDyn, (String)orgId.toString(), (int)setNumVchDynList.size());
        if (batchNumber[0].length() > 30) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7\u957f\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc730\u4f4d\uff0c\u8bf7\u68c0\u67e5\u7f16\u7801\u89c4\u5219\u914d\u7f6e\u3002", (String)"VoucherSaveValidator_2", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        if (DebugTrace.enable()) {
            LOG.info("vchsavesetnum_nums_" + Arrays.toString(batchNumber));
        }
        int numSize = Math.min(batchNumber.length, setNumVchDynList.size());
        for (int i = 0; i < numSize; ++i) {
            ((DynamicObject)setNumVchDynList.get(i)).set("billno", batchNumber[i]);
        }
    }
}

