/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.bd.util.MultiLangPunc;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.IctRecordUtil;
import kd.fi.gl.util.TipsUtils;
import kd.fi.gl.voucher.count.VoucherCountHelper;
import kd.fi.gl.voucher.opplugin.AbstractVoucherServicePlugIn;
import kd.fi.gl.voucher.validate.VoucherAntiAuditValidator;

public class VoucherAntiAuditOp
extends AbstractVoucherServicePlugIn {
    private static final String SYNDEL = "syndel";
    private static final Log logger = LogFactory.getLog(VoucherAntiAuditOp.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("ischeck");
        keys.add("auditor");
        keys.add("auditdate");
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new VoucherAntiAuditValidator());
    }

    @Override
    protected String getVoucherAction() {
        return "antiaudit";
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        HashMap<Long, String> id2billNo = new HashMap<Long, String>(entities.length);
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>(16);
        ArrayList<Long> ids = new ArrayList<Long>(entities.length);
        for (DynamicObject entity : entities) {
            Long id = entity.getLong("id");
            Long orgId = entity.getLong("org.id");
            if (!map.containsKey(orgId)) {
                Object obj = GLUtil.getSystemParam((String)SYNDEL, (Long)orgId);
                map.put(orgId, obj != null && (Boolean)obj != false);
            }
            if (((Boolean)map.get(orgId)).booleanValue()) {
                ids.add(id);
            }
            id2billNo.put(entity.getLong("id"), entity.getString("billno"));
        }
        if (!ids.isEmpty()) {
            DynamicObjectCollection dyns = QueryServiceHelper.query((String)"gl_voucher_relation", (String)"destvoucherid, srcvoucherid", (QFilter[])new QFilter("srcvoucherid", "in", ids).toArray());
            HashMap src2destMap = new HashMap();
            dyns.forEach(synVchDyn -> src2destMap.put(synVchDyn.getLong("destvoucherid"), synVchDyn.getLong("srcvoucherid")));
            if (!src2destMap.isEmpty()) {
                OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"gl_voucher", (Object[])src2destMap.keySet().toArray(new Long[0]), (OperateOption)OperateOption.create());
                DeleteServiceHelper.delete((String)"gl_voucher_relation", (QFilter[])new QFilter("destvoucherid", "in", (Object)result.getSuccessPkIds()).toArray());
                HashSet failedSrcVchSet = new HashSet();
                result.getAllErrorOrValidateInfo().stream().map(operateInfo -> {
                    Long errorPK = (Long)src2destMap.get(operateInfo.getPkValue());
                    String errorBillNo = (String)id2billNo.get(errorPK);
                    OperateErrorInfo synDelError = new OperateErrorInfo("ERROR_VCH_SYN_DEL", ErrorLevel.Error, (Object)errorPK);
                    synDelError.setPkValue((Object)errorPK);
                    String failedMsg = ResManager.loadKDString((String)"%1$s\uff1a\u540c\u6b65\u5220\u9664\u534f\u540c\u51ed\u8bc1\u5931\u8d25\uff0c%2$s", (String)"VoucherAntiAuditOp_0", (String)"fi-gl-opplugin", (Object[])new Object[]{errorBillNo, operateInfo.getMessage()});
                    synDelError.setMessage(TipsUtils.safeSuffix((String)failedMsg, (String)MultiLangPunc.fullStop()));
                    return synDelError;
                }).forEach(error -> {
                    this.getOperationResult().addErrorInfo(error);
                    failedSrcVchSet.add((Long)error.getPkValue());
                });
                if (!failedSrcVchSet.isEmpty()) {
                    e.setDataEntities((DynamicObject[])Arrays.stream(e.getDataEntities()).filter(srcVchEntity -> !failedSrcVchSet.contains(srcVchEntity.getPkValue())).toArray(DynamicObject[]::new));
                }
            }
        }
        VoucherCountHelper.createChangeLog((DynamicObject[])e.getDataEntities(), (String)this.getVoucherAction(), (boolean)true);
    }

    @Override
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        IctRecordUtil.asyncIctRecordHandle((DynamicObject[])e.getDataEntities());
    }
}

