/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.opplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.gl.enums.synbook.TriggerTiming;
import kd.fi.gl.synbook.VoucherRealTimeSynchronizer;
import kd.fi.gl.voucher.opplugin.AbstractVoucherServicePlugIn;
import kd.fi.gl.voucher.opplugin.VoucherMarkErrorUtil;
import kd.fi.gl.voucher.validate.VoucherAuditCheckErrorValidator;
import kd.fi.gl.voucher.validate.VoucherAuditValidator;

public class VoucherAuditOp
extends AbstractVoucherServicePlugIn {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("errorstatus");
        fieldKeys.add("errormsg");
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new VoucherAuditValidator());
        e.getValidators().add(new VoucherAuditCheckErrorValidator());
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] voucherDyns = e.getDataEntities();
        VoucherMarkErrorUtil.removeError(voucherDyns);
    }

    @Override
    protected String getVoucherAction() {
        return "audit";
    }

    @Override
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        VoucherRealTimeSynchronizer.doSynchronize((DynamicObject[])e.getDataEntities(), (TriggerTiming)TriggerTiming.AUDIT);
    }

    private boolean getVoucherRule(Long orgId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(new QFilter("exeway", "=", (Object)"ontime"));
        filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        filters.add(new QFilter("strikeopre", "=", (Object)"audit"));
        filters.add(BaseDataServiceHelper.getBaseDataFilter((String)"gl_voucher_rulecondition", (Long)orgId));
        return QueryServiceHelper.exists((String)"gl_voucher_rulecondition", (QFilter[])filters.toArray(new QFilter[0]));
    }
}

