/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.opplugin;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.SystemParamHelper;
import kd.fi.gl.voucher.opplugin.AbstractVoucherCfAdjustPlugIn;

public class VoucherCancelAdjustOp
extends AbstractVoucherCfAdjustPlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] entities = this.getDataEntities();
                HashSet<Long> vchSet = new HashSet<Long>(entities.length);
                for (ExtendedDataEntity entity : entities) {
                    vchSet.add(entity.getDataEntity().getLong("id"));
                }
                Long orgId = entities[0].getDataEntity().getLong("org_id");
                boolean mdifyhiscfitem = SystemParamHelper.getBooleanParam((String)"mdifyhiscfitem", (long)orgId, (boolean)false);
                HashMap<Long, DynamicObject> vchDyns = new HashMap<Long, DynamicObject>(vchSet.size());
                DynamicObjectCollection vouchers = QueryServiceHelper.query((String)"gl_voucher", (String)"id,org,booktype,period,billstatus", (QFilter[])new QFilter("id", "in", vchSet).toArray());
                for (DynamicObject vch : vouchers) {
                    vchDyns.put(vch.getLong("id"), vch);
                }
                Set<Long> archivedVocuher = VoucherCancelAdjustOp.this.getArchivedVocuher(vchSet);
                HashMap<Long, Boolean> closePeriods = new HashMap<Long, Boolean>(entities.length);
                for (ExtendedDataEntity entity : entities) {
                    Long vchId = entity.getDataEntity().getLong("id");
                    DynamicObject vchDyn = (DynamicObject)vchDyns.get(vchId);
                    if (archivedVocuher.contains(vchId)) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u51ed\u8bc1\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u53d6\u6d88\u8c03\u6574\u3002", (String)"VoucherCancelAdjustOp_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (!mdifyhiscfitem) {
                        Boolean isClosePeriod = (Boolean)closePeriods.get(vchDyn.getLong("period"));
                        if (isClosePeriod == null) {
                            isClosePeriod = GLUtil.isClosePeriod((long)orgId, (long)vchDyn.getLong("booktype"), (long)vchDyn.getLong("period"));
                            closePeriods.put(vchDyn.getLong("period"), isClosePeriod);
                        }
                        if (isClosePeriod.booleanValue()) {
                            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5df2\u7ed3\u8d26\uff0c\u5982\u9700\u4fee\u6539\u73b0\u91d1\u6d41\u91cf\uff0c\u8bf7\u6253\u5f00\u201c\u4fee\u6539\u7ed3\u8d26\u671f\u95f4\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u3002", (String)"VoucherCancelAdjustOp_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                    }
                    if (GLUtil.isCurrentVoucherAllowModifyCF((long)orgId, (long)vchDyn.getLong("booktype"), (long)vchDyn.getLong("period"), (String)vchDyn.getString("billstatus"))) continue;
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u201c\u4fee\u6539\u5df2\u5ba1\u6838\u51ed\u8bc1\u73b0\u91d1\u6d41\u91cf\u201d\u53c2\u6570\u5df2\u5173\u95ed\uff0c\u5df2\u5ba1\u6838\u51ed\u8bc1\u548c\u5df2\u8fc7\u8d26\u51ed\u8bc1\u4e0d\u5141\u8bb8\u4fee\u6539\u8865\u5145\u8d44\u6599\u3002", (String)"VoucherCfAdjustOp_4", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    @Override
    protected void setCf(DynamicObject[] vouchers) {
        for (DynamicObject voucher : vouchers) {
            DynamicObjectCollection entries = voucher.getDynamicObjectCollection("entries");
            for (DynamicObject entry : entries) {
                entry.set("suppcfitem", null);
                entry.set("suppcfamount", (Object)BigDecimal.ZERO);
            }
            voucher.set("suppstatus", (Object)"a");
        }
    }

    @Override
    protected String getFailMessage() {
        return ResManager.loadKDString((String)"\u201c\u8865\u5145\u8d44\u6599\u8c03\u6574\u201d\u53d6\u6d88\u8c03\u6574\u5931\u8d25\u3002", (String)"VoucherCancelAdjustOp_2", (String)"fi-gl-opplugin", (Object[])new Object[0]);
    }
}

