/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.coderule.util.CodeRuleSerialNumUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.voucher.VoucherNumberUtils;

public class VoucherNumSynOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(VoucherNumSynOp.class);
    private Map<String, Object[]> synDynMap = new IdentityHashMap<String, Object[]>(16);
    private static final DynamicObjectType logType = EntityMetadataCache.getDataEntityType((String)"gl_syncnumvoucher_log");

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                DynamicObject[] srcVchCollection;
                long selectDestBookId = Long.parseLong(this.getOption().getVariableValue("Option_DestBookId", "0"));
                ArrayList<Long> srcVoucherIdList = new ArrayList<Long>(this.dataEntities.length);
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    Long srcVoucherId = (Long)this.dataEntities[i].getDataEntity().getPkValue();
                    srcVoucherIdList.add(srcVoucherId);
                }
                DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"gl_voucher_relation", (String)"srcvoucherid,destvoucherid", (QFilter[])new QFilter[]{new QFilter("srcvoucherid", "in", srcVoucherIdList).and("destbook", "=", (Object)selectDestBookId)});
                ArrayList<DynamicObject[]> destVoucherIdList = new ArrayList<DynamicObject[]>(dynamicObjectCollection.size());
                HashMap<DynamicObject[], Long> voucherRelationMap = new HashMap<DynamicObject[], Long>(srcVoucherIdList.size());
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    Long srcVchId = dynamicObject.getLong("srcvoucherid");
                    DynamicObject[] destVchId = Long.valueOf(dynamicObject.getLong("destvoucherid"));
                    destVoucherIdList.add(destVchId);
                    voucherRelationMap.put(destVchId, srcVchId);
                }
                HashMap<Long, DynamicObject[]> srcVchDynMap = new HashMap<Long, DynamicObject[]>(srcVoucherIdList.size());
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"gl_voucher");
                for (DynamicObject dyn : srcVchCollection = BusinessDataServiceHelper.load((Object[])srcVoucherIdList.toArray(), (DynamicObjectType)dataEntityType)) {
                    srcVchDynMap.put(dyn.getLong("id"), new DynamicObject[]{dyn, null});
                }
                DynamicObject[] destVchCollection = BusinessDataServiceHelper.load((Object[])destVoucherIdList.toArray(), (DynamicObjectType)dataEntityType);
                Long destBookTypeId = null;
                for (DynamicObject dyn : destVchCollection) {
                    Long destVchId;
                    Long srcVchId;
                    if (destBookTypeId == null) {
                        destBookTypeId = dyn.getLong("booktype.id");
                    }
                    if ((srcVchId = (Long)voucherRelationMap.get(destVchId = Long.valueOf(dyn.getLong("id")))) == null) continue;
                    DynamicObject[] dynamicObjects = (DynamicObject[])srcVchDynMap.get(srcVchId);
                    dynamicObjects[1] = dyn;
                }
                Long orgId = this.dataEntities[0].getDataEntity().getLong("org.id");
                CodeRuleInfo codeRuleInfo = VoucherNumberUtils.getCodeRuleInfo((Long)orgId, (String)"B");
                boolean hasOtherRule = false;
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    Long srcVoucherId = (Long)this.dataEntities[i].getDataEntity().getPkValue();
                    DynamicObject[] dynamicObjects = (DynamicObject[])srcVchDynMap.get(srcVoucherId);
                    DynamicObject srcVoucher = dynamicObjects[0];
                    DynamicObject destVoucher = dynamicObjects[1];
                    String srcVoucherNumber = srcVoucher.getString("billno");
                    if (destVoucher == null) {
                        this.addMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7%s\uff0c\u6ca1\u6709\u534f\u540c\u8fc7\u51ed\u8bc1\uff0c\u65e0\u9700\u540c\u6b65\u3002", (String)"VoucherNumSynOp_1", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), srcVoucherNumber));
                        continue;
                    }
                    String destVoucherNumber = destVoucher.getString("billno");
                    if ("A".equals(destVoucher.getString("billstatus"))) {
                        this.addMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7%s\uff0c\u4e3a\u6682\u5b58\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u540c\u6b65\u3002", (String)"VoucherNumSynOp_2", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), destVoucherNumber));
                        continue;
                    }
                    if (srcVoucherNumber.equals(destVoucherNumber)) {
                        this.addMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7%s\uff0c\u4e0e\u4e3b\u8d26\u7c3f\u51ed\u8bc1\u53f7\u76f8\u540c\uff0c\u65e0\u9700\u540c\u6b65\u3002", (String)"VoucherNumSynOp_3", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), destVoucherNumber));
                        continue;
                    }
                    int[] srcVchNumIndexs = VoucherNumSynOp.this.getVchNumIndexByCodeRule(srcVoucher, codeRuleInfo);
                    int[] destVchNumIndexs = VoucherNumSynOp.this.getVchNumIndexByCodeRule(destVoucher, codeRuleInfo);
                    String srcVchNum = srcVoucher.getString("billno");
                    String destVchNum = destVoucher.getString("billno");
                    if (srcVchNum.length() < srcVchNumIndexs[0] + srcVchNumIndexs[1]) {
                        this.addMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7%s\uff0c\u7f16\u7801\u89c4\u5219\u5df2\u6539\u53d8\uff0c\u8bf7\u5148\u8c03\u6574\u51ed\u8bc1\u53f7\u3002", (String)"VoucherNumSynOp_5", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), srcVchNum));
                        continue;
                    }
                    if (destVchNum.length() < destVchNumIndexs[0] + destVchNumIndexs[1]) {
                        this.addMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7%s\uff0c\u7f16\u7801\u89c4\u5219\u5df2\u6539\u53d8\uff0c\u8bf7\u5148\u8c03\u6574\u51ed\u8bc1\u53f7\u3002", (String)"VoucherNumSynOp_5", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), srcVchNum));
                        continue;
                    }
                    String synVchNum = VoucherNumSynOp.this.getVchNumByCodeRule(srcVchNum, destVchNum, srcVchNumIndexs, destVchNumIndexs);
                    if (synVchNum.equals(destVchNum)) {
                        this.addMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7%s\uff0c\u6d41\u6c34\u53f7\u5df2\u534f\u540c\u4e00\u81f4\u65e0\u9700\u8c03\u6574\u3002", (String)"VoucherNumSynOp_6", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), srcVchNum));
                        continue;
                    }
                    Map otherRule = VoucherNumSynOp.this.getOtherRule(destVoucher, codeRuleInfo);
                    if (!CollectionUtils.isEmpty((Map)otherRule)) {
                        hasOtherRule = true;
                        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(otherRule.size() + 3);
                        for (Map.Entry entry : otherRule.entrySet()) {
                            qFilters.add(new QFilter((String)entry.getKey(), "=", entry.getValue()));
                        }
                        qFilters.add(new QFilter("billno", "=", (Object)synVchNum));
                        qFilters.add(new QFilter("org", "=", (Object)orgId));
                        qFilters.add(new QFilter("booktype", "=", (Object)destBookTypeId));
                        qFilters.add(new QFilter("sourcetype", "!=", (Object)"a"));
                        DynamicObject dyn = QueryServiceHelper.queryOne((String)"gl_voucher", (String)"billno", (QFilter[])qFilters.toArray(new QFilter[0]));
                        if (dyn != null) {
                            this.addMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7%s\uff0c\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u5148\u4eba\u5de5\u8c03\u6574\u8be5\u51ed\u8bc1\u53f7\u3002", (String)"VoucherNumSynOp_4", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), synVchNum));
                            continue;
                        }
                    }
                    if (DebugTrace.enable()) {
                        logger.info("validate hasOtherRule : " + hasOtherRule + ", synDynMap add : synVchNum = " + synVchNum + ", srcVoucher: " + srcVoucher.getLong("id") + ", destVoucher: " + destVoucher.getLong("id"));
                    }
                    VoucherNumSynOp.this.synDynMap.put(synVchNum, new Object[]{srcVoucher, destVoucher, i});
                }
                if (!hasOtherRule) {
                    DynamicObjectCollection srcVchNumCollection = QueryServiceHelper.query((String)"gl_voucher", (String)"billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", VoucherNumSynOp.this.synDynMap.keySet()).and("org", "=", (Object)orgId).and("booktype", "=", (Object)destBookTypeId).and("sourcetype", "!=", (Object)"a")});
                    for (DynamicObject dyn : srcVchNumCollection) {
                        String vchNum = dyn.getString("billno");
                        if (!VoucherNumSynOp.this.synDynMap.containsKey(vchNum)) continue;
                        Object[] objects = (Object[])VoucherNumSynOp.this.synDynMap.remove(vchNum);
                        this.addMessage(this.dataEntities[(Integer)objects[2]], String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7%s\uff0c\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u5148\u4eba\u5de5\u8c03\u6574\u8be5\u51ed\u8bc1\u53f7\u3002", (String)"VoucherNumSynOp_4", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), vchNum));
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String updateSql = "update t_gl_voucher set fnumber = ? where fid = ? ";
        ArrayList<Object[]> batchParams = new ArrayList<Object[]>(1024);
        ArrayList<DynamicObject> lstSaveDatas = new ArrayList<DynamicObject>(this.synDynMap.size());
        for (Map.Entry<String, Object[]> entry : this.synDynMap.entrySet()) {
            String synVchNum = entry.getKey();
            Object[] dynamicObjects = entry.getValue();
            DynamicObject srcVoucher = (DynamicObject)dynamicObjects[0];
            DynamicObject destVoucher = (DynamicObject)dynamicObjects[1];
            String destVoucherNumber = destVoucher.getString("billno");
            batchParams.add(new Object[]{synVchNum, destVoucher.getLong("id")});
            if (DebugTrace.enable()) {
                logger.info("VoucherNumSynOp batchParams add : [" + synVchNum + "," + destVoucher.getLong("id") + "]");
            }
            DynamicObject saveObj = (DynamicObject)logType.createInstance();
            saveObj.set("org", (Object)destVoucher.getLong("org.id"));
            saveObj.set("booktype", (Object)destVoucher.getLong("booktype.id"));
            saveObj.set("period", (Object)destVoucher.getLong("period.id"));
            saveObj.set("vouchertype", (Object)destVoucher.getLong("vouchertype.id"));
            saveObj.set("bizdate", (Object)destVoucher.getDate("bizdate"));
            saveObj.set("bookeddate", (Object)destVoucher.getDate("bookeddate"));
            saveObj.set("srcvouchernum", (Object)destVoucherNumber);
            saveObj.set("destvouchernum", (Object)synVchNum);
            saveObj.set("adjustdate", (Object)new Date());
            saveObj.set("adjuster", (Object)ContextUtil.getUserId());
            saveObj.set("mainvouchernum", (Object)srcVoucher.getString("billno"));
            lstSaveDatas.add(saveObj);
            if (batchParams.size() <= 1000) continue;
            this.batchUpdateVch(updateSql, batchParams);
            batchParams.clear();
            SaveServiceHelper.save((IDataEntityType)logType, (Object[])lstSaveDatas.toArray(new DynamicObject[0]));
            lstSaveDatas.clear();
        }
        if (batchParams.size() > 0) {
            this.batchUpdateVch(updateSql, batchParams);
            SaveServiceHelper.save((IDataEntityType)logType, (Object[])lstSaveDatas.toArray(new DynamicObject[0]));
        }
    }

    public void batchUpdateVch(String updateSql, List<Object[]> batchParams) {
        DB.executeBatch((DBRoute)new DBRoute("fi"), (String)updateSql, batchParams);
    }

    private String getVchNumByCodeRule(String srcVchNum, String destVchNum, int[] srcVchNumIndexs, int[] destVchNumIndexs) {
        int srcBeginIndex = srcVchNum.length() - (srcVchNumIndexs[0] + srcVchNumIndexs[1]);
        int destBeginIndex = destVchNum.length() - (destVchNumIndexs[0] + destVchNumIndexs[1]);
        String srcSeq = srcVchNum.substring(srcBeginIndex, srcBeginIndex + srcVchNumIndexs[1]);
        String destSeq = destVchNum.substring(destBeginIndex, destBeginIndex + destVchNumIndexs[1]);
        return this.replaceLast(destVchNum, destSeq, srcSeq);
    }

    private int[] getVchNumIndexByCodeRule(DynamicObject vchDyn, CodeRuleInfo codeRuleInfo) {
        int[] indexs = new int[2];
        Iterator codeRule = codeRuleInfo.getRuleEntry().iterator();
        StringBuilder number = new StringBuilder();
        String entryValue = "";
        boolean isFirst = true;
        while (codeRule.hasNext()) {
            CodeRuleEntryInfo codeRuleEntry = (CodeRuleEntryInfo)codeRule.next();
            boolean isVisable = codeRuleEntry.getVisable();
            if (isFirst) {
                isFirst = false;
            } else if (StringUtils.isNotBlank((CharSequence)codeRuleEntry.getSplitSign()) && isVisable) {
                number.append(codeRuleEntry.getSplitSign());
            }
            CodeRuleEntryTypeEnum enums = CodeRuleEntryTypeEnum.getEnums((String)codeRuleEntry.getAttributeType());
            switch (enums) {
                case TYPE_FIX_TEXT: {
                    entryValue = codeRuleEntry.getFormat();
                    break;
                }
                case TYPE_SYSTEM_TIME_FIELD: {
                    entryValue = CodeRuleSerialNumUtil.getSystemDateEntry((CodeRuleEntryInfo)codeRuleEntry);
                    break;
                }
                case TYPE_DATE_FIELD: {
                    entryValue = CodeRuleSerialNumUtil.getDateEntry((CodeRuleEntryInfo)codeRuleEntry, (DynamicObject)vchDyn);
                    break;
                }
                case TYPE_ITEM_FIELD: {
                    entryValue = CodeRuleSerialNumUtil.getItemEntry((CodeRuleEntryInfo)codeRuleEntry, (DynamicObject)vchDyn);
                    break;
                }
                case TYPE_SEQ: {
                    entryValue = "";
                    indexs[1] = codeRuleEntry.getLength();
                    break;
                }
                case TYPE_RANDOM_NUMBER: {
                    entryValue = "";
                    indexs[1] = 8;
                    break;
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)(entryValue = CodeRuleSerialNumUtil.formatString((CodeRuleEntryInfo)codeRuleEntry, (String)entryValue))) || !isVisable) continue;
            number.append(entryValue);
        }
        indexs[0] = entryValue.length();
        return indexs;
    }

    private Map<String, Object> getOtherRule(DynamicObject vchDyn, CodeRuleInfo codeRuleInfo) {
        Iterator codeRule = codeRuleInfo.getRuleEntry().iterator();
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        while (codeRule.hasNext()) {
            String entryValue = "";
            CodeRuleEntryInfo codeRuleEntry = (CodeRuleEntryInfo)codeRule.next();
            boolean isVisable = codeRuleEntry.getVisable();
            if (isVisable) continue;
            CodeRuleEntryTypeEnum enums = CodeRuleEntryTypeEnum.getEnums((String)codeRuleEntry.getAttributeType());
            switch (enums) {
                case TYPE_DATE_FIELD: {
                    entryValue = CodeRuleSerialNumUtil.getDateEntry((CodeRuleEntryInfo)codeRuleEntry, (DynamicObject)vchDyn);
                    if (!StringUtils.isNotEmpty((CharSequence)entryValue) || vchDyn.get(codeRuleEntry.getValueAtribute()) == null) break;
                    map.put(codeRuleEntry.getValueAtribute(), vchDyn.get(codeRuleEntry.getValueAtribute()));
                    break;
                }
                case TYPE_ITEM_FIELD: {
                    entryValue = CodeRuleSerialNumUtil.getItemEntry((CodeRuleEntryInfo)codeRuleEntry, (DynamicObject)vchDyn);
                    if (!StringUtils.isNotEmpty((CharSequence)entryValue)) break;
                    if (CodeRuleSerialNumUtil.getAttributeObject((DynamicObject)vchDyn, (String)codeRuleEntry.getValueAtribute()) instanceof Date) {
                        map.put(codeRuleEntry.getValueAtribute(), vchDyn.get(codeRuleEntry.getValueAtribute()));
                        break;
                    }
                    map.put(codeRuleEntry.getValueAtribute(), entryValue);
                }
            }
        }
        return map;
    }

    private String replaceLast(String text, String strToReplace, String replaceWithThis) {
        return text.replaceFirst("(?s)" + strToReplace + "(?!.*?" + strToReplace + ")", replaceWithThis);
    }
}

