/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.opplugin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.lock.IShareLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.indexing.constant.CDCRecOperationTypeEnum;
import kd.fi.bd.indexing.integrator.CDCServiceGLIntegrator;
import kd.fi.bd.service.voucher.TempVoucherCFService;
import kd.fi.bd.util.CashflowLocalSetUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.util.CashFlowItemHelper;
import kd.fi.gl.util.ImrVoucherUtil;
import kd.fi.gl.voucher.VoucherEntryRedundantService;
import kd.fi.gl.voucher.count.VoucherCountHelper;
import kd.fi.gl.voucher.dtxservice.VoucherPresetParm;
import kd.fi.gl.voucher.opplugin.AbstractVoucherServicePlugIn;
import kd.fi.gl.voucher.opplugin.VoucherMarkErrorUtil;
import kd.fi.gl.voucher.opplugin.VoucherStatusConvertConfig;
import kd.fi.gl.voucher.preset.CashFlowPresetService;
import kd.fi.gl.voucher.util.VoucherFieldKeyListProxy;
import kd.fi.gl.voucher.util.VoucherUtils;
import kd.fi.gl.voucher.validate.VoucherSaveNumberValidator;
import kd.fi.gl.voucher.validate.VoucherSaveValidator;

public class VoucherSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log LOG = LogFactory.getLog(VoucherSaveOp.class);
    private static final String CLOUD_ID = "fi";
    private static final String APP_ID = "gl";
    private static final List<String> ALL_PREPARE_PROPERTYS = ImmutableList.of((Object)"createtime", (Object)"bizdate", (Object)"sourcetype", (Object)"bookeddate", (Object)"period", (Object)"creator", (Object)"submitter", (Object)"auditor", (Object)"cashier", (Object)"poster", (Object)"book", (Object)"booktype", (Object[])new String[]{"localcur", "creditlocamount", "debitlocamount", "errorstatus", "errormsg", "isreverse", "ischeck", "mainstatus", "suppstatus", "vdescription", "againsttype"});
    private Map<String, IShareLock> locks = new HashMap<String, IShareLock>(1);
    private Map<Long, String> idAndNo = new HashMap<Long, String>(100);

    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        for (Map.Entry<String, IShareLock> lock : this.locks.entrySet()) {
            lock.getValue().release();
        }
        List successIds = e.getOperationResult().getSuccessPkIds();
        HashSet<Object> failedVids = new HashSet<Object>(this.idAndNo.keySet());
        failedVids.removeAll(successIds);
        if (!failedVids.isEmpty()) {
            this.reyVoucherBillNo(failedVids, this.idAndNo);
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(ALL_PREPARE_PROPERTYS);
        e.setFieldKeys(VoucherFieldKeyListProxy.getProxyInstance(e.getFieldKeys(), this.billEntityType));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        String voucherStatus = VoucherStatusConvertConfig.getStatus("save");
        boolean checkStatus = StringUtils.isNotBlank((CharSequence)voucherStatus);
        for (DynamicObject voucherDynObj : dataEntities = e.getDataEntities()) {
            voucherDynObj.set("auditor", null);
            voucherDynObj.set("poster", null);
            voucherDynObj.set("cashier", null);
            VoucherUtils.fillUser((DynamicObject)voucherDynObj, (OperateOption)this.operateOption);
            if (!checkStatus || voucherStatus.equals(voucherDynObj.getString("billstatus"))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u8f6c\u6362\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"VoucherSaveOp_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        }
        VoucherEntryRedundantService.updateVoucherRedundantInfoOnDynamicObj(dataEntities);
        if (!this.getOption().containsVariable("isFirstOperation")) {
            VoucherCountHelper.createChangeLog((DynamicObject[])e.getDataEntities(), (String)"save", (boolean)true);
        }
        for (DynamicObject vchDyn : dataEntities) {
            VoucherMarkErrorUtil.removeError(vchDyn);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        CDCServiceGLIntegrator.getInstance().registerCDCChangedRecord(CDCRecOperationTypeEnum.New, dataEntities);
        AbstractVoucherServicePlugIn.updateTempVoucherIndex(dataEntities);
        Set<DynamicObject> partlyLoadVouchers = VoucherEntryRedundantService.filterPartlyLoadVouchers(Arrays.asList(e.getDataEntities()));
        List<DynamicObject> partLoadAndPeriodVouchers = partlyLoadVouchers.stream().filter(VoucherEntryRedundantService.isChangedPeriod).collect(Collectors.toList());
        if (!partLoadAndPeriodVouchers.isEmpty()) {
            LOG.info("voucher_partly_load_with_period_change id: {}, reinit entry period field.", partLoadAndPeriodVouchers.stream().map(x -> x.getLong("id")).collect(Collectors.toList()));
            VoucherEntryRedundantService.checkAndUpdateVoucherRedundantInfo(partLoadAndPeriodVouchers.toArray(new DynamicObject[0]));
        }
        ImrVoucherUtil.insertIsomerismRelation((OperateOption)this.getOption(), (DynamicObject[])e.getDataEntities());
        ArrayList<DynamicObject> presetList = new ArrayList<DynamicObject>(dataEntities.length);
        ArrayList<DynamicObject> otherList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject v : e.getDataEntities()) {
            if ("1".equals(v.getString("sourcetype"))) continue;
            String mainstatus = v.getString("mainstatus");
            String suppstatus = v.getString("suppstatus");
            if (("1".equals(mainstatus) || "1".equals(suppstatus)) && !CashflowLocalSetUtil.isLocalSetThread((long)v.getLong("org_id"), (Date)v.getDate("bookeddate")) && CashFlowItemHelper.permitDesignCashflowByPeriod((long)v.getDynamicObject("book").getLong(GLField.id_((String)"cashinitperiod")), (long)v.getLong(GLField.id_((String)"period")))) {
                presetList.add(v);
                continue;
            }
            otherList.add(v);
        }
        Lists.partition(otherList, (int)1000).forEach(vouchers -> {
            VoucherPresetParm vpucherPresetParam = this.getPresetParam((List<DynamicObject>)vouchers, partLoadAndPeriodVouchers);
            TempVoucherCFService.updateOrInsert(vpucherPresetParam.getVoucherIds(), vpucherPresetParam.getvId2orgId(), vpucherPresetParam.getVoucher2Cashflow());
        });
        if (CollectionUtils.isNotEmpty(presetList)) {
            Lists.partition(presetList, (int)1000).forEach(vouchers -> {
                VoucherPresetParm vpucherPresetParam = this.getPresetParam((List<DynamicObject>)vouchers, partLoadAndPeriodVouchers);
                if (DebugTrace.enable()) {
                    LOG.info("begin to execute DtxVoucherSavePresetService on {}", (Object)vpucherPresetParam);
                }
                CashFlowPresetService.batchPreset(vpucherPresetParam);
            });
        }
        VoucherCountHelper.createChangeLog((DynamicObject[])e.getDataEntities(), (String)"save", (boolean)false);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new VoucherSaveNumberValidator());
        e.addValidator((AbstractValidator)new VoucherSaveValidator(this.locks, this.idAndNo));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        CDCServiceGLIntegrator.getInstance().raiseCDCEvent(CDCRecOperationTypeEnum.New, e.getDataEntities());
    }

    private VoucherPresetParm getPresetParam(List<DynamicObject> entities, List<DynamicObject> partLoadAndPeriodVouchers) {
        HashSet<Long> voucherIds = new HashSet<Long>(entities.size());
        HashMap<Long, Long> vId2orgId = new HashMap<Long, Long>(8);
        HashMap<Long, Set<Long>> voucher2Cashflow = new HashMap<Long, Set<Long>>(entities.size());
        Set<Long> partLoadVoucherIds = partLoadAndPeriodVouchers.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        for (DynamicObject vchDyn : entities) {
            long vid = vchDyn.getLong("id");
            voucherIds.add(vid);
            vId2orgId.put(vid, vchDyn.getLong("org.id"));
            if (partLoadVoucherIds.contains(vid)) continue;
            HashSet<Long> newCfIds = null;
            if (vchDyn.containsProperty("entries")) {
                newCfIds = new HashSet<Long>(16);
                for (DynamicObject entry : vchDyn.getDynamicObjectCollection("entries")) {
                    long maincf = entry.getLong("maincfitem_id");
                    long suppcf = entry.getLong("suppcfitem_id");
                    if (maincf != 0L) {
                        newCfIds.add(maincf);
                    }
                    if (suppcf == 0L) continue;
                    newCfIds.add(suppcf);
                }
            } else {
                partLoadVoucherIds.add(vchDyn.getLong("id"));
            }
            voucher2Cashflow.put(vid, newCfIds);
        }
        if (!partLoadVoucherIds.isEmpty()) {
            voucher2Cashflow.putAll(AbstractVoucherServicePlugIn.getNewCfIds(partLoadVoucherIds));
        }
        return new VoucherPresetParm(voucherIds, vId2orgId, voucher2Cashflow);
    }

    private void reyVoucherBillNo(Set<Object> failedVids, Map<Long, String> idAndNo) {
        DynamicObject[] dyns;
        String selectField = "id,bizdate,bookeddate,billno,org,period,sourcetype,vouchertype,billstatus,sourcebill";
        for (DynamicObject dyn : dyns = BusinessDataServiceHelper.load((String)"gl_voucher", (String)selectField, (QFilter[])new QFilter("id", "in", failedVids).toArray())) {
            String billNo = idAndNo.get(dyn.getLong("id"));
            dyn.set("billno", (Object)billNo);
            CodeRuleServiceHelper.recycleNumber((String)"gl_voucher", (DynamicObject)dyn, (String)dyn.getString("org_id"), (String)billNo);
        }
    }
}

