/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.preset;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.ext.fi.ai.presetcf.PresetCashFlowItemParam;
import kd.fi.gl.voucher.preset.BatchGroup;
import kd.fi.gl.voucher.preset.PresetType;
import kd.fi.gl.voucher.preset.VoucherHead;

public class PresetBatch {
    private Table<Long, PresetType, PresetCashFlowItemParam> paramTable;
    private Map<Long, VoucherHead> processVoucherHeadMap;
    private List<Row> processRowList;
    private BatchGroup batchGroup;
    private VoucherHead lastVoucherHead;
    private int batchSize;

    protected static PresetBatch create(int batchSize) {
        PresetBatch batch = new PresetBatch();
        batch.paramTable = HashBasedTable.create((int)batchSize, (int)2);
        batch.processVoucherHeadMap = new HashMap<Long, VoucherHead>(batchSize);
        batch.processRowList = new ArrayList<Row>(batchSize);
        batch.batchSize = batchSize;
        return batch;
    }

    protected Table<Long, PresetType, PresetCashFlowItemParam> getParamTable() {
        return this.paramTable;
    }

    protected Map<Long, VoucherHead> getProcessVoucherHeadMap() {
        return this.processVoucherHeadMap;
    }

    protected List<Row> getProcessRowList() {
        return this.processRowList;
    }

    protected BatchGroup getBatchGroup() {
        return this.batchGroup;
    }

    protected VoucherHead getLastVoucherHead() {
        return this.lastVoucherHead;
    }

    protected boolean tryAddRow(VoucherHead voucherHead, Row row) {
        if (this.batchGroup == null) {
            this.batchGroup = new BatchGroup();
            this.batchGroup.setOrgId(voucherHead.getOrgId());
            this.batchGroup.setAccTabId(voucherHead.getAccTabId());
            this.batchGroup.setPeriodId(voucherHead.getPeriodId());
            this.processRowList.add(row);
            return true;
        }
        if (this.batchGroup.sameGroup(voucherHead.getOrgId(), voucherHead.getAccTabId(), voucherHead.getPeriodId()) && this.processRowList.size() <= this.batchSize) {
            this.processRowList.add(row);
            return true;
        }
        return false;
    }

    protected void addRow(Row row) {
        this.processRowList.add(row);
    }

    protected void reset() {
        this.processVoucherHeadMap.clear();
        this.processRowList.clear();
        this.paramTable.clear();
        if (this.lastVoucherHead == null) {
            this.batchGroup = null;
        } else {
            if (this.batchGroup == null) {
                this.batchGroup = new BatchGroup();
            }
            this.batchGroup.setOrgId(this.lastVoucherHead.getOrgId());
            this.batchGroup.setAccTabId(this.lastVoucherHead.getAccTabId());
        }
    }

    protected boolean nextVoucher(VoucherHead voucherHead) {
        if (this.lastVoucherHead == null) {
            this.lastVoucherHead = voucherHead;
            return true;
        }
        if (this.lastVoucherHead.getId() != voucherHead.getId()) {
            this.processVoucherHeadMap.put(this.lastVoucherHead.getId(), this.lastVoucherHead);
            this.lastVoucherHead = voucherHead;
            return true;
        }
        return false;
    }

    protected void uploadLastVoucher() {
        if (this.lastVoucherHead != null) {
            this.processVoucherHeadMap.put(this.lastVoucherHead.getId(), this.lastVoucherHead);
            this.lastVoucherHead = null;
        }
    }
}

