/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.util;

import kd.fi.gl.business.vo.voucher.Amount;
import kd.fi.gl.business.vo.voucher.AmountField;
import kd.fi.gl.business.vo.voucher.IVoucherEntry;
import kd.fi.gl.util.AmountDimensionalMap;

public abstract class AmountAggregator {
    private final AmountDimensionalMap<Object> debitTotal = new AmountDimensionalMap();
    private final AmountDimensionalMap<Object> creditTotal = new AmountDimensionalMap();

    public void sum(IVoucherEntry entry, Object[] keys) {
        Amount amount = this.getAmount(entry);
        this.debitTotal.accumulate(amount.getDebit(), keys);
        this.creditTotal.accumulate(amount.getCredit(), keys);
    }

    public AmountDimensionalMap<Object> getDebitTotal() {
        return this.debitTotal;
    }

    public AmountDimensionalMap<Object> getCreditTotal() {
        return this.creditTotal;
    }

    public abstract Amount getAmount(IVoucherEntry var1);

    public abstract AmountField getField();

    public abstract int getAmtPrecision();
}

