/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.ext.fi.lock.IShareLock;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.cache.IdDynCache;
import kd.fi.gl.cache.IdDynCacheWrapper;
import kd.fi.gl.cache.MapCache;
import kd.fi.gl.common.VoucherAgainst;
import kd.fi.gl.common.VoucherOpOption;
import kd.fi.gl.util.DateUtil;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.OrgBookTypeUtil;
import kd.fi.gl.validate.flex.FlexValueValidateService;
import kd.fi.gl.voucher.validate.AbstractBaseVoucherValidator;
import kd.fi.gl.voucher.validate.AccountWrapper;
import kd.fi.gl.voucher.validate.CfMainItemWrapper;
import kd.fi.gl.voucher.validate.VoucherValidateMsgBuilder;
import kd.fi.gl.voucher.validate.VoucherValidateMsgFormatter;

public abstract class BaseVoucherValidator
extends AbstractBaseVoucherValidator {
    private static final String BOOK_SELECT = "basecurrency.name,curperiod.id,curperiod.begindate,curperiod.enddate,curperiod.name,curperiod.number,curperiod.periodnumber,curperiod.periodyear,defaultvouchertype.name,ismainbook,name,number,periodtype.number,enable,isbudget,cashinitperiod,isendinitcashflow";
    private static final String PERIOD_SELECT = "id,begindate,enddate,name,number,periodnumber,periodyear,isadjustperiod,periodtype.id";
    private FlexValueValidateService flexValueValidateService;
    private IdDynCacheWrapper<AccountWrapper> accCache;
    private IdDynCacheWrapper<CfMainItemWrapper> cfMainItemCache;
    private MapCache<String, List<Long>> openedPeriodCache;
    private IdDynCache bookDynCache;
    private IdDynCache periodDynCache;
    private MapCache<String, Long> accTabIdCache;
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    private VoucherValidateMsgBuilder msgBuilder;

    protected FlexValueValidateService getFlexValueValidateService() {
        if (this.flexValueValidateService == null) {
            this.flexValueValidateService = new FlexValueValidateService();
        }
        return this.flexValueValidateService;
    }

    protected IdDynCacheWrapper<AccountWrapper> getAccCache() {
        if (this.accCache == null) {
            this.accCache = new IdDynCacheWrapper(Collections.emptyList(), "bd_accountview", AccountWrapper.SELECT_FIELDS, AccountWrapper::create);
        }
        return this.accCache;
    }

    protected IdDynCacheWrapper<CfMainItemWrapper> getCfMainItemCache() {
        if (this.cfMainItemCache == null) {
            this.cfMainItemCache = new IdDynCacheWrapper(Collections.emptyList(), "gl_cashflowitem", CfMainItemWrapper.SELECT_FIELDS, CfMainItemWrapper::create);
        }
        return this.cfMainItemCache;
    }

    protected MapCache<String, List<Long>> getOpenedPeriodCache() {
        if (null == this.openedPeriodCache) {
            this.openedPeriodCache = new MapCache(new HashMap(2), key -> {
                Tuple orgIdBookTypeId = OrgBookTypeUtil.getOrgIdBookTypeIdTupleByGroupKey((String)key);
                return GLUtil.getOpenPeriod((long)((Long)orgIdBookTypeId.item1), (long)((Long)orgIdBookTypeId.item2));
            });
        }
        return this.openedPeriodCache;
    }

    protected IdDynCache getBookDynCache() {
        if (this.bookDynCache == null) {
            this.bookDynCache = new IdDynCache(2, "gl_accountbook", BOOK_SELECT);
        }
        return this.bookDynCache;
    }

    protected IdDynCache getPeriodDynCache() {
        if (this.periodDynCache == null) {
            this.periodDynCache = new IdDynCache(8, "bd_period", PERIOD_SELECT);
        }
        return this.periodDynCache;
    }

    protected MapCache<String, Long> getAccTabIdCache() {
        if (this.accTabIdCache == null) {
            this.accTabIdCache = new MapCache(new HashMap(2), key -> {
                Long[] idArr = OrgBookTypeUtil.getIdArrayFromKeySplit((String)key);
                return AccountRefUtils.getCurPeriodAccountTableId((long)idArr[0], (long)idArr[1], (long)idArr[2]);
            });
        }
        return this.accTabIdCache;
    }

    protected boolean editAction() {
        String editActionStr = this.getOption().getVariableValue("edit_action", Boolean.FALSE.toString());
        boolean editAction = Boolean.parseBoolean(editActionStr);
        VoucherOpOption.setEditAction((Boolean)editAction);
        return VoucherOpOption.isEditAction();
    }

    protected VoucherValidateMsgFormatter getMsgFormtter() {
        return VoucherValidateMsgFormatter.get();
    }

    protected VoucherValidateMsgBuilder getMsgBuilder() {
        return this.msgBuilder;
    }

    public void init() {
        this.msgBuilder = new VoucherValidateMsgBuilder();
    }

    void validateHandle(ExtendedDataEntity dataEntity, Map<Long, String> map) {
        DynamicObject vo = dataEntity.getDataEntity();
        if (vo.getBoolean("isreverse") && "save".equals(this.getOperateKey())) {
            this.editAction();
            this.msgBuilder.appendEntryMsg(VoucherAgainst.saveValidator((DynamicObject)vo, (boolean)true));
        }
        if (this.msgBuilder.getErrorMsg().length() > 0) {
            this.addMessage(dataEntity, this.msgBuilder.getErrorMsg().toString(), ErrorLevel.Error);
            return;
        }
        this.checkPeriodAndBizData(vo);
        if (this.msgBuilder.getErrorMsg().length() > 0) {
            this.addMessage(dataEntity, this.msgBuilder.getErrorMsg().toString(), ErrorLevel.Error);
            return;
        }
        this.baseValidate(vo, map);
        if (this.msgBuilder.getErrorMsg().length() > 0) {
            this.addMessage(dataEntity, this.msgBuilder.getErrorMsg().toString(), ErrorLevel.Error);
            return;
        }
        this.entryValidate(dataEntity);
        this.msgBuilder.mergeEntryToError();
        if (this.msgBuilder.getErrorMsg().length() > 0) {
            this.addMessage(dataEntity, this.msgBuilder.getErrorMsg().toString(), ErrorLevel.Error);
        }
    }

    public abstract void entryValidate(ExtendedDataEntity var1);

    protected abstract void baseValidate(DynamicObject var1, Map<Long, String> var2);

    protected void checkPeriodAndBizData(DynamicObject vchDyn) {
        String invoiceNum = this.getInvoiceNum(vchDyn);
        DynamicObject bookDynOnVch = vchDyn.getDynamicObject("book");
        if (bookDynOnVch == null) {
            this.msgBuilder.appendErrorMsg(String.format(ResManager.loadKDString((String)"%s\u6838\u7b97\u7ec4\u7ec7\u5bf9\u5e94\u8d26\u7c3f\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u5728\u6838\u7b97\u4f53\u7cfb\u7ef4\u62a4\u5bf9\u5e94\u8d26\u7c3f\u3002", (String)"BaseVoucherValidator_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), invoiceNum));
            return;
        }
        DynamicObject periodDynOnVch = vchDyn.getDynamicObject("period");
        if (periodDynOnVch == null) {
            this.msgBuilder.appendErrorMsg(String.format(ResManager.loadKDString((String)"%s\u8bb0\u8d26\u671f\u95f4\u4e3a\u7a7a\u3002", (String)"BaseVoucherValidator_3", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), invoiceNum));
            return;
        }
        long bookIdOnVch = bookDynOnVch.getLong("id");
        if (!bookDynOnVch.getBoolean("enable")) {
            this.msgBuilder.appendErrorMsg(ResManager.loadKDString((String)"\u65e0\u6cd5\u4fdd\u5b58\u5df2\u7981\u7528\u8d26\u7c3f\u7684\u51ed\u8bc1\u3002", (String)"BaseVoucherValidator_2", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
            return;
        }
        long curPeriodId = bookDynOnVch.getLong("curperiod_id");
        if (curPeriodId == 0L) {
            this.msgBuilder.appendErrorMsg(String.format(ResManager.loadKDString((String)"%1$s[(%2$s)]\u8d26\u7c3f\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u671f\u95f4\u3002", (String)"BaseVoucherValidator_7", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), invoiceNum, bookIdOnVch));
            return;
        }
        long periodIdOnVch = periodDynOnVch.getLong("id");
        boolean isIgnorePeriod = this.getOption().containsVariable("ignorePeriod");
        if (!isIgnorePeriod && curPeriodId > periodIdOnVch) {
            long orgIdOnVch = vchDyn.getLong("org.id");
            long bookTypeId = vchDyn.getLong("booktype.id");
            List openedPeriodIdList = (List)this.getOpenedPeriodCache().get((Object)OrgBookTypeUtil.createGroupKey((Long[])new Long[]{orgIdOnVch, bookTypeId}));
            if (!openedPeriodIdList.contains(periodIdOnVch)) {
                this.msgBuilder.appendErrorMsg(String.format(ResManager.loadKDString((String)"%s\u51ed\u8bc1\u6240\u5c5e\u671f\u95f4\u5df2\u7ed3\u8d26\uff0c\u8bf7\u5148\u53cd\u7ed3\u8d26\u540e\u518d\u64cd\u4f5c\u51ed\u8bc1\u3002", (String)"BaseVoucherValidator_1", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), invoiceNum));
                return;
            }
        }
        periodDynOnVch = (DynamicObject)this.getPeriodDynCache().get((Object)periodIdOnVch);
        Date bookedDate = vchDyn.getDate("bookeddate");
        if ((bookedDate = DateUtil.makeDateOnDayStrart((Date)bookedDate)).compareTo(periodDynOnVch.getDate("begindate")) < 0 || bookedDate.compareTo(periodDynOnVch.getDate("enddate")) > 0 || bookDynOnVch.getLong("periodtype.id") != periodDynOnVch.getLong("periodtype.id")) {
            this.msgBuilder.appendErrorMsg(String.format(ResManager.loadKDString((String)"%s\u8bb0\u8d26\u65e5\u671f\u4e0e\u671f\u95f4\u4e0d\u7b26\u3002", (String)"BaseVoucherValidator_4", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), invoiceNum));
            return;
        }
        Date bizDate = vchDyn.getDate("bizdate");
        if ((bizDate = DateUtil.makeDateOnDayStrart((Date)bizDate)).after(bookedDate)) {
            this.msgBuilder.appendErrorMsg(String.format(ResManager.loadKDString((String)"%1$s\u4e1a\u52a1\u65e5\u671f%2$s\u665a\u4e8e\u8bb0\u8d26\u65e5\u671f%3$s\u3002", (String)"BaseVoucherValidator_5", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), invoiceNum, this.format.format(bizDate), this.format.format(bookedDate)));
            return;
        }
        vchDyn.set("bookeddate", (Object)bookedDate);
        vchDyn.set("bizdate", (Object)bizDate);
        if (vchDyn.getDate("createtime") == null) {
            vchDyn.set("createtime", (Object)new Date());
        }
    }

    private String getInvoiceNum(DynamicObject vchDyn) {
        String[] str;
        if ("7".equals(vchDyn.getString("sourcetype")) && (str = vchDyn.getString("description").split(",")).length > 0) {
            return String.format(ResManager.loadKDString((String)"%s\u751f\u6210\u7684\u51ed\u8bc1", (String)"BaseVoucherValidator_8", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), str[0]);
        }
        return "";
    }

    protected void doLock(long orgId, long bookTypeId, long periodId, Map<String, IShareLock> locks) {
        long curAccountTableId = (Long)this.getAccTabIdCache().get((Object)OrgBookTypeUtil.createGroupKey((Long[])new Long[]{orgId, bookTypeId, periodId}));
        String key = BaseVoucherValidator.getLockKey(orgId, curAccountTableId);
        locks.computeIfAbsent(key, k -> {
            IShareLock lock = IShareLock.create();
            lock.requireLock(k, true, 60L);
            return lock;
        });
    }

    protected static String getLockKey(long orgId, long accountTableId) {
        return StringUtils.join((Object[])new Object[]{"AccountChange", orgId, accountTableId}, (String)"-");
    }

    protected void preReadAccount(Collection<Long> vchIds) {
        if (vchIds.isEmpty()) {
            return;
        }
        try (DataSet accDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucher", (String)"entries.account", (QFilter[])new QFilter("id", "in", vchIds).toArray(), null);){
            HashSet<Long> accIds = new HashSet<Long>(vchIds.size() * 2);
            for (Row row : accDataSet) {
                accIds.add(row.getLong("entries.account"));
            }
            this.buildAccountRepository(accIds);
        }
    }

    protected void buildAccountRepository(Collection<Long> allAccIdSet) {
        if (this.accCache == null) {
            this.accCache = new IdDynCacheWrapper(allAccIdSet, "bd_accountview", AccountWrapper.SELECT_FIELDS, AccountWrapper::create);
        } else {
            this.accCache.getIdDynCache().batchFillCache(allAccIdSet);
        }
    }

    protected void buildCfMainItemRepository(Collection<Long> allCfMainItemIds) {
        if (this.cfMainItemCache == null) {
            this.cfMainItemCache = new IdDynCacheWrapper(allCfMainItemIds, "gl_cashflowitem", CfMainItemWrapper.SELECT_FIELDS, CfMainItemWrapper::create);
        } else {
            this.cfMainItemCache.getIdDynCache().batchFillCache(allCfMainItemIds);
        }
    }
}

