/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.gl.business.vo.voucher.Amount;
import kd.fi.gl.business.vo.voucher.AmountField;
import kd.fi.gl.business.vo.voucher.IVoucherEntry;
import kd.fi.gl.voucher.validate.AccountWrapper;
import kd.fi.gl.voucher.validate.CfMainItemWrapper;
import kd.fi.gl.wrap.DynWrapper;
import kd.fi.gl.wrap.EntryWrapper;

public class VchEntryWrapper
extends EntryWrapper
implements IVoucherEntry {
    private int seq;
    private AccountWrapper account;
    private CfMainItemWrapper cfMainItem;
    private long accId;
    private String accNum;
    private long cfMainItemId;
    private String cfMainItemNum;
    private DynWrapper currency;
    private long currencyId;
    private DynWrapper flexObj;
    private BigDecimal debitLocAmt;
    private BigDecimal creditLocAmt;
    private BigDecimal debitOriAmt;
    private BigDecimal creditOriAmt;
    private Date expireDate;
    private DynWrapper mainCfItem;
    private DynWrapper suppCfItem;
    private BigDecimal mainCfAmt;
    private BigDecimal suppCfAmt;

    public VchEntryWrapper(DynamicObject entryDyn) {
        super(entryDyn);
        this.initValue();
    }

    private void initValue() {
        this.seq = this.getInt("seq");
        this.initAccValue();
        this.initCfMainItemValue();
        this.currency = this.getDynWrapper("currency");
        this.currencyId = this.getLong("currency.id");
        this.initFlexValue();
        this.debitLocAmt = this.getBigDecimal("debitlocal");
        this.creditLocAmt = this.getBigDecimal("creditlocal");
        this.debitOriAmt = this.getBigDecimal("debitori");
        this.creditOriAmt = this.getBigDecimal("creditori");
        this.expireDate = this.getDate("expiredate");
        this.mainCfItem = this.getDynWrapper("maincfitem");
        this.suppCfItem = this.getDynWrapper("suppcfitem");
        this.mainCfAmt = this.getBigDecimal("maincfamount");
        this.suppCfAmt = this.getBigDecimal("suppcfamount");
    }

    private void initCfMainItemValue() {
        this.cfMainItem = CfMainItemWrapper.create(this.getDynamicObject("maincfitem"), false);
        this.cfMainItemId = this.getLong("maincfitem.id");
        this.cfMainItemNum = this.getString("maincfitem.number");
    }

    private void initAccValue() {
        this.account = AccountWrapper.create(this.getDynamicObject("account"), false);
        this.accId = this.getLong("account.id");
        this.accNum = this.getString("account.number");
    }

    private void initFlexValue() {
        this.flexObj = this.getDynWrapper("assgrp");
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public AccountWrapper getAccount() {
        return this.account;
    }

    public void setAccount(AccountWrapper account) {
        this.account = account;
    }

    public CfMainItemWrapper getCfMainItem() {
        return this.cfMainItem;
    }

    public void setCfMainItem(CfMainItemWrapper cfMainItem) {
        this.cfMainItem = cfMainItem;
    }

    public long getAccId() {
        return this.accId;
    }

    public void setAccId(long accId) {
        this.accId = accId;
    }

    public long getCfMainItemId() {
        return this.cfMainItemId;
    }

    public void setCfMainItemId(long cfMainItemId) {
        this.cfMainItemId = cfMainItemId;
    }

    public String getAccNum() {
        return this.accNum;
    }

    public String getCfMainItemNum() {
        return this.cfMainItemNum;
    }

    public void setCfMainItemNum(String cfMainItemNum) {
        this.cfMainItemNum = cfMainItemNum;
    }

    public DynWrapper getCurrency() {
        return this.currency;
    }

    public void setCurrency(DynWrapper currency) {
        this.currency = currency;
    }

    public long getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(long currencyId) {
        this.currencyId = currencyId;
    }

    public DynWrapper getFlexObj() {
        return this.flexObj;
    }

    public BigDecimal getDebitLocAmt() {
        return this.debitLocAmt;
    }

    public BigDecimal getCreditLocAmt() {
        return this.creditLocAmt;
    }

    public BigDecimal getDebitOriAmt() {
        return this.debitOriAmt;
    }

    public void setDebitOriAmt(BigDecimal debitOriAmt) {
        this.debitOriAmt = debitOriAmt;
        this.set("debitori", debitOriAmt);
    }

    public BigDecimal getCreditOriAmt() {
        return this.creditOriAmt;
    }

    public void setCreditOriAmt(BigDecimal creditOriAmt) {
        this.creditOriAmt = creditOriAmt;
        this.set("creditori", creditOriAmt);
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(Date expireDate) {
        this.expireDate = expireDate;
    }

    public DynWrapper getMainCfItem() {
        return this.mainCfItem;
    }

    public void setMainCfItem(DynWrapper mainCfItem) {
        this.mainCfItem = mainCfItem;
    }

    public DynWrapper getSuppCfItem() {
        return this.suppCfItem;
    }

    public void setSuppCfItem(DynWrapper suppCfItem) {
        this.suppCfItem = suppCfItem;
    }

    public BigDecimal getMainCfAmt() {
        return this.mainCfAmt;
    }

    public void setMainCfAmt(BigDecimal mainCfAmt) {
        this.mainCfAmt = mainCfAmt;
    }

    public BigDecimal getSuppCfAmt() {
        return this.suppCfAmt;
    }

    public BigDecimal getDebit(AmountField field) {
        return this.getBigDecimal(field.getDebitField());
    }

    public BigDecimal getCredit(AmountField field) {
        return this.getBigDecimal(field.getCreditField());
    }

    public Amount getAmount(AmountField field) {
        return new Amount(this.getBigDecimal(field.getDebitField()), this.getBigDecimal(field.getCreditField()));
    }

    public void setBigDecimal(String field, BigDecimal decimal) {
        super.set(field, (Object)decimal);
    }

    public String getEntryDC() {
        return this.getString("entrydc");
    }

    public void setDynamicObject(String key, DynamicObject value) {
        super.setDynamicObject(key, value);
        switch (key) {
            case "account": {
                this.initAccValue();
                break;
            }
            case "assgrp": {
                this.initFlexValue();
            }
        }
    }
}

