/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.voucher.util.VoucherUtils;

public class VoucherAntiCancelValidator
extends AbstractValidator {
    private static final String RECIPROTAL_INIT_STATE_EKY = "voucher-reciprotal-status-key";

    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.setOperationName(ResManager.loadKDString((String)"\u51ed\u8bc1\u751f\u6548", (String)"VoucherAntiCancelValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
    }

    public void validate() {
        Map map = VoucherUtils.getStatusFromDB((ExtendedDataEntity[])this.dataEntities);
        this.checkReci();
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject v = entity.getDataEntity();
            if (v.getDataEntityState().getFromDatabase() && !map.containsKey(v.getLong("id"))) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8be5\u6761\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"VoucherAntiCancelValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject book = BusinessDataServiceHelper.loadSingleFromCache((Object)v.getLong("book_id"), (String)"gl_accountbook");
            Long curPeriodId = book.getDynamicObject("curperiod").getLong("id");
            Long vchPeriodId = v.getDynamicObject("period").getLong("id");
            List opPeriod = GLUtil.getOpenPeriod((long)v.getLong("org.id"), (long)v.getLong("booktype.id"));
            if (vchPeriodId < curPeriodId && !opPeriod.contains(vchPeriodId)) {
                this.addMessage(entity, ResManager.loadKDString((String)"\u51ed\u8bc1\u6240\u5c5e\u671f\u95f4\u5df2\u7ed3\u8d26\uff0c\u8bf7\u5148\u53cd\u7ed3\u8d26\u540e\u518d\u64cd\u4f5c\u51ed\u8bc1\u3002", (String)"VoucherAntiCancelValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            String enable = book.getString("enable");
            if ("0".equals(enable)) {
                this.addMessage(entity, ResManager.loadKDString((String)"\u65e0\u6cd5\u64cd\u4f5c\u5df2\u7981\u7528\u8d26\u7c3f\u7684\u51ed\u8bc1\u3002", (String)"VoucherAntiCancelValidator_3", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            String status = map.get(v.getLong("id")) != null ? (String)map.get(v.getLong("id")) : v.getString("billstatus");
            this.validateHandle(entity, status);
        }
    }

    protected void validateHandle(ExtendedDataEntity voucher, String status) {
        if (this.checkStatus(status)) {
            this.addErrorMessage(voucher, ResManager.loadKDString((String)"\u4f5c\u5e9f\u51ed\u8bc1\u624d\u5141\u8bb8\u751f\u6548\u3002", (String)"VoucherAntiCancelValidator_4", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return;
        }
    }

    private boolean checkStatus(String status) {
        return !"D".equals(status);
    }

    private void checkReci() {
        ArrayList<Long> acctIds = new ArrayList<Long>();
        for (ExtendedDataEntity ex : this.dataEntities) {
            DynamicObject obj = ex.getDataEntity();
            DynamicObjectCollection col = obj.getDynamicObjectCollection("entries");
            for (DynamicObject entry : col) {
                DynamicObject acct = entry.getDynamicObject("account");
                if (null == acct || !acct.getBoolean("accheck")) continue;
                acctIds.add(acct.getLong("masterid"));
            }
        }
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        if (!acctIds.isEmpty()) {
            QFilter facctId = new QFilter("account.masterid", "in", acctIds);
            DynamicObjectCollection col = QueryServiceHelper.query((String)"gl_reci_init_state", (String)"org,booktype,account.masterid,endinitperiod,isendinit", (QFilter[])new QFilter[]{facctId});
            for (DynamicObject obj : col) {
                String key = obj.getLong("org") + "-" + obj.getLong("booktype") + "-" + obj.getLong("account.masterid");
                map.put(key, obj);
            }
        }
        ArrayList<Long> acctId_no = new ArrayList<Long>();
        for (ExtendedDataEntity ex : this.dataEntities) {
            DynamicObject obj = ex.getDataEntity();
            DynamicObjectCollection col = obj.getDynamicObjectCollection("entries");
            for (DynamicObject entry : col) {
                DynamicObject acct = entry.getDynamicObject("account");
                if (null == acct || !acct.getBoolean("accheck")) continue;
                long acctId = acct.getLong("id");
                String key = obj.getLong("org.id") + "-" + obj.getLong("booktype.id") + "-" + acct.getLong("masterid");
                if (map.containsKey(key)) {
                    long initPeriod;
                    DynamicObject reci = (DynamicObject)map.get(key);
                    long period = obj.getLong("period.id");
                    if (period >= (initPeriod = reci.getLong("endinitperiod"))) continue;
                    boolean isEndInit = reci.getBoolean("isendinit");
                    if (isEndInit) {
                        this.addMessage(ex, ResManager.loadKDString((String)"\u79d1\u76ee\u5df2\u7ed3\u675f\u5f80\u6765\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u51ed\u8bc1\u3002", (String)"VoucherAntiCancelValidator_5", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    acctId_no.add(acctId);
                    continue;
                }
                acctId_no.add(acctId);
            }
        }
        ThreadCache.put((Object)RECIPROTAL_INIT_STATE_EKY, acctId_no);
    }
}

