/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.voucher.util.VoucherUtils;

public class VoucherCancelValidator
extends AbstractValidator {
    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.setOperationName(ResManager.loadKDString((String)"\u51ed\u8bc1\u4f5c\u5e9f", (String)"VoucherCancelValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
    }

    public void validate() {
        Map map = VoucherUtils.getStatusFromDB((ExtendedDataEntity[])this.dataEntities);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ExtendedDataEntity entity : this.dataEntities) {
            String status;
            DynamicObject v = entity.getDataEntity();
            DynamicObject book = BusinessDataServiceHelper.loadSingleFromCache((Object)v.getLong("book_id"), (String)"gl_accountbook");
            Long curPeriodId = book.getDynamicObject("curperiod").getLong("id");
            Long vchPeriodId = v.getDynamicObject("period").getLong("id");
            List opPeriod = GLUtil.getOpenPeriod((long)v.getLong("org.id"), (long)v.getLong("booktype.id"));
            if (vchPeriodId < curPeriodId && !opPeriod.contains(vchPeriodId)) {
                this.addMessage(entity, ResManager.loadKDString((String)"\u51ed\u8bc1\u6240\u5c5e\u671f\u95f4\u5df2\u7ed3\u8d26\uff0c\u8bf7\u5148\u53cd\u7ed3\u8d26\u540e\u518d\u64cd\u4f5c\u51ed\u8bc1\u3002", (String)"VoucherCancelValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            String enable = book.getString("enable");
            if ("0".equals(enable)) {
                this.addMessage(entity, ResManager.loadKDString((String)"\u65e0\u6cd5\u64cd\u4f5c\u5df2\u7981\u7528\u8d26\u7c3f\u7684\u51ed\u8bc1\u3002", (String)"VoucherCancelValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (v.getDataEntityState().getFromDatabase() && !map.containsKey(v.getLong("id"))) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8be5\u6761\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"VoucherCancelValidator_3", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                continue;
            }
            String string = status = map.get(v.getLong("id")) != null ? (String)map.get(v.getLong("id")) : v.getString("billstatus");
            if (this.checkStatus(status)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u51ed\u8bc1\u624d\u5141\u8bb8\u4f5c\u5e9f\u3002", (String)"VoucherCancelValidator_4", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (this.checkNotice(v.getLong("id"))) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8be5\u51ed\u8bc1\u5df2\u52fe\u7a3d\u901a\u77e5\u5355\uff0c\u4e0d\u53ef\u4f5c\u5e9f\u3002", (String)"VoucherCancelValidator_5", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                continue;
            }
            ids.add(v.getLong("id"));
        }
        Set reciIds = VoucherUtils.isReciprocal(ids);
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject v = entity.getDataEntity();
            if (!reciIds.contains(v.getLong("id"))) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5df2\u6838\u9500\u7684\u51ed\u8bc1\u4e0d\u53ef\u4f5c\u5e9f\u3002", (String)"VoucherCancelValidator_6", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkNotice(long id) {
        QFilter idF = new QFilter("voucher", "=", (Object)id);
        QFilter statusF = new QFilter("checkstatus", "=", (Object)"1");
        return QueryServiceHelper.exists((String)"gl_cfnotice", (QFilter[])new QFilter[]{idF, statusF}) || QueryServiceHelper.exists((String)"gl_acnotice", (QFilter[])new QFilter[]{idF, statusF});
    }

    private boolean checkStatus(String status) {
        return !"B".equals(status);
    }
}

