/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.voucher.validate.CheckableSource;
import kd.fi.gl.voucher.validate.VchDynWrapper;
import kd.fi.gl.voucher.validate.VchExtDataEntityWrapper;
import kd.fi.gl.voucher.validate.VoucherContext;

public class VoucherCheckValidateUtil {
    public static CheckableSource getCheckableSourceFromVoucher(VchExtDataEntityWrapper vchExtDataEntityWrapper, VoucherContext voucherContext) {
        VchDynWrapper vchDynWrapper = vchExtDataEntityWrapper.getVchDynWrapper();
        DynamicObject sourceBillType = vchDynWrapper.getDynamicObject("sourcebilltype");
        if (sourceBillType == null) {
            return null;
        }
        long billId = vchDynWrapper.getLong("sourcebill");
        if (billId <= 0L) {
            return null;
        }
        if ("c".equals(vchDynWrapper.getString("ischeck"))) {
            return null;
        }
        if (!((Boolean)voucherContext.getAutoCheckConfigCache().get((Object)vchExtDataEntityWrapper.getOrgId())).booleanValue()) {
            return null;
        }
        String sourceBillNumber = sourceBillType.getString("number");
        if (!VoucherCheckValidateUtil.sourceEntityCheckable(sourceBillNumber)) {
            return null;
        }
        return CheckableSource.create(sourceBillNumber, billId);
    }

    public static void batchLoadCheckableSourcesInfo(List<CheckableSource> checkableSources) {
        if (checkableSources.isEmpty()) {
            return;
        }
        Map<String, List<CheckableSource>> entityIdSourcesMap = checkableSources.stream().collect(Collectors.groupingBy(CheckableSource::getEntityId));
        for (Map.Entry<String, List<CheckableSource>> entityIdSources : entityIdSourcesMap.entrySet()) {
            String entityId = entityIdSources.getKey();
            Map<Long, CheckableSource> idSourcesMap = entityIdSources.getValue().stream().collect(Collectors.toMap(CheckableSource::getId, x -> x, (o, n) -> n));
            DataSet sourcesDataSet = VoucherCheckValidateUtil.querySourcesInfo(entityId, idSourcesMap.keySet());
            Throwable throwable = null;
            try {
                for (Row row : sourcesDataSet) {
                    Long id = row.getLong(0);
                    CheckableSource source = idSourcesMap.get(id);
                    source.setBillNo(row.getString(1));
                    source.setStatus(row.getString(2));
                    source.setCashierId(row.getLong(3));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (sourcesDataSet == null) continue;
                if (throwable != null) {
                    try {
                        sourcesDataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                sourcesDataSet.close();
            }
        }
        Tuple<Set<String>, Set<Long>> hasJournalSources = VoucherCheckValidateUtil.getHasJournalSourcesNoAndId(checkableSources);
        Set numSet = (Set)hasJournalSources.item1;
        Set idSet = (Set)hasJournalSources.item2;
        for (CheckableSource source : checkableSources) {
            source.setHasJournal(idSet.contains(source.getId()) || numSet.contains(source.getBillNo()));
        }
    }

    private static DataSet querySourcesInfo(String entityId, Set<Long> ids) {
        String select = "id,billno,billstatus";
        switch (entityId) {
            case "cas_paybill": 
            case "cas_recbill": 
            case "cas_agentpaybill": {
                select = select + ",cashier";
                break;
            }
            default: {
                select = select + ",modifier";
            }
        }
        return QueryServiceHelper.queryDataSet((String)"VoucherCheckValidateUtil#queryBillInfo", (String)entityId, (String)select, (QFilter[])new QFilter("id", "in", ids).toArray(), null);
    }

    private static Tuple<Set<String>, Set<Long>> getHasJournalSourcesNoAndId(List<CheckableSource> sources) {
        if (sources.isEmpty()) {
            return Tuple.create(Collections.emptySet(), Collections.emptySet());
        }
        Set numSet = sources.stream().map(CheckableSource::getBillNo).collect(Collectors.toSet());
        Set idSet = sources.stream().map(CheckableSource::getId).collect(Collectors.toSet());
        QFilter filter = new QFilter("sourcebillid", "in", idSet);
        HashSet billIds = new HashSet(idSet.size());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"VoucherCheckValidateUtil#getHasJournalBills", (String)"cas_bankjournal", (String)"sourcebillid", (QFilter[])filter.toArray(), null);){
            ds.forEachRemaining(row -> billIds.add(row.getLong(0)));
        }
        ds = QueryServiceHelper.queryDataSet((String)"VoucherCheckValidateUtil#getHasJournalBills", (String)"cas_cashjournal", (String)"sourcebillid", (QFilter[])filter.toArray(), null);
        var6_6 = null;
        try {
            ds.forEachRemaining(row -> billIds.add(row.getLong(0)));
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var6_6 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        filter = new QFilter("sourcebillnumber", "in", numSet);
        HashSet billNos = new HashSet(numSet.size());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"VoucherCheckValidateUtil#getHasJournalBills", (String)"cas_bankjournal", (String)"sourcebillnumber", (QFilter[])filter.toArray(), null);){
            ds.forEachRemaining(row -> billNos.add(row.getString(0)));
        }
        ds = QueryServiceHelper.queryDataSet((String)"VoucherCheckValidateUtil#getHasJournalBills", (String)"cas_cashjournal", (String)"sourcebillnumber", (QFilter[])filter.toArray(), null);
        var7_11 = null;
        try {
            ds.forEachRemaining(row -> billNos.add(row.getString(0)));
        }
        catch (Throwable throwable) {
            var7_11 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var7_11 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var7_11.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        return Tuple.create(billNos, billIds);
    }

    private static boolean sourceEntityCheckable(String entityId) {
        return "cas_paybill".equals(entityId) || "cas_recbill".equals(entityId) || "cas_agentpaybill".equals(entityId) || "cas_exchangebill".equals(entityId) || "fca_transupbill".equals(entityId) || "fca_transdownbill".equals(entityId);
    }
}

