/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.ai.v2.fah.dto.BillToVchRelationDto;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.business.GLServiceFactory;
import kd.fi.gl.interfaces.service.dap.IDAPService;
import kd.fi.gl.notice.NoticeUtils;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.SystemParamHelper;
import kd.fi.gl.util.TccUtil;
import kd.fi.gl.voucher.option.VoucherOption;
import kd.fi.gl.voucher.util.VoucherUtils;

public class VoucherDeleteValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(VoucherDeleteValidator.class);
    private final Map<Long, Boolean> autoVouAllowDel = new HashMap<Long, Boolean>();

    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.setOperationName(ResManager.loadKDString((String)"\u51ed\u8bc1\u5220\u9664", (String)"VoucherDeleteValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
    }

    private static IDAPService getDAPService() {
        return (IDAPService)GLServiceFactory.getService(IDAPService.class);
    }

    public void validate() {
        boolean mechanismDel = this.getOption().containsVariable("mechanism");
        Map map = VoucherUtils.getStatusFromDB((ExtendedDataEntity[])this.dataEntities);
        boolean checkBalLog = VoucherOption.checkBalLog();
        Set submittedVchId = Collections.EMPTY_SET;
        if (checkBalLog) {
            List tempIds = map.entrySet().stream().filter(e -> "A".equals(e.getValue())).map(e -> (Long)e.getKey()).collect(Collectors.toList());
            submittedVchId = VoucherUtils.hasSubmittedVchId(tempIds);
        }
        ArrayList<Long> tempVoucherIdList = new ArrayList<Long>(this.dataEntities.length);
        HashMap<Long, ExtendedDataEntity> tempVoucherIdDataEntityMap = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        ArrayList<String> businessIds = new ArrayList<String>(this.dataEntities.length);
        HashMap<Long, DynamicObject> accountBookMap = new HashMap<Long, DynamicObject>(8);
        for (ExtendedDataEntity entity : this.dataEntities) {
            String status;
            DynamicObject v = entity.getDataEntity();
            businessIds.add(v.getString("id"));
            Long bookId = v.getLong("book_id");
            DynamicObject book = (DynamicObject)accountBookMap.get(bookId);
            if (book == null) {
                book = BusinessDataServiceHelper.loadSingleFromCache((Object)v.getLong("book_id"), (String)"gl_accountbook", (String)"curperiod.id,enable");
                accountBookMap.put(bookId, book);
            }
            long curPeriodId = book.getLong("curperiod.id");
            long vchPeriodId = v.getDynamicObject("period").getLong("id");
            List opPeriod = GLUtil.getOpenPeriod((long)v.getLong("org.id"), (long)v.getLong("booktype.id"));
            if (vchPeriodId < curPeriodId && !opPeriod.contains(vchPeriodId)) {
                this.addMessage(entity, ResManager.loadKDString((String)"\u51ed\u8bc1\u6240\u5c5e\u671f\u95f4\u5df2\u7ed3\u8d26\uff0c\u8bf7\u5148\u53cd\u7ed3\u8d26\u540e\u518d\u64cd\u4f5c\u51ed\u8bc1\u3002", (String)"VoucherDeleteValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            String enable = book.getString("enable");
            if ("0".equals(enable)) {
                this.addMessage(entity, ResManager.loadKDString((String)"\u65e0\u6cd5\u64cd\u4f5c\u5df2\u7981\u7528\u8d26\u7c3f\u7684\u51ed\u8bc1\u3002", (String)"VoucherDeleteValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            long id = v.getLong("id");
            if (v.getDataEntityState().getFromDatabase() && !map.containsKey(id)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8be5\u6761\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"VoucherDeleteValidator_3", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                continue;
            }
            String string = status = map.get(id) != null ? (String)map.get(id) : v.getString("billstatus");
            if (this.checkStatus(status)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u6682\u5b58\u3001\u63d0\u4ea4\u6216\u4f5c\u5e9f\u72b6\u6001\u7684\u51ed\u8bc1\u624d\u5141\u8bb8\u5220\u9664\u3002", (String)"VoucherDeleteValidator_4", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (v.getString("ischeck").equals("c")) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5df2\u590d\u6838\u7684\u51ed\u8bc1\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"VoucherDeleteValidator_5", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!mechanismDel) {
                boolean isAllowDel;
                long orgId = v.getLong("org_id");
                if (this.autoVouAllowDel.get(orgId) == null) {
                    isAllowDel = SystemParamHelper.getBooleanParam((String)"autovouallowdel", (long)orgId, (boolean)true);
                    this.autoVouAllowDel.put(orgId, isAllowDel);
                } else {
                    isAllowDel = this.autoVouAllowDel.get(orgId);
                }
                if (!isAllowDel && "4".equals(v.getString("sourcetype"))) {
                    this.addMessage(entity, ResManager.loadKDString((String)"\u673a\u5236\u51ed\u8bc1\u4e0d\u5141\u8bb8\u624b\u5de5\u5220\u9664\u3002", (String)"VoucherDeleteValidator_6", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    continue;
                }
            }
            if (checkBalLog && submittedVchId.contains(entity.getBillPkId())) {
                this.addMessage(entity, ResManager.loadKDString((String)"\u51ed\u8bc1\u6570\u636e\u72b6\u6001\u5f02\u5e38\uff0c\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VoucherDeleteValidator_10", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            tempVoucherIdList.add(id);
            tempVoucherIdDataEntityMap.put(id, entity);
        }
        Set reciIds = VoucherUtils.isReciprocal(tempVoucherIdList);
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject v = entity.getDataEntity();
            if (!reciIds.contains(v.getLong("id"))) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5df2\u6838\u9500\u7684\u51ed\u8bc1\u4e0d\u80fd\u5220\u9664\u3002", (String)"VoucherDeleteValidator_7", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        }
        tempVoucherIdList.removeAll(reciIds);
        Set noticeCheckedVoucherIdSet = NoticeUtils.getNoticeCheckedVoucherIdSet(tempVoucherIdList);
        for (Long id : noticeCheckedVoucherIdSet) {
            this.addErrorMessage((ExtendedDataEntity)tempVoucherIdDataEntityMap.get(id), ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u52fe\u7a3d\u901a\u77e5\u5355\uff0c\u51ed\u8bc1\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"VoucherDeleteValidator_9", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        if (!businessIds.isEmpty() && TccUtil.isDtxEnable()) {
            List list = TxCheckUtil.loadUnfinishedTx((String)"voucher", businessIds);
            if (list != null && list.size() > 0) {
                for (ExtendedDataEntity entity : this.dataEntities) {
                    DynamicObject v = entity.getDataEntity();
                    if (!list.contains(v.getString("id"))) continue;
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5206\u5e03\u5f0f\u4e8b\u52a1\u8fdb\u884c\u4e2d\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"VoucherDeleteValidator_8", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                }
            }
            this.checkDtxForBillId(businessIds);
        }
    }

    private void checkDtxForBillId(List<String> businessIds) {
        HashMap<String, Map> billAndVchMap = new HashMap<String, Map>();
        Set voucherIds = businessIds.stream().map(Long::parseLong).collect(Collectors.toSet());
        BillToVchRelationDto voucherRelations = VoucherDeleteValidator.getDAPService().getBillToVchRelationDtoByVchIDSet(voucherIds);
        for (Object voucherRelation : voucherRelations) {
            Long l = voucherRelation.getVoucherId();
            if (l == 0L) continue;
            billAndVchMap.computeIfAbsent(voucherRelation.getBillType(), t -> new HashMap()).computeIfAbsent(String.valueOf(voucherRelation.getBillId()), v -> new HashSet()).add(String.valueOf(voucherRelation.getVoucherId()));
        }
        HashMap unfinishedIdMap = new HashMap();
        for (Map.Entry entry : billAndVchMap.entrySet()) {
            List billIds = TxCheckUtil.loadUnfinishedTx((String)("dap_" + (String)entry.getKey()), new ArrayList(((Map)entry.getValue()).keySet()));
            if (null == billIds || billIds.isEmpty()) continue;
            unfinishedIdMap.put(entry.getKey(), billIds);
        }
        if (!unfinishedIdMap.isEmpty()) {
            HashSet vchIds = new HashSet();
            for (Map.Entry entry : unfinishedIdMap.entrySet()) {
                for (String unfinishedId : (List)entry.getValue()) {
                    Map billIdAndVchIds = (Map)billAndVchMap.get(entry.getKey());
                    if (null == billIdAndVchIds) continue;
                    vchIds.addAll((Collection)billIdAndVchIds.get(unfinishedId));
                }
            }
            if (!vchIds.isEmpty()) {
                for (ExtendedDataEntity entity : this.dataEntities) {
                    DynamicObject v2 = entity.getDataEntity();
                    if (!vchIds.contains(v2.getString("id"))) continue;
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u51ed\u8bc1\u5173\u8054\u7684\u5355\u636eID\u8fd8\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d,\u4e0d\u80fd\u5220\u9664\u3002", (String)"VoucherDeleteValidator_11", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                }
            }
            logger.info("BillIds in UnfinishedTx: {}", unfinishedIdMap);
        }
    }

    private boolean checkStatus(String status) {
        return !"B".equals(status) && !"A".equals(status) && !"D".equals(status);
    }
}

