/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate.bill;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.gl.util.DateUtil;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.OrgBookTypeUtil;
import kd.fi.gl.validate.bigdata.ValidateResult;
import kd.fi.gl.voucher.validate.VchDynWrapper;
import kd.fi.gl.voucher.validate.VchExtDataEntityWrapper;
import kd.fi.gl.voucher.validate.VoucherContext;
import kd.fi.gl.voucher.validate.bill.IVoucherValidator;
import kd.fi.gl.wrap.DynWrapper;

public class PeriodValidator
implements IVoucherValidator {
    @Override
    public ValidateResult validate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VoucherContext voucherContext) {
        ValidateResult result = ValidateResult.create();
        VchDynWrapper vchDynWrapper = vchExtDataEntityWrapper.getVchDynWrapper();
        DynamicObject bookDynOnVch = vchDynWrapper.getDynamicObject("book");
        if (bookDynOnVch == null) {
            return result.setErrorMsg(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u5bf9\u5e94\u8d26\u7c3f\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u5728\u6838\u7b97\u4f53\u7cfb\u7ef4\u62a4\u5bf9\u5e94\u8d26\u7c3f\u3002", (String)"PeriodValidator_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        DynWrapper periodDynOnVch = vchDynWrapper.getPeriod();
        if (periodDynOnVch == null) {
            return result.setErrorMsg(ResManager.loadKDString((String)"\u8bb0\u8d26\u671f\u95f4\u4e3a\u7a7a", (String)"PeriodValidator_1", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        long bookIdOnVch = bookDynOnVch.getLong("id");
        if (!bookDynOnVch.getBoolean("enable")) {
            return result.setErrorMsg(ResManager.loadKDString((String)"\u65e0\u6cd5\u4fdd\u5b58\u5df2\u7981\u7528\u8d26\u7c3f\u7684\u51ed\u8bc1\u3002", (String)"PeriodValidator_3", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        long curPeriodId = bookDynOnVch.getLong("curperiod_id");
        if (curPeriodId == 0L) {
            return result.setErrorMsg(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u8d26\u7c3f\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u671f\u95f4\u3002", (String)"PeriodValidator_4", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), bookIdOnVch));
        }
        long periodIdOnVch = periodDynOnVch.getLong("id");
        boolean isIgnorePeriod = voucherContext.getVoucherOption().isIgnorePeriod();
        if (!isIgnorePeriod && curPeriodId > periodIdOnVch) {
            long orgIdOnVch = vchExtDataEntityWrapper.getOrgId();
            long bookTypeId = vchExtDataEntityWrapper.getBookTypeId();
            List openedPeriodIdList = (List)voucherContext.getOpenedPeriodCache().get((Object)OrgBookTypeUtil.createGroupKey((Long[])new Long[]{orgIdOnVch, bookTypeId}));
            if (!openedPeriodIdList.contains(periodIdOnVch)) {
                return result.setErrorMsg(ResManager.loadKDString((String)"\u51ed\u8bc1\u6240\u5c5e\u671f\u95f4\u5df2\u7ed3\u8d26\uff0c\u8bf7\u5148\u53cd\u7ed3\u8d26\u540e\u518d\u64cd\u4f5c\u51ed\u8bc1\u3002", (String)"PeriodValidator_5", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
            }
        }
        periodDynOnVch = new DynWrapper((DynamicObject)voucherContext.getPeriodDynCache().get((Object)periodIdOnVch));
        Date bookedDate = vchDynWrapper.getDate("bookeddate");
        if ((bookedDate = DateUtil.makeDateOnDayStrart((Date)bookedDate)).compareTo(periodDynOnVch.getDate("begindate")) < 0 || bookedDate.compareTo(periodDynOnVch.getDate("enddate")) > 0 || bookDynOnVch.getLong("periodtype.id") != periodDynOnVch.getLong("periodtype.id")) {
            return result.setErrorMsg(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0e\u671f\u95f4\u4e0d\u7b26\u3002", (String)"PeriodValidator_6", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        Date bizDate = vchDynWrapper.getBizDate();
        if ((bizDate = DateUtil.makeDateOnDayStrart((Date)bizDate)).after(bookedDate)) {
            return result.setErrorMsg(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f%1$s\u665a\u4e8e\u8bb0\u8d26\u65e5\u671f%2$s\u3002", (String)"PeriodValidator_7", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), voucherContext.getSimpleDateFormat().format(bizDate), voucherContext.getSimpleDateFormat().format(bookedDate)));
        }
        vchDynWrapper.set("bookeddate", bookedDate);
        vchDynWrapper.setBizDate(bizDate);
        if (vchDynWrapper.getDate("createtime") == null) {
            vchDynWrapper.set("createtime", new Date());
        }
        return result;
    }
}

