/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate.entry;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.ext.fi.accountref.AccountVersionReplaceParam;
import kd.bos.ext.fi.accountref.AssGrpDefaultVal;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.validate.bigdata.ValidateResult;
import kd.fi.gl.voucher.validate.AccountWrapper;
import kd.fi.gl.voucher.validate.CfMainItemWrapper;
import kd.fi.gl.voucher.validate.VchDynWrapper;
import kd.fi.gl.voucher.validate.VchEntryWrapper;
import kd.fi.gl.voucher.validate.VchExtDataEntityWrapper;
import kd.fi.gl.voucher.validate.VoucherContext;
import kd.fi.gl.voucher.validate.VoucherRowWrapper;
import kd.fi.gl.voucher.validate.entry.IVchEntryValidator;
import kd.fi.gl.wrap.DynWrapper;

public class AccountInitValidator
implements IVchEntryValidator {
    @Override
    public boolean cancelValidate(ValidateResult vchValidateResult) {
        return !vchValidateResult.isSuccess();
    }

    @Override
    public ValidateResult validate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper vchEntryWrapper, VoucherContext voucherContext) {
        ValidateResult result = ValidateResult.create();
        AccountWrapper account = vchEntryWrapper.getAccount();
        if (account == null) {
            return result.setErrorMsg(ResManager.loadKDString((String)"\u79d1\u76ee\u672a\u586b\u5199", (String)"AccountInitValidator_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        Optional<String> error = AccountInitValidator.updateAccountVersion(vchExtDataEntityWrapper, vchEntryWrapper, voucherContext);
        if (error.isPresent()) {
            return result.setErrorMsg(error.get());
        }
        account = (AccountWrapper)((Object)voucherContext.getAccCache().get(Long.valueOf(vchEntryWrapper.getAccId())));
        if (!account.isLeaf()) {
            return result.setErrorMsg(ResManager.loadKDString((String)"\u975e\u660e\u7ec6\u7ea7\u79d1\u76ee\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"AccountInitValidator_2", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        if (!vchExtDataEntityWrapper.isBudget() && account.isBudget()) {
            return result.setErrorMsg(ResManager.loadKDString((String)"\u6b64\u8d26\u7c3f\u672a\u5f00\u542f\u9884\u7b97\u4f1a\u8ba1\uff0c\u65e0\u6cd5\u5f55\u5165\u9884\u7b97\u79d1\u76ee\u3002", (String)"VoucherSaveValidator_21", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        this.cacheForBalCalculate(account.getId(), account.getAccountTable(), account.isPl());
        vchEntryWrapper.setAccount(account);
        CfMainItemWrapper cfMainItemWrapper = (CfMainItemWrapper)((Object)voucherContext.getCfMainItemCache().get(Long.valueOf(vchEntryWrapper.getCfMainItemId())));
        vchEntryWrapper.setCfMainItem(cfMainItemWrapper);
        if (account.isAccheck()) {
            voucherContext.setExistsCurrentAccount(true);
            voucherContext.addCurrentAccount(account.getMasterId());
        }
        return result;
    }

    @Override
    public ValidateResult validate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper vchEntryWrapper, VoucherRowWrapper vchRowWrapper, VoucherContext voucherContext) {
        if (vchEntryWrapper != null) {
            return this.validate(vchExtDataEntityWrapper, vchEntryWrapper, voucherContext);
        }
        ValidateResult result = ValidateResult.create();
        Row row = vchRowWrapper.getRow();
        long accId = row.getLong(7);
        if (accId == 0L) {
            return result.setErrorMsg(ResManager.loadKDString((String)"\u79d1\u76ee\u672a\u586b\u5199", (String)"AccountInitValidator_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        AccountWrapper account = (AccountWrapper)((Object)voucherContext.getAccCache().get(Long.valueOf(accId)));
        if (!account.isLeaf()) {
            return result.setErrorMsg(ResManager.loadKDString((String)"\u975e\u660e\u7ec6\u7ea7\u79d1\u76ee\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"AccountInitValidator_2", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        if (!vchExtDataEntityWrapper.isBudget() && account.isBudget()) {
            return result.setErrorMsg(ResManager.loadKDString((String)"\u6b64\u8d26\u7c3f\u672a\u5f00\u542f\u9884\u7b97\u4f1a\u8ba1\uff0c\u65e0\u6cd5\u5f55\u5165\u9884\u7b97\u79d1\u76ee\u3002", (String)"VoucherSaveValidator_21", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        this.cacheForBalCalculate(accId, account.getAccountTable(), account.isPl());
        vchRowWrapper.setAccount(account);
        CfMainItemWrapper cfMainItemWrapper = (CfMainItemWrapper)((Object)voucherContext.getCfMainItemCache().get(row.getLong(14)));
        vchRowWrapper.setCfMainItem(cfMainItemWrapper);
        if (account.isAccheck()) {
            voucherContext.addCurrentAccount(account.getMasterId());
        }
        return result;
    }

    private static Optional<String> updateAccountVersion(VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper vchEntryWrapper, VoucherContext voucherContext) {
        long curAccountTableId;
        AccountWrapper account = vchEntryWrapper.getAccount();
        long accountTableId = account.getLong("accounttable_id");
        boolean isTableVersion = accountTableId != (curAccountTableId = vchExtDataEntityWrapper.getAccountTable().getAcctTableID().longValue());
        VchDynWrapper vchDynWrapper = vchExtDataEntityWrapper.getVchDynWrapper();
        boolean reverse = vchDynWrapper.isReverse();
        DynWrapper periodDyn = vchDynWrapper.getPeriod();
        long orgId = vchDynWrapper.getOrgId();
        long periodId = vchDynWrapper.getPeriodId();
        AccountVersionReplaceParam param = new AccountVersionReplaceParam(orgId, account.getLong("masterid"), accountTableId, curAccountTableId, null, periodDyn.getDyn(), vchDynWrapper.getBookTypeId(), account.getDyn(), 0L);
        String accountKey = AccountRefUtils.getVersonKey((Object[])new Object[]{orgId, account.getLong("masterid"), periodId});
        Map<String, DynamicObject> accountReplaceMap = voucherContext.getAccountVersionUpdateCache();
        DynamicObject accountInfo = null;
        if (accountReplaceMap != null) {
            accountInfo = accountReplaceMap.get(accountKey);
        } else {
            accountReplaceMap = new HashMap<String, DynamicObject>(10);
            voucherContext.setAccountVersionUpdateCache(accountReplaceMap);
        }
        if (isTableVersion || !reverse && AccountRefUtils.checkDate((DynamicObject)account.getDyn(), (Date)periodDyn.getDate("enddate")) && !vchExtDataEntityWrapper.isCarryOverVch()) {
            AssGrpDefaultVal tableVersonDefaultAssgrp = null;
            if (Objects.isNull(accountInfo)) {
                if (isTableVersion) {
                    tableVersonDefaultAssgrp = param.getAssgrpDefVal();
                }
                try {
                    accountInfo = AccountRefUtils.getCurVersionAccount((AccountVersionReplaceParam)param);
                }
                catch (KDBizException e) {
                    Optional accNumber = AccountRefUtils.getAccountNumber((AccountVersionReplaceParam)param);
                    Object accountNumber = accNumber.isPresent() ? accNumber.get() : Long.valueOf(account.getLong("masterid"));
                    return Optional.of(String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u627e\u4e0d\u5230\u7f16\u7801\u4e3a\uff1a%s\u7684\u79d1\u76ee\u6570\u636e\u3002", (String)"AccountInitValidator_1", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), accountNumber));
                }
            }
            DynamicObject assgrpReplace = null;
            if (account.getBoolean("isassist") && accountInfo.getBoolean("isassist")) {
                DynamicObject dynamicObject = assgrpReplace = vchEntryWrapper.getFlexObj() == null ? null : vchEntryWrapper.getFlexObj().getDyn();
                if (assgrpReplace == null) {
                    assgrpReplace = AccountRefUtils.createNewFlex();
                }
                Map<String, DynamicObject> assgrpReplaceMap = voucherContext.getFlexValueUpdateCache();
                AccountRefUtils.getAssgrpReplace((DynamicObject)assgrpReplace, (DynamicObject)accountInfo, (long)orgId, (long)account.getLong("masterid"), assgrpReplaceMap, (AssGrpDefaultVal)tableVersonDefaultAssgrp, (long)vchDynWrapper.getPeriodId());
            }
            vchEntryWrapper.setDynamicObject("account", accountInfo);
            if (assgrpReplace == null || assgrpReplace.getLong("id") == 0L) {
                vchEntryWrapper.setDynamicObject("assgrp", null);
            } else {
                vchEntryWrapper.setDynamicObject("assgrp", assgrpReplace);
            }
        }
        return Optional.empty();
    }

    private void cacheForBalCalculate(long accId, long accTabId, boolean isPl) {
        Map accIdInfoCache = (Map)ThreadCache.get((Object)"BalanceUpdateUtil_acc_map", () -> new HashMap(128));
        if (!accIdInfoCache.containsKey(accId)) {
            accIdInfoCache.put(accId, new Tuple2((Object)accTabId, (Object)isPl));
        }
    }
}

