/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate.entry;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.gl.business.vo.voucher.Amount;
import kd.fi.gl.business.vo.voucher.AmountField;
import kd.fi.gl.business.vo.voucher.IVoucherEntry;
import kd.fi.gl.enums.GLBillParamEnum;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.validate.bigdata.ValidateResult;
import kd.fi.gl.voucher.validate.VchEntryWrapper;
import kd.fi.gl.voucher.validate.VchExtDataEntityWrapper;
import kd.fi.gl.voucher.validate.VoucherContext;
import kd.fi.gl.voucher.validate.VoucherRowWrapper;
import kd.fi.gl.voucher.validate.entry.IVchEntryValidator;

public class EntryAmountValidator
implements IVchEntryValidator {
    @Override
    public ValidateResult validate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper vchEntryWrapper, VoucherContext voucherContext) {
        return this.doValidate(vchExtDataEntityWrapper, vchEntryWrapper, vchEntryWrapper.getDebitLocAmt(), vchEntryWrapper.getCreditLocAmt(), vchEntryWrapper.getDebitOriAmt(), vchEntryWrapper.getCreditOriAmt(), vchEntryWrapper.getBigDecimal("quantity"));
    }

    @Override
    public ValidateResult validate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper vchEntryWrapper, VoucherRowWrapper vchRowWrapper, VoucherContext voucherContext) {
        if (vchEntryWrapper != null) {
            return this.validate(vchExtDataEntityWrapper, vchEntryWrapper, voucherContext);
        }
        return this.doValidate(vchExtDataEntityWrapper, vchRowWrapper, vchRowWrapper.getDebitLocAmt(), vchRowWrapper.getCreditLocAmt(), vchRowWrapper.getDebitOriAmt(), vchRowWrapper.getCreditOriAmt(), vchRowWrapper.getBigDecimal(19));
    }

    private ValidateResult doValidate(VchExtDataEntityWrapper vchExtDataEntityWrapper, IVoucherEntry entry, BigDecimal localDebit, BigDecimal localCredit, BigDecimal originalDebit, BigDecimal originalCredit, BigDecimal quantity) {
        boolean isOriginalNonValue;
        boolean isCredit;
        Map<AmountField, Amount> localAmounts = vchExtDataEntityWrapper.getLocalAmountFields().stream().collect(Collectors.toMap(x -> x, arg_0 -> ((IVoucherEntry)entry).getAmount(arg_0)));
        if (EntryAmountValidator.isEmptyEntry(localDebit, localCredit, originalDebit, originalCredit, quantity) && EntryAmountValidator.isEmptyEntry((BigDecimal[])localAmounts.values().stream().flatMap(x -> Stream.of(x.getDebit(), x.getCredit())).toArray(BigDecimal[]::new))) {
            if (this.emptyEntrySubmittable()) {
                return ValidateResult.create();
            }
            return ValidateResult.create().setErrorMsg(ResManager.loadKDString((String)"\u6570\u91cf\u3001\u539f\u5e01\u91d1\u989d\u3001\u672c\u4f4d\u5e01\u91d1\u989d\u4e0d\u5141\u8bb8\u5168\u90e8\u4e3a\u96f6\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5f55\u5165", (String)"EntryAmountValidator_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        boolean isDebit = !EntryAmountValidator.nullOrZero(localDebit) || !EntryAmountValidator.nullOrZero(originalDebit) || localAmounts.values().stream().anyMatch(x -> !EntryAmountValidator.nullOrZero(x.getDebit()));
        boolean bl = isCredit = !EntryAmountValidator.nullOrZero(localCredit) || !EntryAmountValidator.nullOrZero(originalCredit) || localAmounts.values().stream().anyMatch(x -> !EntryAmountValidator.nullOrZero(x.getCredit()));
        if (isDebit && isCredit) {
            return ValidateResult.create().setErrorMsg(ResManager.loadKDString((String)"\u501f\u8d37\u65b9\u90fd\u6709\u503c", (String)"EntryAmountValidator_1", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        boolean isLocalNonValue = EntryAmountValidator.nullOrZero(localDebit) && EntryAmountValidator.nullOrZero(localCredit) && localAmounts.values().stream().allMatch(x -> EntryAmountValidator.nullOrZero(x.getDebit()) && EntryAmountValidator.nullOrZero(x.getCredit()));
        boolean bl2 = isOriginalNonValue = EntryAmountValidator.nullOrZero(originalDebit) && EntryAmountValidator.nullOrZero(originalCredit);
        if (!vchExtDataEntityWrapper.isAmountNonMustInput() && !isOriginalNonValue && isLocalNonValue) {
            return ValidateResult.create().setErrorMsg(ResManager.loadKDString((String)"\u539f\u5e01\u6709\u503c\uff0c\u4e0d\u5141\u8bb8\u672c\u4f4d\u5e01\u4e3a\u96f6\u3002", (String)"EntryAmountValidator_2", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        boolean validateAmountMustInput = this.validateAmountMustInput(vchExtDataEntityWrapper);
        if (validateAmountMustInput) {
            if (vchExtDataEntityWrapper.isFinalProcessVch()) {
                if (isLocalNonValue) {
                    return ValidateResult.create().setErrorMsg(ResManager.loadKDString((String)"\u672a\u52fe\u9009\u201c\u91d1\u989d\u4e3a0\u5141\u8bb8\u63d0\u4ea4\u201d\u53c2\u6570\uff0c\u8bf7\u68c0\u67e5\u672c\u4f4d\u5e01\u662f\u5426\u5f55\u5165\u3002", (String)"EntryAmountValidator_3", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
                }
            } else if (isOriginalNonValue && isLocalNonValue) {
                return ValidateResult.create().setErrorMsg(ResManager.loadKDString((String)"\u672a\u52fe\u9009\u201c\u91d1\u989d\u4e3a0\u5141\u8bb8\u63d0\u4ea4\u201d\u53c2\u6570\uff0c\u8bf7\u68c0\u67e5\u672c\u4f4d\u5e01\u548c\u539f\u5e01\u662f\u5426\u5f55\u5165\u3002", (String)"EntryAmountValidator_4", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
            }
        }
        return ValidateResult.create();
    }

    private boolean validateAmountMustInput(VchExtDataEntityWrapper vchExtDataEntityWrapper) {
        return !vchExtDataEntityWrapper.isAmountNonMustInput() && !vchExtDataEntityWrapper.getVchDynWrapper().isReverse() && !vchExtDataEntityWrapper.isFinalProcessVch();
    }

    private boolean emptyEntrySubmittable() {
        return GLBillParamEnum.EMPTY_ENTRY_SUBMITTABLE.getBooleanValue();
    }

    private static boolean isEmptyEntry(BigDecimal ... allValues) {
        if (allValues == null || allValues.length == 0) {
            return true;
        }
        return Arrays.stream(allValues).allMatch(EntryAmountValidator::nullOrZero);
    }

    private static boolean nullOrZero(BigDecimal bigDecimal) {
        return bigDecimal == null || bigDecimal.signum() == 0;
    }
}

