/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate.entry;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.VoucherEntriesSummary;
import kd.fi.gl.validate.bigdata.ValidateResult;
import kd.fi.gl.voucher.util.LocalAmountAggregator;
import kd.fi.gl.voucher.validate.VchExtDataEntityWrapper;
import kd.fi.gl.voucher.validate.VoucherContext;
import kd.fi.gl.voucher.validate.VoucherValidateMsgFormatter;
import kd.fi.gl.voucher.validate.entry.IVchEntriesSummaryValidator;
import kd.fi.gl.voucher.validate.entry.amountKey.ISumKey;

public class LocAmountTotalValidator
implements IVchEntriesSummaryValidator {
    @Override
    public boolean isEnable(VchExtDataEntityWrapper vchExtDataEntityWrapper, VoucherContext voucherContext) {
        long orgId = vchExtDataEntityWrapper.getOrgId();
        return !vchExtDataEntityWrapper.isExistsOffBalanceSheetAccount() || (Boolean)voucherContext.getOffSheetAccountValidateConfigCache().get((Object)orgId) != false;
    }

    @Override
    public ValidateResult validate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VoucherContext voucherContext) {
        ValidateResult result = ValidateResult.create();
        VoucherEntriesSummary voucherEntriesSummary = vchExtDataEntityWrapper.getVoucherEntriesSummary();
        ArrayList<String> errors = new ArrayList<String>(2);
        voucherEntriesSummary.getDebitLocTotal().differenceWith(voucherEntriesSummary.getCreditLocTotal(), vchExtDataEntityWrapper.getVchDynWrapper().getLocCurAmtPrecision()).ifPresent(triple -> {
            String description = ((ISumKey)triple.getLeft()).getDescription(vchExtDataEntityWrapper, voucherContext);
            errors.add(String.format(ResManager.loadKDString((String)"%1$s\u672c\u4f4d\u5e01\u501f\u8d37\u4e0d\u76f8\u7b49\uff0c\u501f\u65b9\u91d1\u989d%2$s\uff0c\u8d37\u65b9\u91d1\u989d%3$s\uff0c\u5dee\u5f02\u91d1\u989d%4$s\u3002", (String)"LocAmountTotalValidator_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), description, ((BigDecimal)triple.getMiddle()).toPlainString(), ((BigDecimal)triple.getRight()).toPlainString(), ((BigDecimal)triple.getMiddle()).subtract((BigDecimal)triple.getRight())));
        });
        List<LocalAmountAggregator> amountAggregators = vchExtDataEntityWrapper.getLocalAmtAggregators();
        for (LocalAmountAggregator amountAggregator : amountAggregators) {
            amountAggregator.getDebitTotal().differenceWith(amountAggregator.getCreditTotal(), amountAggregator.getAmtPrecision()).ifPresent(triple -> {
                String description = ((ISumKey)triple.getLeft()).getDescription(vchExtDataEntityWrapper, voucherContext);
                errors.add(String.format(ResManager.loadKDString((String)"%1$s%2$s\u501f\u8d37\u4e0d\u76f8\u7b49\uff0c\u501f\u65b9\u91d1\u989d%3$s\uff0c\u8d37\u65b9\u91d1\u989d%4$s\uff0c\u5dee\u5f02\u91d1\u989d%5$s", (String)"LocAmountTotalValidator_1", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), description, amountAggregator.getField().getCurrencyField().getDesc(), ((BigDecimal)triple.getMiddle()).toPlainString(), ((BigDecimal)triple.getRight()).toPlainString(), ((BigDecimal)triple.getMiddle()).subtract((BigDecimal)triple.getRight())));
            });
        }
        if (!errors.isEmpty()) {
            result.setErrorMsg(VoucherValidateMsgFormatter.get().join(errors));
        }
        return result;
    }
}

