/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate.entry;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.cache.CacheKey;
import kd.fi.gl.cache.CacheKeyPrefix;
import kd.fi.gl.cache.LocalCacheHelper;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.validate.bigdata.ValidateResult;
import kd.fi.gl.voucher.validate.VchExtDataEntityWrapper;
import kd.fi.gl.voucher.validate.VoucherContext;
import kd.fi.gl.voucher.validate.entry.IVchEntriesSummaryValidator;
import kd.fi.gl.wrap.DynWrapper;

public class VoucherTypeControlValidator
implements IVchEntriesSummaryValidator {
    @Override
    public ValidateResult validate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VoucherContext voucherContext) {
        DynamicObject conInf;
        DynamicObject accountTable;
        ValidateResult result = ValidateResult.create();
        DynWrapper voucherType = vchExtDataEntityWrapper.getVchDynWrapper().getVoucherType();
        boolean isLimit = voucherType.getBoolean("islimitmultdc");
        int[] entryCountWithDc = vchExtDataEntityWrapper.getEntryCountWithDc();
        if (isLimit && entryCountWithDc[0] > 1 && entryCountWithDc[1] > 1) {
            return result.setErrorMsg(ResManager.loadKDString((String)"\u5f53\u524d\u51ed\u8bc1\u7c7b\u578b\u4e0d\u652f\u6301\u751f\u6210\u591a\u501f\u591a\u8d37\u7684\u51ed\u8bc1\u3002", (String)"VoucherTypeControlValidator_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        long orgId = vchExtDataEntityWrapper.getOrgId();
        long voucherTypeMasterId = vchExtDataEntityWrapper.getVchDynWrapper().getVoucherTypeMasterId();
        long curAccountTableId = vchExtDataEntityWrapper.getAccountTable().getAcctTableID();
        DynamicObject controlInformation = this.loadControlInfo(orgId, voucherTypeMasterId, curAccountTableId);
        if (controlInformation != null && (accountTable = (conInf = BusinessDataServiceHelper.loadSingle((Object)controlInformation.getLong("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_controlinformation"))).getDynamicObject("accounttable")) != null && accountTable.getLong("id") == curAccountTableId) {
            ArrayList<String> creditUseAccounts;
            List<String> debitUseAccounts;
            List<String> creditnotUseAccounts;
            List<String> debitnotUseAccounts;
            List<String> creditmustUseAccounts;
            List<String> debitmustUseAccounts;
            DynamicObjectCollection debitmustrecord = conInf.getDynamicObjectCollection("debitmustrecord");
            DynamicObjectCollection creditmustrecord = conInf.getDynamicObjectCollection("creditmustrecord");
            DynamicObjectCollection debitnotrecord = conInf.getDynamicObjectCollection("debitnotrecord");
            DynamicObjectCollection creditnotrecord = conInf.getDynamicObjectCollection("creditnotrecord");
            DynamicObjectCollection debitorcreditmustrecord = conInf.getDynamicObjectCollection("debitorcreditmustrecord");
            DynamicObjectCollection debitandcreditnotrecord = conInf.getDynamicObjectCollection("debitandcreditnotrecord");
            QFilter acctFilter = AccountUtils.getAccountDataFilter((long)orgId, (long)accountTable.getLong("id"));
            int acctCount = 0;
            if (null != acctFilter) {
                ORM orm = ORM.create();
                acctCount = orm.count(this.getClass().getName(), "bd_accountview", new QFilter[]{acctFilter});
            }
            if (acctCount == 0) {
                return result.setErrorMsg(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u53ef\u4f7f\u7528\u79d1\u76ee\u3002", (String)"VoucherTypeControlValidator_1", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
            }
            Set<String> debitNumbers = vchExtDataEntityWrapper.getDebitAccNumSet();
            Set<String> creditNumbers = vchExtDataEntityWrapper.getCreditAccNumSet();
            List<String> numList = this.getAccountNum(acctFilter);
            if (debitmustrecord != null && !debitmustrecord.isEmpty() && (debitmustUseAccounts = this.getUseAccount(debitmustrecord, numList)) != null) {
                debitmustUseAccounts.retainAll(debitNumbers);
                if (debitmustUseAccounts.isEmpty()) {
                    return result.setErrorMsg(ResManager.loadKDString((String)"\u79d1\u76ee\u4e0d\u6ee1\u8db3\u51ed\u8bc1\u7c7b\u578b\u501f\u65b9\u5fc5\u6709\u9879\u3002", (String)"VoucherTypeControlValidator_2", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
                }
            }
            if (creditmustrecord != null && !creditmustrecord.isEmpty() && (creditmustUseAccounts = this.getUseAccount(creditmustrecord, numList)) != null) {
                creditmustUseAccounts.retainAll(creditNumbers);
                if (creditmustUseAccounts.isEmpty()) {
                    return result.setErrorMsg(ResManager.loadKDString((String)"\u79d1\u76ee\u4e0d\u6ee1\u8db3\u51ed\u8bc1\u7c7b\u578b\u8d37\u65b9\u5fc5\u6709\u9879\u3002", (String)"VoucherTypeControlValidator_3", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
                }
            }
            if (debitnotrecord != null && !debitnotrecord.isEmpty() && (debitnotUseAccounts = this.getUseAccount(debitnotrecord, numList)) != null) {
                debitnotUseAccounts.retainAll(debitNumbers);
                if (!debitnotUseAccounts.isEmpty()) {
                    return result.setErrorMsg(ResManager.loadKDString((String)"\u79d1\u76ee\u4e0d\u6ee1\u8db3\u51ed\u8bc1\u7c7b\u578b\u501f\u65b9\u5fc5\u65e0\u9879\u3002", (String)"VoucherTypeControlValidator_4", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
                }
            }
            if (creditnotrecord != null && !creditnotrecord.isEmpty() && (creditnotUseAccounts = this.getUseAccount(creditnotrecord, numList)) != null) {
                creditnotUseAccounts.retainAll(creditNumbers);
                if (!creditnotUseAccounts.isEmpty()) {
                    return result.setErrorMsg(ResManager.loadKDString((String)"\u79d1\u76ee\u4e0d\u6ee1\u8db3\u51ed\u8bc1\u7c7b\u578b\u8d37\u65b9\u5fc5\u65e0\u9879\u3002", (String)"VoucherTypeControlValidator_5", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
                }
            }
            if (debitorcreditmustrecord != null && !debitorcreditmustrecord.isEmpty() && (debitUseAccounts = this.getUseAccount(debitorcreditmustrecord, numList)) != null) {
                creditUseAccounts = new ArrayList<String>(debitUseAccounts);
                creditUseAccounts.retainAll(creditNumbers);
                debitUseAccounts.retainAll(debitNumbers);
                if (creditUseAccounts.isEmpty() && debitUseAccounts.isEmpty()) {
                    return result.setErrorMsg(ResManager.loadKDString((String)"\u79d1\u76ee\u4e0d\u6ee1\u8db3\u51ed\u8bc1\u7c7b\u578b\u501f\u6216\u8d37\u5fc5\u6709\u9879\u3002", (String)"VoucherTypeControlValidator_6", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
                }
            }
            if (debitandcreditnotrecord != null && !debitandcreditnotrecord.isEmpty() && (debitUseAccounts = this.getUseAccount(debitandcreditnotrecord, numList)) != null) {
                creditUseAccounts = new ArrayList<String>(debitUseAccounts);
                creditUseAccounts.retainAll(creditNumbers);
                debitUseAccounts.retainAll(debitNumbers);
                if (!creditUseAccounts.isEmpty() || !debitUseAccounts.isEmpty()) {
                    return result.setErrorMsg(ResManager.loadKDString((String)"\u79d1\u76ee\u4e0d\u6ee1\u8db3\u51ed\u8bc1\u7c7b\u578b\u501f\u548c\u8d37\u5fc5\u65e0\u9879\u3002", (String)"VoucherTypeControlValidator_7", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
                }
            }
        }
        return result;
    }

    private DynamicObject loadControlInfo(Long orgId, Long voucherTypeMasterId, Long accountTableId) {
        return ((Optional)LocalCacheHelper.getIfAbsent((CacheKey)CacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.VOUCHER_TYPE_CONTROL, (Object[])new Object[]{orgId, voucherTypeMasterId, accountTableId}), Optional.class, () -> {
            List voucherTypeIds = GLUtil.getIdsByMasterId((Long)voucherTypeMasterId);
            DynamicObject controlInfoDyn = GLUtil.getControlMsg((Long)orgId, (List)voucherTypeIds);
            if (controlInfoDyn == null) {
                controlInfoDyn = GLUtil.getParentsControl((Long)orgId, (List)voucherTypeIds, (Long)accountTableId);
            }
            return Optional.ofNullable(controlInfoDyn);
        })).orElse(null);
    }

    private List<String> getUseAccount(DynamicObjectCollection accounts, List<String> accNumList) {
        List accountNumList = accounts.stream().map(x -> x.getString("fbasedataid.number")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        if (accountNumList.isEmpty()) {
            return null;
        }
        ArrayList<String> matchAccNumList = new ArrayList<String>(accNumList.size());
        for (String accNum : accountNumList) {
            for (String num : accNumList) {
                if (!num.startsWith(accNum)) continue;
                matchAccNumList.add(num);
            }
        }
        return matchAccNumList;
    }

    private List<String> getAccountNum(QFilter filter) {
        filter = filter.and(new QFilter("isleaf", "=", (Object)"1"));
        DynamicObjectCollection useAccounts = QueryServiceHelper.query((String)"bd_accountview", (String)"number", (QFilter[])new QFilter[]{filter});
        return useAccounts.parallelStream().map(obj -> obj.getString("number")).collect(Collectors.toList());
    }
}

