/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.file.fpy.model.ofd;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.imc.bdm.common.util.MD5;
import kd.imc.bdm.file.fpy.model.ofd.OFDDocument;
import kd.imc.bdm.file.fpy.model.ofd.OFDObject;
import kd.imc.bdm.file.fpy.model.pdf.fedi.FullDigitalEInvoice;
import kd.imc.bdm.file.fpy.service.ofd.util.CompressHelperUtils;
import kd.imc.bdm.file.fpy.service.ofd.util.XmlHelperUtils;
import kd.imc.bdm.file.util.DateUtils;
import org.dom4j.Document;
import org.dom4j.Element;

public class OFDFile
extends OFDObject {
    private final String docID = MD5.md5Hex((String)UUID.randomUUID().toString());
    Map<String, byte[]> files = new HashMap<String, byte[]>();
    private Document ofdXmlDoc = null;
    private Element bodyNode = null;
    private OFDDocument doc = null;

    public OFDFile(FullDigitalEInvoice fullDigitalEInvoice) {
        this.buildOfdInfo(fullDigitalEInvoice);
    }

    public Element getBody() {
        return this.bodyNode;
    }

    public OFDDocument getDocument() {
        return this.doc;
    }

    public OFDDocument createDocument() {
        if (this.doc == null) {
            this.doc = new OFDDocument(this);
        }
        return this.doc;
    }

    public byte[] getData() {
        return CompressHelperUtils.compress(this.files, null, "OFD");
    }

    @Override
    public String getPath() {
        return "";
    }

    public void p_AddFile(String name, byte[] byts) {
        this.files.put(name, byts);
    }

    @Override
    public void flush() throws IOException {
        String strOfdPath = "OFD.xml";
        byte[] bts = XmlHelperUtils.toByteArray(this.ofdXmlDoc);
        this.p_AddFile(strOfdPath, bts);
        this.getDocument().flush();
    }

    private void buildOfdInfo(FullDigitalEInvoice fullDigitalEInvoice) {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String dateString = formatter.format(currentTime);
        this.ofdXmlDoc = XmlHelperUtils.createDocument("ofd:OFD");
        Element root = this.ofdXmlDoc.getRootElement();
        root.addAttribute("DocType", "OFD");
        root.addAttribute("Version", "1.0");
        this.bodyNode = root.addElement("ofd:DocBody");
        Element eleDocInfo = this.bodyNode.addElement("ofd:DocInfo");
        XmlHelperUtils.addNode(eleDocInfo, "ofd:DocID", this.docID);
        XmlHelperUtils.addNode(eleDocInfo, "ofd:CreationDate", dateString);
        XmlHelperUtils.addNode(eleDocInfo, "ofd:Creator", "Kingdee");
        Element customDatas = eleDocInfo.addElement("ofd:CustomDatas");
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", "\u53d1\u7968\u53f7\u7801", fullDigitalEInvoice.getInvoiceNo());
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", "\u9500\u552e\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", fullDigitalEInvoice.getSalerTaxNo());
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", "\u5408\u8ba1\u91d1\u989d", fullDigitalEInvoice.getInvoiceAmount().toPlainString());
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", "\u8d2d\u4e70\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", fullDigitalEInvoice.getBuyerTaxNo());
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", "\u5408\u8ba1\u7a0e\u989d", fullDigitalEInvoice.getTotalTaxAmount().toPlainString());
        String invoiceDate = DateUtils.format(fullDigitalEInvoice.getIssueTime(), "yyyy\u5e74MM\u6708dd\u65e5");
        XmlHelperUtils.addNode(customDatas, "ofd:CustomData", "\u5f00\u7968\u65e5\u671f", invoiceDate);
        XmlHelperUtils.addNode(this.bodyNode, "ofd:DocRoot", "Doc_0/Document.xml");
    }
}

