/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.file.fpy.service.xml;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.dto.allelespecial.BillCoBuyerItemVo;
import kd.imc.bdm.file.fpy.enums.BusinessSectorTypeEnum;
import kd.imc.bdm.file.fpy.enums.ConsumptionTaxpayerTypeEnum;
import kd.imc.bdm.file.fpy.enums.DifferenceTaxTypeEnum;
import kd.imc.bdm.file.fpy.enums.ExportEnterpriseClassificationEnum;
import kd.imc.bdm.file.fpy.enums.InvoiceIssuanceMethodEnum;
import kd.imc.bdm.file.fpy.enums.InvoiceTypeEnum;
import kd.imc.bdm.file.fpy.enums.SpecialTypeEnum;
import kd.imc.bdm.file.fpy.enums.SpecificTaxationMethodEnum;
import kd.imc.bdm.file.fpy.enums.TaxpayerCreditGradeEnum;
import kd.imc.bdm.file.fpy.enums.TaxpayerTypeEnum;
import kd.imc.bdm.file.fpy.model.pdf.fedi.CargoTransportItem;
import kd.imc.bdm.file.fpy.model.pdf.fedi.FullDigitalEInvoiceItem;
import kd.imc.bdm.file.fpy.model.pdf.fedi.PassengerTransportItem;
import kd.imc.bdm.file.fpy.model.xml.ConstructionServicesItem;
import kd.imc.bdm.file.fpy.model.xml.FullDigitalEInvoiceXml;
import kd.imc.bdm.file.fpy.model.xml.RealEstateLeaseItem;
import kd.imc.bdm.file.fpy.model.xml.RealEstateSalesItem;
import kd.imc.bdm.file.fpy.model.xml.TaxationOfVehicleAndVesselUseTax;
import kd.imc.bdm.file.fpy.model.xml.TractorandHarvesterItem;
import kd.imc.bdm.file.fpy.service.ofd.util.XmlHelperUtils;
import kd.imc.bdm.file.fpy.util.AreaUtil;
import kd.imc.bdm.file.fpy.util.EInvoicePdfUtils;
import kd.imc.bdm.file.fpy.util.MoneyUtil;
import kd.imc.bdm.file.util.DateUtils;
import kd.imc.bdm.file.util.ErrorType;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class FullDigitalEInvoiceXmlService {
    private static Log log = LogFactory.getLog(FullDigitalEInvoiceXmlService.class);

    public byte[] createXml(FullDigitalEInvoiceXml fullDigitalEInvoiceXml) {
        byte[] standaloneByteArray;
        Date startDate = new Date();
        InvoiceTypeEnum invoiceType = InvoiceTypeEnum.getInvoiceTypeByValue(fullDigitalEInvoiceXml.getInvoiceType());
        if (invoiceType == null) {
            throw new KDBizException(new ErrorCode(ErrorType.USER_ERROR_A0420.errcode, ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u79cd\u7c7b\u4e0d\u652f\u6301\u751f\u6210XML!", (String)"FullDigitalEInvoiceXmlService_0", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
        String areaCode = EInvoicePdfUtils.getFullTaxCodeByNsrsbh(fullDigitalEInvoiceXml.getSalerTaxNo(), fullDigitalEInvoiceXml.getTaxBureauCode());
        Element eInvoiceElement = DocumentHelper.createElement((String)"EInvoice");
        Document document = DocumentHelper.createDocument((Element)eInvoiceElement);
        this.addHeader(fullDigitalEInvoiceXml, eInvoiceElement, areaCode);
        this.addEInvoiceData(fullDigitalEInvoiceXml, eInvoiceElement);
        this.addSellerAuthentication(eInvoiceElement);
        this.addTaxSupervisionInfo(fullDigitalEInvoiceXml, eInvoiceElement, areaCode);
        this.addPtbh(fullDigitalEInvoiceXml.getPtbh(), eInvoiceElement);
        try {
            standaloneByteArray = XmlHelperUtils.toStandaloneByteArray(document);
        }
        catch (IOException e) {
            throw new KDBizException(new ErrorCode(ErrorType.SYSTEM_ERROR_B0001.errcode, ResManager.loadKDString((String)"\u751f\u6210XML\u51fa\u9519!", (String)"FullDigitalEInvoiceXmlService_1", (String)"imc-bdm-file", (Object[])new Object[0])), new Object[0]);
        }
        Date endTime = new Date();
        log.info("XML\u751f\u6210\u8017\u65f6{}", (Object)(endTime.getTime() - startDate.getTime()));
        return standaloneByteArray;
    }

    private void addHeader(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceElement, String areaCode) {
        Element headerElement = eInvoiceElement.addElement("Header");
        XmlHelperUtils.addNotEmptyNode(headerElement, "EIid", fullDigitalEInvoiceXml.getInvoiceNo());
        XmlHelperUtils.addNotEmptyNode(headerElement, "EInvoiceTag", "SWEI" + areaCode);
        XmlHelperUtils.addNotEmptyNode(headerElement, "Version", "0.3");
        this.addHeaderInHerentLabel(fullDigitalEInvoiceXml, headerElement);
        this.addHeaderUndefinedLabel(fullDigitalEInvoiceXml, headerElement);
    }

    private void addHeaderInHerentLabel(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element headerElement) {
        Element inherentLabelElement = headerElement.addElement("InherentLabel");
        String inIssueType = fullDigitalEInvoiceXml.getTotalAmount().compareTo(BigDecimal.ZERO) >= 0 ? "Y" : "N";
        XmlHelperUtils.addLabelByKey(inherentLabelElement, "InIssuType", null, inIssueType, "\u662f\u5426\u84dd\u5b57\u53d1\u7968\u6807\u5fd7");
        SpecialTypeEnum specialType = SpecialTypeEnum.getSpecialTypeByValue(fullDigitalEInvoiceXml.getSpecialType());
        String invoiceType = "01";
        String invoiceName = "\u7535\u5b50\u53d1\u7968";
        if (SpecialTypeEnum.MOTOR_VEHICLE == specialType) {
            invoiceType = "02";
            invoiceName = "\u673a\u52a8\u8f66\u9500\u552e\u7535\u5b50\u7edf\u4e00\u53d1\u7968";
        } else if (SpecialTypeEnum.USED_CAR == specialType) {
            invoiceType = "03";
            invoiceName = "\u4e8c\u624b\u8f66\u9500\u552e\u7535\u5b50\u7edf\u4e00\u53d1\u7968";
        }
        XmlHelperUtils.addLabelByKey(inherentLabelElement, "EInvoiceType", null, invoiceType, invoiceName);
        String billType = "01";
        String billName = "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968";
        InvoiceTypeEnum invoiceTypeEnum = InvoiceTypeEnum.getInvoiceTypeByValue(fullDigitalEInvoiceXml.getInvoiceType());
        if (InvoiceTypeEnum.ORDINARY_INVOICE == invoiceTypeEnum) {
            billType = "02";
            billName = "\u666e\u901a\u53d1\u7968";
        } else if (SpecialTypeEnum.MOTOR_VEHICLE == specialType) {
            billType = "03";
            billName = "\u673a\u52a8\u8f66\u7edf\u4e00\u9500\u552e\u53d1\u7968";
        } else if (SpecialTypeEnum.USED_CAR == specialType) {
            billType = "04";
            billName = "\u4e8c\u624b\u8f66\u7edf\u4e00\u9500\u552e\u53d1\u7968";
        }
        XmlHelperUtils.addLabelByKey(inherentLabelElement, "GeneralOrSpecialVAT", null, billType, billName);
        TaxpayerTypeEnum taxpayerType = TaxpayerTypeEnum.getTaxpayerTypeEnumByValue(fullDigitalEInvoiceXml.getTaxpayerType());
        if (taxpayerType != null) {
            XmlHelperUtils.addLabelByKey(inherentLabelElement, "TaxpayerType", null, taxpayerType.getValue(), taxpayerType.getMsg());
        }
    }

    private void addHeaderUndefinedLabel(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element headerElement) {
        TaxpayerCreditGradeEnum taxpayerCreditGrade;
        DifferenceTaxTypeEnum differenceTaxType;
        String specificTaxationMethod;
        String specificTaxationMethodMsg;
        ExportEnterpriseClassificationEnum exportEnterpriseClassification;
        String consumptionTaxpayerType;
        String consumptionTaxpayerTypeMsg;
        InvoiceIssuanceMethodEnum invoiceIssuanceMethodEnum;
        Element undefinedLabelElement = headerElement.addElement("UndefinedLabel");
        String businessSectorTypeValue = fullDigitalEInvoiceXml.getBusinessSectorType();
        String businessSectorTypeMsg = BusinessSectorTypeEnum.getBusinessSectorTypeMsgByValue(businessSectorTypeValue);
        if (StringUtils.isNotEmpty((CharSequence)businessSectorTypeMsg)) {
            XmlHelperUtils.addLabel(undefinedLabelElement, "\u4f01\u4e1a\u884c\u4e1a\u6027\u8d28\u7c7b\u6807\u7b7e", businessSectorTypeValue, businessSectorTypeMsg);
        }
        if ((invoiceIssuanceMethodEnum = InvoiceIssuanceMethodEnum.getinvoiceIssuanceMethodEnum(fullDigitalEInvoiceXml.getInvoiceIssuanceMethod())) != null) {
            XmlHelperUtils.addLabel(undefinedLabelElement, "\u53d1\u7968\u5f00\u5177\u65b9\u5f0f\u6807\u7b7e", invoiceIssuanceMethodEnum.getValue(), invoiceIssuanceMethodEnum.getMsg());
        }
        if (StringUtils.isNotEmpty((CharSequence)(consumptionTaxpayerTypeMsg = ConsumptionTaxpayerTypeEnum.getConsumptionTaxpayerTypeMsgByValue(consumptionTaxpayerType = fullDigitalEInvoiceXml.getConsumptionTaxpayerType())))) {
            XmlHelperUtils.addLabel(undefinedLabelElement, "\u6d88\u8d39\u7a0e\u7eb3\u7a0e\u4eba\u6807\u7b7e", consumptionTaxpayerType, consumptionTaxpayerTypeMsg);
        }
        if ((exportEnterpriseClassification = ExportEnterpriseClassificationEnum.getExportEnterpriseClassificationEnum(fullDigitalEInvoiceXml.getExportEnterpriseClassification())) != null) {
            XmlHelperUtils.addLabel(undefinedLabelElement, "\u51fa\u53e3\u4f01\u4e1a\u5206\u7c7b\u7ba1\u7406\u6807\u7b7e", exportEnterpriseClassification.getValue(), exportEnterpriseClassification.getMsg());
        }
        if (StringUtils.isNotEmpty((CharSequence)(specificTaxationMethodMsg = SpecificTaxationMethodEnum.getSpecificTaxationMethodMsgByValue(specificTaxationMethod = fullDigitalEInvoiceXml.getSpecificTaxationMethod())))) {
            XmlHelperUtils.addLabel(undefinedLabelElement, "\u7279\u5b9a\u5f81\u7a0e\u65b9\u5f0f\u6807\u7b7e", specificTaxationMethod, specificTaxationMethodMsg);
        }
        if ((differenceTaxType = DifferenceTaxTypeEnum.getDifferenceTaxTypeByValue(fullDigitalEInvoiceXml.getDifferenceTaxType())) != null) {
            XmlHelperUtils.addLabel(undefinedLabelElement, "\u5dee\u989d\u5f81\u7a0e\u6807\u7b7e", differenceTaxType.getValue(), differenceTaxType.getMsg());
        }
        if ((taxpayerCreditGrade = TaxpayerCreditGradeEnum.getTaxpayerCreditGradeEnumByValue(fullDigitalEInvoiceXml.getTaxpayerCreditGrade())) != null) {
            XmlHelperUtils.addLabel(undefinedLabelElement, "\u7eb3\u7a0e\u4eba\u4fe1\u7528\u7b49\u7ea7\u6807\u7b7e", taxpayerCreditGrade.getValue(), taxpayerCreditGrade.getMsg());
        }
    }

    private void addEInvoiceData(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceElement) {
        Element eInvoiceDataElement = eInvoiceElement.addElement("EInvoiceData");
        this.addSellerInfo(fullDigitalEInvoiceXml, eInvoiceDataElement);
        this.addBuyerInfo(fullDigitalEInvoiceXml, eInvoiceDataElement);
        this.addBasicInformation(fullDigitalEInvoiceXml, eInvoiceDataElement);
        this.addIssuItemInformation(fullDigitalEInvoiceXml, eInvoiceDataElement);
        this.addSpecificInformation(fullDigitalEInvoiceXml, eInvoiceDataElement);
        this.addAdditionalInformation(fullDigitalEInvoiceXml, eInvoiceDataElement);
    }

    private void addSellerInfo(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceDataElement) {
        Element sellerInformationElement = eInvoiceDataElement.addElement("SellerInformation");
        XmlHelperUtils.addNotEmptyNode(sellerInformationElement, "SellerIdNum", fullDigitalEInvoiceXml.getSalerTaxNo());
        XmlHelperUtils.addNotEmptyNode(sellerInformationElement, "SellerName", fullDigitalEInvoiceXml.getSalerName());
        XmlHelperUtils.addNotEmptyNode(sellerInformationElement, "SellerAddr", fullDigitalEInvoiceXml.getSalerAddr());
        XmlHelperUtils.addNotEmptyNode(sellerInformationElement, "SellerTelNum", fullDigitalEInvoiceXml.getSalerTelNum());
        XmlHelperUtils.addNotEmptyNode(sellerInformationElement, "SellerBankName", fullDigitalEInvoiceXml.getSalerBankName());
        XmlHelperUtils.addNotEmptyNode(sellerInformationElement, "SellerBankAccNum", fullDigitalEInvoiceXml.getSalerBankAccNum());
    }

    private void addBuyerInfo(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceDataElement) {
        Element buyerInformationElement = eInvoiceDataElement.addElement("BuyerInformation");
        XmlHelperUtils.addNotEmptyNode(buyerInformationElement, "BuyerIdNum", fullDigitalEInvoiceXml.getBuyerTaxNo());
        XmlHelperUtils.addNotEmptyNode(buyerInformationElement, "BuyerName", fullDigitalEInvoiceXml.getBuyerName());
        XmlHelperUtils.addNotEmptyNode(buyerInformationElement, "BuyerAddr", fullDigitalEInvoiceXml.getBuyerAddr());
        XmlHelperUtils.addNotEmptyNode(buyerInformationElement, "BuyerTelNum", fullDigitalEInvoiceXml.getBuyerTelNum());
        XmlHelperUtils.addNotEmptyNode(buyerInformationElement, "BuyerBankName", fullDigitalEInvoiceXml.getBuyerBankName());
        XmlHelperUtils.addNotEmptyNode(buyerInformationElement, "BuyerBankAccNum", fullDigitalEInvoiceXml.getBuyerBankAccNum());
        XmlHelperUtils.addNotEmptyNode(buyerInformationElement, "BuyerHandlingName", fullDigitalEInvoiceXml.getBuyerHandlingName());
    }

    private void addBasicInformation(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceDataElement) {
        Element basicInformationElement = eInvoiceDataElement.addElement("BasicInformation");
        XmlHelperUtils.addNotEmptyNode(basicInformationElement, "TotalAmWithoutTax", EInvoicePdfUtils.getPriceWithScale(fullDigitalEInvoiceXml.getInvoiceAmount()));
        XmlHelperUtils.addNotEmptyNode(basicInformationElement, "TotalTaxAm", EInvoicePdfUtils.getPriceWithScale(fullDigitalEInvoiceXml.getTotalTaxAmount()));
        XmlHelperUtils.addNotEmptyNode(basicInformationElement, "TotalTax-includedAmount", EInvoicePdfUtils.getPriceWithScale(fullDigitalEInvoiceXml.getTotalAmount()));
        XmlHelperUtils.addNotEmptyNode(basicInformationElement, "TotalTax-includedAmountInChinese", MoneyUtil.moneyCapital(EInvoicePdfUtils.getPriceWithScale(fullDigitalEInvoiceXml.getTotalAmount())));
        XmlHelperUtils.addNotEmptyNode(basicInformationElement, "Drawer", fullDigitalEInvoiceXml.getDrawer());
        XmlHelperUtils.addNotEmptyNode(basicInformationElement, "RequestTime", DateUtils.format(fullDigitalEInvoiceXml.getIssueTime(), "yyyy-MM-dd HH:mm:ss"));
    }

    private void addIssuItemInformation(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceDataElement) {
        List<FullDigitalEInvoiceItem> itemList = fullDigitalEInvoiceXml.getItemList();
        if (itemList != null && !itemList.isEmpty()) {
            for (FullDigitalEInvoiceItem item : itemList) {
                Element itemInformation = eInvoiceDataElement.addElement("IssuItemInformation");
                XmlHelperUtils.addNotEmptyNode(itemInformation, "ItemName", item.getGoodsName());
                XmlHelperUtils.addNotEmptyNode(itemInformation, "SpecMod", item.getSpecModel());
                XmlHelperUtils.addNotEmptyNode(itemInformation, "MeaUnits", item.getUnit());
                XmlHelperUtils.addNotEmptyNode(itemInformation, "Quantity", EInvoicePdfUtils.getBigDecimalStr(item.getNum()));
                XmlHelperUtils.addNotEmptyNode(itemInformation, "UnPrice", EInvoicePdfUtils.getBigDecimalStr(item.getUnitPrice()));
                XmlHelperUtils.addNotEmptyNode(itemInformation, "Amount", EInvoicePdfUtils.getBigDecimalStr(item.getDetailAmount()));
                XmlHelperUtils.addNotEmptyNode(itemInformation, "TaxRate", EInvoicePdfUtils.getBigDecimalStr(item.getTaxRate()));
                XmlHelperUtils.addNotEmptyNode(itemInformation, "ComTaxAm", EInvoicePdfUtils.getBigDecimalStr(item.getTaxAmount()));
                XmlHelperUtils.addNotEmptyNode(itemInformation, "TotaltaxIncludedAmount", EInvoicePdfUtils.getBigDecimalStr(item.getDetailAmount().add(item.getTaxAmount())));
                XmlHelperUtils.addNotEmptyNode(itemInformation, "TaxClassificationCode", item.getClassificationCode());
            }
        }
    }

    private void addSpecificInformation(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceDataElement) {
        SpecialTypeEnum specialType = SpecialTypeEnum.getSpecialTypeByValue(fullDigitalEInvoiceXml.getSpecialType());
        if (SpecialTypeEnum.CONSTRUCTION_SERVICE == specialType) {
            this.addConstructionServices(fullDigitalEInvoiceXml.getConstructionServicesItem(), eInvoiceDataElement);
        } else if (SpecialTypeEnum.CARGO_TRANSPORT_SERVICE == specialType) {
            this.addFreightService(fullDigitalEInvoiceXml.getCargoTransportList(), eInvoiceDataElement);
        } else if (SpecialTypeEnum.PASSENGER_TRANSPORT == specialType) {
            this.addPassengerTransportation(fullDigitalEInvoiceXml.getTravelerList(), eInvoiceDataElement);
        } else if (SpecialTypeEnum.SALE_OF_REAL_ESTATE == specialType) {
            this.addSaleOfRealEstate(fullDigitalEInvoiceXml.getRealEstateSalesItems(), eInvoiceDataElement, fullDigitalEInvoiceXml.getCoBuyerItems());
        } else if (SpecialTypeEnum.REAL_ESTATE_OPERATING_LEASE == specialType) {
            this.addRealEstateOperatingLease(fullDigitalEInvoiceXml.getRealEstateLeasingItem(), eInvoiceDataElement);
        } else if (SpecialTypeEnum.COLLECT_VEHICLE_AND_SHIP_TAXES == specialType) {
            this.addTaxationOfVehicleAndVesselUseTax(fullDigitalEInvoiceXml.getTaxationOfVehicleAndVesselUseTax(), eInvoiceDataElement);
        } else if (SpecialTypeEnum.TRACTORS_AND_COMBINE_HARVESTERS == specialType) {
            this.addTractorandHarvesterItem(fullDigitalEInvoiceXml.getTractorandHarvesterItem(), eInvoiceDataElement);
        }
        this.addSpecialDifferentialTaxation(fullDigitalEInvoiceXml, eInvoiceDataElement);
        this.addSpecialRedEInvoice(fullDigitalEInvoiceXml, eInvoiceDataElement);
    }

    private void addSpecialDifferentialTaxation(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceDataElement) {
        DifferenceTaxTypeEnum differenceTaxType = DifferenceTaxTypeEnum.getDifferenceTaxTypeByValue(fullDigitalEInvoiceXml.getDifferenceTaxType());
        if (differenceTaxType != null && (StringUtils.isNotEmpty((CharSequence)fullDigitalEInvoiceXml.getDeduction()) || StringUtils.isNotEmpty((CharSequence)fullDigitalEInvoiceXml.getSalesIncludingTax()))) {
            Element specificInformation = eInvoiceDataElement.element("SpecificInformation");
            if (specificInformation == null) {
                specificInformation = eInvoiceDataElement.addElement("SpecificInformation");
            }
            Element differentialTaxation = specificInformation.addElement("DifferentialTaxation");
            XmlHelperUtils.addNotEmptyNode(differentialTaxation, "Deduction", fullDigitalEInvoiceXml.getDeduction());
            XmlHelperUtils.addNotEmptyNode(differentialTaxation, "SalesIncludingTax", fullDigitalEInvoiceXml.getSalesIncludingTax());
        }
    }

    private void addSpecialRedEInvoice(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceDataElement) {
        boolean redInvoice;
        boolean bl = redInvoice = fullDigitalEInvoiceXml.getTotalAmount().compareTo(BigDecimal.ZERO) < 0;
        if (redInvoice && (StringUtils.isNotEmpty((CharSequence)fullDigitalEInvoiceXml.getOriginalInvoiceCode()) || StringUtils.isNotEmpty((CharSequence)fullDigitalEInvoiceXml.getCreditNoteNumber()))) {
            Element specificInformation = eInvoiceDataElement.element("SpecificInformation");
            if (specificInformation == null) {
                specificInformation = eInvoiceDataElement.addElement("SpecificInformation");
            }
            Element redEInvoice = specificInformation.addElement("RedEInvoice");
            XmlHelperUtils.addNotEmptyNode(redEInvoice, "OriginalInvoiceCode", fullDigitalEInvoiceXml.getOriginalInvoiceCode());
            XmlHelperUtils.addNotEmptyNode(redEInvoice, "CreditNoteNumber", fullDigitalEInvoiceXml.getCreditNoteNumber());
        }
    }

    private void addConstructionServices(ConstructionServicesItem constructionServicesItem, Element eInvoiceDataElement) {
        if (constructionServicesItem != null) {
            Element specificInformation = eInvoiceDataElement.addElement("SpecificInformation");
            Element constructionServices = specificInformation.addElement("ConstructionServices");
            XmlHelperUtils.addNotEmptyNode(constructionServices, "OccurredSite", constructionServicesItem.getOccurredSite());
            XmlHelperUtils.addNotEmptyNode(constructionServices, "ItemName", constructionServicesItem.getItemName());
            XmlHelperUtils.addNotEmptyNode(constructionServices, "LandValueAddedTaxProjectNumber", constructionServicesItem.getLandValueAddedTaxProjectNumber());
            XmlHelperUtils.addNotEmptyNode(constructionServices, "CrossRegionIdentifier", constructionServicesItem.getCrossRegionIdentifier());
        }
    }

    private void addFreightService(List<CargoTransportItem> cargoTransportList, Element eInvoiceDataElement) {
        if (cargoTransportList != null && !cargoTransportList.isEmpty()) {
            for (CargoTransportItem item : cargoTransportList) {
                Element specificInformation = eInvoiceDataElement.addElement("SpecificInformation");
                Element freightService = specificInformation.addElement("FreightService");
                XmlHelperUtils.addNotEmptyNode(freightService, "FreightService", item.getStartPlace());
                XmlHelperUtils.addNotEmptyNode(freightService, "Destination", item.getEndPlace());
                XmlHelperUtils.addNotEmptyNode(freightService, "TypeOfTransportationMeans", item.getTransportType());
                XmlHelperUtils.addNotEmptyNode(freightService, "TransportationMeansNo", item.getLicensePlate());
                XmlHelperUtils.addNotEmptyNode(freightService, "NameOfGoodsTransported", item.getTransportGoods());
            }
        }
    }

    private void addPassengerTransportation(List<PassengerTransportItem> travelerList, Element eInvoiceDataElement) {
        if (travelerList != null && !travelerList.isEmpty()) {
            for (PassengerTransportItem item : travelerList) {
                Element specificInformation = eInvoiceDataElement.addElement("SpecificInformation");
                Element passengerTransportation = specificInformation.addElement("PassengerTransportation");
                XmlHelperUtils.addNotEmptyNode(passengerTransportation, "Traveler", item.getTraveler());
                XmlHelperUtils.addNotEmptyNode(passengerTransportation, "TravelDate", item.getTravelDate());
                XmlHelperUtils.addNotEmptyNode(passengerTransportation, "Departure", item.getStartPlace());
                XmlHelperUtils.addNotEmptyNode(passengerTransportation, "Destination", item.getEndPlace());
                XmlHelperUtils.addNotEmptyNode(passengerTransportation, "Grade", item.getSeatClass());
                XmlHelperUtils.addNotEmptyNode(passengerTransportation, "Vehicletype", item.getTransportType());
                XmlHelperUtils.addNotEmptyNode(passengerTransportation, "TypeOfPassengerDocument", item.getCardType());
                XmlHelperUtils.addNotEmptyNode(passengerTransportation, "ValidIDNumber", item.getCardNo());
            }
        }
    }

    private void addSaleOfRealEstate(List<RealEstateSalesItem> realEstateSalesItems, Element eInvoiceDataElement, List<BillCoBuyerItemVo> coBuyerItems) {
        if (realEstateSalesItems.size() > 0) {
            Element specificInformation = eInvoiceDataElement.addElement("SpecificInformation");
            for (RealEstateSalesItem realEstateSalesItem : realEstateSalesItems) {
                Element realEstateSales = specificInformation.addElement("RealEstateSales");
                XmlHelperUtils.addNotEmptyNode(realEstateSales, "HouseTitleCertificateNumber", realEstateSalesItem.getHouseTitleCertificateNumber());
                XmlHelperUtils.addNotEmptyNode(realEstateSales, "RealEstateAddress", realEstateSalesItem.getRealEstateAddress());
                XmlHelperUtils.addNotEmptyNode(realEstateSales, "RealEstateUnitNumber", realEstateSalesItem.getRealEstateUnitNumber());
                XmlHelperUtils.addNotEmptyNode(realEstateSales, "RealOnlineContracteNo", realEstateSalesItem.getRealOnlineContracteNo());
                XmlHelperUtils.addNotEmptyNode(realEstateSales, "ActualTransactionAmountIncludingTax", realEstateSalesItem.getActualTransactionAmountIncludingTax());
                XmlHelperUtils.addNotEmptyNode(realEstateSales, "LandValueAddedTaxProjectNumber", realEstateSalesItem.getLandValueAddedTaxProjectNumber());
                XmlHelperUtils.addNotEmptyNode(realEstateSales, "CrossRegionIdentifier", realEstateSalesItem.getCrossRegionIdentifier());
                XmlHelperUtils.addNotEmptyNode(realEstateSales, "ApprovedTaxPrice", realEstateSalesItem.getApprovedTaxPrice());
            }
        }
        if (coBuyerItems.size() > 0) {
            Element coBuyers = eInvoiceDataElement.addElement("CoBuyerInformation");
            for (BillCoBuyerItemVo coBuyerItem : coBuyerItems) {
                Element realCoBuyer = coBuyers.addElement("CoBuyers");
                XmlHelperUtils.addNotEmptyNode(realCoBuyer, "CoBuyer", coBuyerItem.getCoBuyer());
                XmlHelperUtils.addNotEmptyNode(realCoBuyer, "CardType", coBuyerItem.getCardType());
                XmlHelperUtils.addNotEmptyNode(realCoBuyer, "CardNo", coBuyerItem.getCardNo());
            }
        }
    }

    private void addRealEstateOperatingLease(RealEstateLeaseItem realEstateLeaseItem, Element eInvoiceDataElement) {
        if (realEstateLeaseItem != null) {
            Element specificInformation = eInvoiceDataElement.addElement("SpecificInformation");
            Element realEstateLease = specificInformation.addElement("RealEstateLease");
            XmlHelperUtils.addNotEmptyNode(realEstateLease, "HouseTitleCertificateNumber", realEstateLeaseItem.getHouseTitleCertificateNumber());
            XmlHelperUtils.addNotEmptyNode(realEstateLease, "RealEstateAddress", realEstateLeaseItem.getRealEstateAddress());
            XmlHelperUtils.addNotEmptyNode(realEstateLease, "TheLeaseTermBeginsAndEnds", realEstateLeaseItem.getTheLeaseTermBeginsAndEnds());
            XmlHelperUtils.addNotEmptyNode(realEstateLease, "CrossRegionIdentifier", realEstateLeaseItem.getCrossRegionIdentifier());
        }
    }

    private void addTaxationOfVehicleAndVesselUseTax(TaxationOfVehicleAndVesselUseTax vehicleAndShipTaxesItem, Element eInvoiceDataElement) {
        if (vehicleAndShipTaxesItem != null) {
            Element specificInformation = eInvoiceDataElement.addElement("SpecificInformation");
            Element taxationOfVehicleAndVesselUseTax = specificInformation.addElement("TaxationOfVehicleAndVesselUseTax");
            XmlHelperUtils.addNotEmptyNode(taxationOfVehicleAndVesselUseTax, "PolicyNo", vehicleAndShipTaxesItem.getPolicyNo());
            XmlHelperUtils.addNotEmptyNode(taxationOfVehicleAndVesselUseTax, "ClassNO", vehicleAndShipTaxesItem.getClassNo());
            XmlHelperUtils.addNotEmptyNode(taxationOfVehicleAndVesselUseTax, "TaxPeriod", vehicleAndShipTaxesItem.getTaxPeriod());
            XmlHelperUtils.addNotEmptyNode(taxationOfVehicleAndVesselUseTax, "Amount", vehicleAndShipTaxesItem.getAmount());
            XmlHelperUtils.addNotEmptyNode(taxationOfVehicleAndVesselUseTax, "LateFeeAmount", vehicleAndShipTaxesItem.getLateFeeAmount());
            XmlHelperUtils.addNotEmptyNode(taxationOfVehicleAndVesselUseTax, "TotalAmount", vehicleAndShipTaxesItem.getTotalAmount());
            XmlHelperUtils.addNotEmptyNode(taxationOfVehicleAndVesselUseTax, "TheFrameNumber", vehicleAndShipTaxesItem.getTheFrameNumber());
        }
    }

    private void addTractorandHarvesterItem(TractorandHarvesterItem tractorandHarvesterItem, Element eInvoiceDataElement) {
        if (tractorandHarvesterItem != null) {
            Element specificInformation = eInvoiceDataElement.addElement("SpecificInformation");
            Element tractorandHarvester = specificInformation.addElement("TractorandHarvester");
            XmlHelperUtils.addNotEmptyNode(tractorandHarvester, "EngineCode", tractorandHarvesterItem.getEngineCode());
            XmlHelperUtils.addNotEmptyNode(tractorandHarvester, "ChassisCode", tractorandHarvesterItem.getChassisCode());
        }
    }

    private void addAdditionalInformation(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceDataElement) {
        Element additionalInformation = eInvoiceDataElement.addElement("AdditionalInformation");
        XmlHelperUtils.addNotEmptyNode(additionalInformation, "Remark", fullDigitalEInvoiceXml.getRemark());
    }

    private void addSellerAuthentication(Element eInvoiceElement) {
        Element sellerAuthentication = eInvoiceElement.addElement("SellerAuthentication");
        XmlHelperUtils.addNotEmptyNode(sellerAuthentication, "AuthenticationMethods", "01");
    }

    private void addTaxSupervisionInfo(FullDigitalEInvoiceXml fullDigitalEInvoiceXml, Element eInvoiceElement, String areaCode) {
        String[] taxBureauArr;
        String taxBureau = AreaUtil.getTaxBureauMap().get(areaCode);
        String taxBureauCode = null;
        String taxBureauName = null;
        if (StringUtils.isNotEmpty((CharSequence)taxBureau) && (taxBureauArr = taxBureau.split("-")).length == 2) {
            taxBureauCode = taxBureauArr[0];
            taxBureauName = taxBureauArr[1];
        }
        Element taxSupervisionInfo = eInvoiceElement.addElement("TaxSupervisionInfo");
        XmlHelperUtils.addNotEmptyNode(taxSupervisionInfo, "InvoiceNumber", fullDigitalEInvoiceXml.getInvoiceNo());
        XmlHelperUtils.addNotEmptyNode(taxSupervisionInfo, "IssueTime", DateUtils.format(fullDigitalEInvoiceXml.getIssueTime(), "yyyy-MM-dd"));
        XmlHelperUtils.addNotEmptyNode(taxSupervisionInfo, "TaxBureauCode", taxBureauCode);
        XmlHelperUtils.addNotEmptyNode(taxSupervisionInfo, "TaxBureauName", taxBureauName);
    }

    private void addPtbh(String ptbh, Element eInvoiceElement) {
        if (StringUtils.isNotEmpty((CharSequence)ptbh)) {
            XmlHelperUtils.addNotEmptyNode(eInvoiceElement, "ptbh", ptbh);
        }
    }
}

