/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.file.fpy.util;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PDFXmlUtils {
    private static final Log log = LogFactory.getLog(PDFXmlUtils.class);
    private static ConcurrentHashMap<String, Object> cacheXMLInfoMap = new ConcurrentHashMap();

    public static void main(String[] args) {
        JSONObject ss = PDFXmlUtils.getPDFTemplateInfoFromXMLFile("template/full-digital-invoice-pdf.xml");
        System.out.println(ss.toString());
    }

    public static JSONObject getPDFTemplateInfoFromXMLFile(String filePath) {
        File file = new File(filePath);
        String fileName = file.getName();
        if (!cacheXMLInfoMap.containsKey(fileName)) {
            try {
                cacheXMLInfoMap.putIfAbsent(fileName, PDFXmlUtils.getTemplateInfo(PDFXmlUtils.readTempFileStr(filePath)));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return (JSONObject)cacheXMLInfoMap.get(fileName);
    }

    private static JSONObject getTemplateInfo(String xmlStr) {
        return JSONObject.parseObject((String)xmlStr);
    }

    public static String readTempFileStr(String path) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (InputStream fis = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);){
            String lineTxt;
            InputStreamReader read = new InputStreamReader(fis, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(read);
            while ((lineTxt = bufferedReader.readLine()) != null) {
                sb.append(lineTxt);
            }
            read.close();
            fis.close();
        }
        catch (Exception e) {
            throw new FileNotFoundException(String.format(ResManager.loadKDString((String)"\u6a21\u7248\u6587\u4ef6\u4e0d\u5b58\u5728%s", (String)"PDFXmlUtils_1", (String)"imc-bdm-file", (Object[])new Object[0]), path));
        }
        return sb.toString();
    }
}

