/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.file.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.file.fpy.service.pdf.fdei.FullDigitalEInvoicePdfService;
import kd.imc.bdm.file.util.OfdErrorType;
import org.apache.commons.codec.binary.Base64;
import org.apache.pdfbox.jbig2.JBIG2ImageReader;
import org.apache.pdfbox.jbig2.JBIG2ImageReaderSpi;
import org.apache.pdfbox.jbig2.io.DefaultInputStreamFactory;

public class ExportQrCode {
    private static Log LOGGER = LogFactory.getLog(FullDigitalEInvoicePdfService.class);
    private static final String SUFFIX_JB2 = "jb2";

    public static String getImageBase64(byte[] imageByte, String fileSuffix) {
        block41: {
            if (SUFFIX_JB2.equals(fileSuffix)) {
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream(imageByte);
                     ImageInputStream imageInputStream = new DefaultInputStreamFactory().getInputStream((InputStream)inputStream);
                     ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    JBIG2ImageReader imageReader = new JBIG2ImageReader((ImageReaderSpi)new JBIG2ImageReaderSpi());
                    imageReader.setInput(imageInputStream);
                    BufferedImage bufferedImage = imageReader.read(0, imageReader.getDefaultReadParam());
                    ImageIO.write((RenderedImage)bufferedImage, "PNG", out);
                    imageByte = out.toByteArray();
                    break block41;
                }
                catch (Exception e) {
                    LOGGER.error(OfdErrorType.CREATE_QR_CODE_ERROR.getDescription(), (Throwable)e);
                    throw new RuntimeException(OfdErrorType.CREATE_QR_CODE_ERROR.getDescription());
                }
            }
            try {
                imageByte = ExportQrCode.imageToPng(imageByte);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return Base64.encodeBase64String((byte[])imageByte);
    }

    public static byte[] imageToPng(byte[] picBytes) throws IOException {
        BufferedImage input = ImageIO.read(new ByteArrayInputStream(picBytes));
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)input, "PNG", outputStream);
            picBytes = outputStream.toByteArray();
        }
        return picBytes;
    }
}

