/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.dto.ComponentResponse;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.service.ApiLogService;
import kd.imc.bdm.common.service.OpenInvoiceService;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NoHttpResponseException;
import org.apache.http.conn.ConnectTimeoutException;

public class ComponentServiceHelper {
    private static Log LOGGER = LogFactory.getLog(ComponentServiceHelper.class);

    public static String getComponentRequestUrl(String devNo) {
        String remoteUrl = ComponentServiceHelper.getComponentUrl(devNo);
        EquipmentHelper.AsyncSaveDevicesStockData(remoteUrl, devNo);
        return remoteUrl;
    }

    public static String getComponentUrl(String devNo) {
        String remoteUrl = CacheHelper.get("cache_component_request_url");
        if (StringUtils.isBlank((String)remoteUrl)) {
            Map<String, String> config = OpenInvoiceService.getConfig();
            try {
                remoteUrl = config.get("dim_imc_config_component_url");
                remoteUrl = String.format("%s%s", remoteUrl, RequestContext.get().getTenantId());
                CacheHelper.put("cache_component_request_url", remoteUrl, 14400);
            }
            catch (Exception e) {
                LOGGER.error("\u4ece\u7a0e\u63a7\u7cfb\u7edf\u4e91\u83b7\u53d6\u7ec4\u4ef6\u957f\u8fde\u63a5\u5730\u5740\u5931\u8d25", (Throwable)e);
                throw new MsgException(e, String.format(ResManager.loadKDString((String)"\u4ece\u7a0e\u63a7\u7cfb\u7edf\u4e91\u83b7\u53d6\u7ec4\u4ef6\u957f\u8fde\u63a5\u5730\u5740\u5931\u8d25 %s", (String)"ComponentServiceHelper_11", (String)"imc-bdm-common", (Object[])new Object[0]), e.getMessage()));
            }
        }
        remoteUrl = remoteUrl + devNo;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("log_component_url: " + remoteUrl);
        }
        return remoteUrl;
    }

    public static int getReadTime() {
        int READTIME;
        int readTime = READTIME = 120000;
        try {
            String configValue = ImcConfigUtil.getValue("component", "component_read_time");
            if (StringUtils.isBlank((String)configValue)) {
                configValue = String.valueOf(READTIME);
                HashMap<String, String> map = new HashMap<String, String>(1);
                map.put("component_read_time", String.valueOf(READTIME));
                String cacheStr = SerializationUtils.toJsonString(map);
                CacheHelper.put("component", cacheStr, 86400);
            }
            readTime = Integer.parseInt(configValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return readTime;
    }

    public static <T> ComponentResponse<T> doPost(String url, String requestJson, Class<T> tClass) {
        try {
            ApiLogService apiLogService = new ApiLogService("component", url, requestJson);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("log_component_request: " + requestJson);
            }
            int readTime = ComponentServiceHelper.getReadTime();
            String response = HttpUtil.doPostJson(url, null, ComponentServiceHelper.setTraceId2Request(requestJson, readTime), readTime, readTime);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("log_component_response: " + response);
            }
            apiLogService.saveLog(response);
            if (StringUtils.isEmpty((String)response) || response.equals("{}")) {
                return new ComponentResponse<Object>("9999", ResManager.loadKDString((String)"\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u53d1\u7968\u4e91\u5ba2\u6237\u7aef\u8fde\u63a5\u72b6\u6001", (String)"ComponentServiceHelper_13", (String)"imc-bdm-common", (Object[])new Object[0]), null, null, null);
            }
            JSONObject jsonObject = JSONObject.parseObject((String)response);
            String errcode = jsonObject.getString("errcode");
            String description = jsonObject.getString("description");
            if (StringUtils.isNotEmpty((String)description) && description.contains("<returnmsg>")) {
                description = description.substring(description.indexOf("<returnmsg>"), description.indexOf("</returnmsg>"));
            }
            Integer zjls = 0;
            if (jsonObject.containsKey((Object)"zjls")) {
                zjls = jsonObject.getInteger("zjls");
            }
            if (jsonObject.containsKey((Object)"sjd")) {
                response = jsonObject.getString("sjd");
            } else if (jsonObject.containsKey((Object)"data")) {
                response = jsonObject.getString("data");
            }
            Object tobj = JSONObject.parseObject((String)response, tClass);
            List tobjs = new ArrayList();
            if (jsonObject.containsKey((Object)"lists")) {
                tobjs = JSONArray.parseArray((String)jsonObject.getString("lists"), tClass);
            }
            return new ComponentResponse<Object>(errcode, description, zjls, tobj, tobjs);
        }
        catch (NoHttpResponseException e) {
            LOGGER.error("do component request error,caused by ", (Throwable)e);
            return new ComponentResponse("9999", ResManager.loadKDString((String)"NoHttpResponseException,\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"ComponentServiceHelper_14", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        catch (ConnectTimeoutException e) {
            LOGGER.error("do component request error,caused by ", (Throwable)e);
            return new ComponentResponse("9999", ResManager.loadKDString((String)"\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"ComponentServiceHelper_15", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        catch (SocketTimeoutException e) {
            LOGGER.error("do component request error,caused by ", (Throwable)e);
            return new ComponentResponse("9999", ResManager.loadKDString((String)"\u54cd\u5e94\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"ComponentServiceHelper_16", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        catch (MsgException e) {
            LOGGER.error("do component request error,caused by ", (Throwable)e);
            return new ComponentResponse("9999", e.getErrorMsg());
        }
        catch (Exception e) {
            LOGGER.error("do component request error,caused by ", (Throwable)e);
            return new ComponentResponse("9999", String.format(ResManager.loadKDString((String)"\u5185\u90e8\u5904\u7406\u5f02\u5e38\uff0ctraceid\u4e3a[%s]", (String)"ComponentServiceHelper_6", (String)"imc-bdm-common", (Object[])new Object[0]), RequestContext.get().getTraceId()));
        }
    }

    public static JSONObject doPost(String url, String requestJson) {
        JSONObject jsonObject;
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("log_component_request: " + requestJson);
            }
            ApiLogService apiLogService = new ApiLogService("component", url, requestJson);
            int readTime = ComponentServiceHelper.getReadTime();
            String response = HttpUtil.doPostJson(url, null, ComponentServiceHelper.setTraceId2Request(requestJson, readTime), readTime, readTime);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("log_component_response: " + response);
            }
            apiLogService.saveLog(response);
            if (StringUtils.isEmpty((String)response)) {
                throw new MsgException(ResManager.loadKDString((String)"\u4e0e\u7a0e\u63a7\u7cfb\u7edf\u901a\u8baf\u5931\u8d25\uff0c\u4e3a\u4fdd\u8bc1\u6570\u636e\u4e00\u81f4\uff0c\u8bf7\u91cd\u8bd5", (String)"ComponentServiceHelper_7", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
            jsonObject = JSONObject.parseObject((String)response);
        }
        catch (NoHttpResponseException e) {
            LOGGER.error("do component request error,caused by ", (Throwable)e);
            throw new MsgException(e, ResManager.loadKDString((String)"NoHttpResponseException\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"ComponentServiceHelper_8", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        catch (ConnectTimeoutException e) {
            LOGGER.error("do component request error,caused by ", (Throwable)e);
            throw new MsgException(e, ResManager.loadKDString((String)"\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"ComponentServiceHelper_4", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        catch (SocketTimeoutException e) {
            LOGGER.error("do component request error,caused by ", (Throwable)e);
            throw new MsgException(e, ResManager.loadKDString((String)"\u54cd\u5e94\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"ComponentServiceHelper_5", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        catch (ConnectException e) {
            throw new MsgException(e, "java.net.ConnectException: Connection timed out");
        }
        catch (Exception e) {
            LOGGER.error("log_component_request\u5f02\u5e38: ", (Throwable)e);
            throw new MsgException(e, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u8bf7\u6c42\u5f02\u5e38_%s", (String)"ComponentServiceHelper_12", (String)"imc-bdm-common", (Object[])new Object[0]), e.getMessage()));
        }
        return jsonObject;
    }

    private static String setTraceId2Request(String requestStr, int readTime) {
        try {
            JSONObject request = JSONObject.parseObject((String)requestStr);
            request.put("traceId", (Object)RequestContext.get().getTraceId());
            request.put("readTime", (Object)readTime);
            requestStr = JSONObject.toJSONString((Object)request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return requestStr;
    }
}

