/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.constant.ComponentInterfaceTypeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.RequestUtils;

public class DataRepairHelper {
    private static final Log LOGGER = LogFactory.getLog(DataRepairHelper.class);
    public static final String SECRET = "secret";

    public static MsgResponse repairPdf(DynamicObject invoice) {
        JSONObject sjd;
        JSONObject json;
        MsgResponse componentResponse = new MsgResponse();
        componentResponse.setErrorCode(ErrorType.FAIL.getCode());
        String requestData = DataRepairHelper.buildComponetRequest5(invoice);
        if (UnitTestHelper.isUnitTest()) {
            json = new JSONObject();
            json.put("errcode", (Object)"7011");
            sjd = new JSONObject();
            json.put("sjd", (Object)sjd);
        } else {
            json = ComponentServiceHelper.doPost(ComponentServiceHelper.getComponentRequestUrl(invoice.getString("jqbh")), requestData);
        }
        if ("7011".equals(json.getString("errcode"))) {
            sjd = json.getJSONObject("sjd");
            Object checkCode = sjd.get((Object)"checkcode");
            invoice.set("checkcode", checkCode);
            String skm = sjd.getString(SECRET);
            invoice.set("skm", (Object)skm);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{invoice});
            componentResponse.setErrorCode(ErrorType.SUCCESS.getCode());
        }
        return componentResponse;
    }

    public static String buildComponetRequest5(DynamicObject invoice) {
        JSONObject json = new JSONObject();
        json.put("czlx", (Object)ComponentInterfaceTypeEnum.INVOICE_QUERY.getCzlx());
        JSONObject sjd = new JSONObject();
        sjd.put("kpzl", (Object)InvoiceType.getTypeCodeHx(invoice.getString("invoicetype")));
        sjd.put("fpdm", (Object)invoice.getString("invoicecode"));
        sjd.put("fphm", (Object)invoice.getString("invoiceno"));
        json.put("sjd", (Object)sjd);
        json.put("hxbzdh", (Object)(StringUtils.isEmpty((CharSequence)invoice.getString("terminalno")) ? "" : invoice.getString("terminalno")));
        return json.toString();
    }

    public static MsgResponse repairIsmcInvoiceData(DynamicObject invoiceDynamicObject) {
        if (!"3".equals(invoiceDynamicObject.getString("issuesource"))) {
            if (invoiceDynamicObject.get("orgid") instanceof DynamicObject) {
                invoiceDynamicObject.set("orgid", invoiceDynamicObject.getDynamicObject("orgid").get("id"));
            }
            MsgResponse msgResponse = RequestUtils.doRequest(invoiceDynamicObject.getString("orderno"), "RepairInvoice", Collections.singletonList(invoiceDynamicObject));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("imc_sync_component_invoice_" + msgResponse.getErrorMsg());
            }
            return msgResponse;
        }
        MsgResponse response = new MsgResponse();
        response.setErrorCode("0001");
        response.setErrorMsg(ResManager.loadKDString((String)"\u865a\u62dfukey\u6240\u5f00\u53d1\u7968\u4e0d\u652f\u6301\u4fee\u590d", (String)"DataRepairHelper_0", (String)"imc-bdm-common", (Object[])new Object[0]));
        return response;
    }

    public static void asyncRepairImcAndIsmcData(DynamicObject invoice) {
        ThreadPools.executeOnceIncludeRequestContext((String)"saveDeviceStockData", () -> DataRepairHelper.repairImcAndIsmcData(invoice));
    }

    public static MsgResponse repairImcAndIsmcData(DynamicObject invoice) {
        MsgResponse result = new MsgResponse();
        String invoiceCode = invoice.getString("invoicecode");
        String invoiceNo = invoice.getString("invoiceno");
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            MsgResponse imcResponse = DataRepairHelper.repairPdf(invoice);
            if (!ErrorType.SUCCESS.getCode().equals(imcResponse.getErrorCode())) {
                throw new KDBizException(imcResponse.getErrorMsg());
            }
            LOGGER.info(String.format("\u53d1\u7968\u4ee3\u7801\uff1a%s,\u53d1\u7968\u53f7\u7801:%s\u5b8c\u6210\u53d1\u7968\u4e91\u6570\u636e\u4fee\u590d", invoiceCode, invoiceNo));
            invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"sim_vatinvoice");
            MsgResponse ismcResponse = DataRepairHelper.repairIsmcInvoiceData(invoice);
            if (ErrorType.DATA_NOT_FOUND_IN_ISMC.getCode().equals(ismcResponse.getErrorCode())) {
                QFilter invoiceFilter = new QFilter("invoicecode", "=", (Object)invoiceCode).and(new QFilter("invoiceno", "=", (Object)invoiceNo));
                DeleteServiceHelper.delete((String)"sim_repair_invoice", (QFilter[])invoiceFilter.toArray());
            }
            if (!ErrorType.SUCCESS.getCode().equals(ismcResponse.getErrorCode())) {
                throw new Exception(ismcResponse.getErrorMsg());
            }
            LOGGER.info(String.format("\u53d1\u7968\u4ee3\u7801\uff1a%s,\u53d1\u7968\u53f7\u7801:%s\u5b8c\u6210\u53d1\u7968\u4e91\u6570\u636e\u4fee\u590d\u548c\u7a0e\u63a7\u7cfb\u7edf\u4e91\u6570\u636e\u4fee\u590d\uff0c\u5e76\u53d1\u9001\u7a0e\u63a7\u7cfb\u7edf\u4e91\u91cd\u65b0\u751f\u6210\u53d1\u7968\u6587\u4ef6\u7684\u6d88\u606f", invoiceCode, invoiceNo));
            MsgResponse msgResponse = ismcResponse;
            return msgResponse;
        }
        catch (Throwable e) {
            tx.markRollback();
            LOGGER.error("\u53d1\u7968\u4fee\u590d\u5931\u8d25\uff0c\u89e6\u53d1\u4e8b\u52a1\u56de\u6eda", e);
            result.setErrorCode(ErrorType.FAIL.getCode());
            result.setErrorMsg(e.getMessage());
        }
        return result;
    }

    public static MsgResponse recreateInvoiceFile(DynamicObject invoice) {
        MsgResponse result = new MsgResponse();
        try {
            MsgResponse ismcResponse = DataRepairHelper.repairIsmcInvoiceData(invoice);
            if ("3333".equals(ismcResponse.getErrorCode())) {
                DataRepairHelper.deleteRepairData(invoice);
                return ismcResponse;
            }
            if (!ErrorType.SUCCESS.getCode().equals(ismcResponse.getErrorCode())) {
                throw new Exception(ismcResponse.getErrorMsg());
            }
            return ismcResponse;
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u7968\u4fee\u590d\u5931\u8d25", (Throwable)e);
            result.setErrorCode(ErrorType.FAIL.getCode());
            result.setErrorMsg(e.getMessage());
        }
        catch (Throwable t) {
            LOGGER.error("\u53d1\u7968\u4fee\u590d\u5931\u8d25", t);
            throw t;
        }
        return result;
    }

    private static void deleteRepairData(DynamicObject invoice) {
        QFilter orderNoFilter = new QFilter("orderno", "=", (Object)invoice.getString("orderno"));
        DeleteServiceHelper.delete((String)"sim_repair_invoice", (QFilter[])orderNoFilter.toArray());
    }
}

